/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.arg;

import java.security.Principal;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletRequest;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.rest.arg.CookieList;
import org.apache.juneau.rest.arg.SimpleRestOperationArg;
import org.apache.juneau.utils.ThrowingFunction;

public class HttpServletRequestArgs
extends SimpleRestOperationArg {
    public static HttpServletRequestArgs create(ParamInfo paramInfo) {
        if (paramInfo.isType(AsyncContext.class)) {
            return new HttpServletRequestArgs(x -> x.getAsyncContext());
        }
        if (paramInfo.isType(CookieList.class)) {
            return new HttpServletRequestArgs(x -> CookieList.of(x.getCookies()));
        }
        if (paramInfo.isType(DispatcherType.class)) {
            return new HttpServletRequestArgs(x -> x.getDispatcherType());
        }
        if (paramInfo.isType(HttpServletRequest.class)) {
            return new HttpServletRequestArgs(x -> x);
        }
        if (paramInfo.isType(Principal.class)) {
            return new HttpServletRequestArgs(x -> x.getUserPrincipal());
        }
        return null;
    }

    protected <T> HttpServletRequestArgs(ThrowingFunction<HttpServletRequest, T> function) {
        super(session -> function.apply((Object)session.getRequest().getHttpServletRequest()));
    }
}

