/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.encoders;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderMatch;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.http.header.AcceptEncoding;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.ThrowableUtils;

public final class EncoderSet {
    private final ConcurrentHashMap<String, EncoderMatch> cache = new ConcurrentHashMap();
    private final List<String> encodings;
    private final Encoder[] encodingsEncoders;
    private final Encoder[] entries;

    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    public static Builder create() {
        return new Builder(BeanStore.INSTANCE);
    }

    protected EncoderSet(Builder builder) {
        this.entries = (Encoder[])builder.entries.stream().map(x -> EncoderSet.instantiate(builder.beanStore(), x)).toArray(Encoder[]::new);
        ArrayList<String> lc = CollectionUtils.list(new String[0]);
        ArrayList<Encoder> l = CollectionUtils.list(new Encoder[0]);
        for (Encoder e : this.entries) {
            for (String c : e.getCodings()) {
                lc.add(c);
                l.add(e);
            }
        }
        this.encodings = CollectionUtils.unmodifiable(lc);
        this.encodingsEncoders = l.toArray(new Encoder[l.size()]);
    }

    private static Encoder instantiate(BeanStore bs, Object o) {
        if (o instanceof Encoder) {
            return (Encoder)o;
        }
        try {
            return bs.createBean(Encoder.class).type((Class)o).run();
        }
        catch (ExecutableException e) {
            throw ThrowableUtils.runtimeException(e);
        }
    }

    public EncoderMatch getEncoderMatch(String acceptEncoding) {
        EncoderMatch em = this.cache.get(acceptEncoding);
        if (em != null) {
            return em;
        }
        AcceptEncoding ae = HttpHeaders.acceptEncoding(acceptEncoding);
        int match = ae.match(this.encodings);
        if (match >= 0) {
            em = new EncoderMatch(this.encodings.get(match), this.encodingsEncoders[match]);
            this.cache.putIfAbsent(acceptEncoding, em);
        }
        return this.cache.get(acceptEncoding);
    }

    public Encoder getEncoder(String encoding) {
        EncoderMatch em = this.getEncoderMatch(encoding);
        return em == null ? null : em.getEncoder();
    }

    public List<String> getSupportedEncodings() {
        return this.encodings;
    }

    @FluentSetters
    public static class Builder
    extends BeanBuilder<EncoderSet> {
        List<Object> entries;
        Builder inheritFrom;

        protected Builder(BeanStore beanStore) {
            super(EncoderSet.class, beanStore);
            this.entries = CollectionUtils.list(new Object[0]);
        }

        protected Builder(Builder copyFrom) {
            super(copyFrom);
            this.entries = CollectionUtils.copyOf(copyFrom.entries);
        }

        @Override
        protected EncoderSet buildDefault() {
            return new EncoderSet(this);
        }

        public Builder copy() {
            return new Builder(this);
        }

        public Builder add(Class<?> ... values) {
            ArrayList<Object> l = CollectionUtils.list(new Object[0]);
            for (Class<?> v : values) {
                if (!v.getSimpleName().equals("NoInherit")) continue;
                this.clear();
            }
            for (Class<?> v : values) {
                if (Encoder.class.isAssignableFrom(v)) {
                    l.add(v);
                    continue;
                }
                if (v.getSimpleName().equals("NoInherit")) continue;
                throw ThrowableUtils.illegalArgumentException("Invalid type passed to EncoderSet.Builder.add(): " + v.getName(), new Object[0]);
            }
            this.entries.addAll(0, l);
            return this;
        }

        public Builder set(Class<?> ... values) {
            ArrayList<Object> l = CollectionUtils.list(new Object[0]);
            for (Class<?> v : values) {
                if (v.getSimpleName().equals("Inherit")) {
                    l.addAll(this.entries);
                    continue;
                }
                if (Encoder.class.isAssignableFrom(v)) {
                    l.add(v);
                    continue;
                }
                throw ThrowableUtils.illegalArgumentException("Invalid type passed to EncoderSet.Builder.set(): " + v.getName(), new Object[0]);
            }
            this.entries = l;
            return this;
        }

        public Builder add(Encoder ... values) {
            CollectionUtils.prependAll(this.entries, (Object[])values);
            return this;
        }

        public Builder clear() {
            this.entries.clear();
            return this;
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public List<Object> inner() {
            return this.entries;
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }

        public String toString() {
            return this.entries.stream().map(x -> Builder.toString(x)).collect(Collectors.joining(",", "[", "]"));
        }

        private static String toString(Object o) {
            if (o == null) {
                return "null";
            }
            if (o instanceof Class) {
                return "class:" + ((Class)o).getSimpleName();
            }
            return "object:" + o.getClass().getSimpleName();
        }
    }

    public static abstract class NoInherit
    extends Encoder {
    }

    public static abstract class Inherit
    extends Encoder {
    }
}

