/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.annotation;

import java.lang.reflect.Method;
import java.nio.charset.Charset;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.Enablement;
import org.apache.juneau.annotation.TargetedAnnotationBuilder;
import org.apache.juneau.annotation.TargetedAnnotationImpl;
import org.apache.juneau.annotation.TargetedAnnotationMBuilder;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.http.HttpParts;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.rest.RestOpContext;
import org.apache.juneau.rest.annotation.OpSwagger;
import org.apache.juneau.rest.annotation.OpSwaggerAnnotation;
import org.apache.juneau.rest.annotation.RestDelete;
import org.apache.juneau.rest.guard.RestGuard;
import org.apache.juneau.rest.httppart.BasicNamedAttribute;
import org.apache.juneau.rest.httppart.NamedAttribute;
import org.apache.juneau.rest.matcher.RestMatcher;
import org.apache.juneau.svl.VarResolverSession;

public class RestDeleteAnnotation {
    public static final RestDelete DEFAULT = RestDeleteAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static class RestOpContextApply
    extends AnnotationApplier<RestDelete, RestOpContext.Builder> {
        public RestOpContextApply(VarResolverSession vr) {
            super(RestDelete.class, RestOpContext.Builder.class, vr);
        }

        public void apply(AnnotationInfo<RestDelete> ai, RestOpContext.Builder b) {
            RestDelete a = (RestDelete)ai.inner();
            b.httpMethod("delete");
            this.classes(a.encoders()).ifPresent(x -> b.encoders().set(x));
            this.type(a.contextClass()).ifPresent(x -> b.type((Class)x));
            this.stream(a.defaultRequestHeaders()).map(x -> HttpHeaders.stringHeader((String)x)).forEach(x -> b.defaultRequestHeaders().setDefault((Header)x));
            this.stream(a.defaultResponseHeaders()).map(x -> HttpHeaders.stringHeader((String)x)).forEach(x -> b.defaultResponseHeaders().setDefault((Header)x));
            this.stream(a.defaultRequestAttributes()).map(x -> BasicNamedAttribute.ofPair(x)).forEach(x -> b.defaultRequestAttributes().add((NamedAttribute)x));
            this.stream(a.defaultRequestQueryData()).map(x -> HttpParts.basicPart((String)x)).forEach(x -> b.defaultRequestQueryData().setDefault((NameValuePair)x));
            this.string(a.defaultAccept()).map(x -> HttpHeaders.accept((String)x)).ifPresent(x -> b.defaultRequestHeaders().setDefault((Header)x));
            b.guards().append(a.guards());
            b.matchers().append(a.matchers());
            this.string(a.clientVersion()).ifPresent(x -> b.clientVersion((String)x));
            this.string(a.defaultCharset()).map(Charset::forName).ifPresent(x -> b.defaultCharset((Charset)x));
            this.stream(a.path()).forEach(x -> b.path((String)x));
            this.string(a.value()).ifPresent(x -> b.path((String)x));
            this.cdl(a.rolesDeclared()).forEach(x -> b.rolesDeclared((String)x));
            this.string(a.roleGuard()).ifPresent(x -> b.roleGuard((String)x));
            this.string(a.debug()).map(Enablement::fromString).ifPresent(x -> b.debug((Enablement)x));
        }
    }

    private static class Impl
    extends TargetedAnnotationImpl
    implements RestDelete {
        private final Class<? extends RestGuard>[] guards;
        private final Class<? extends RestMatcher>[] matchers;
        private final Class<? extends RestOpContext> contextClass;
        private final Class<? extends Encoder>[] encoders;
        private final OpSwagger swagger;
        private final String clientVersion;
        private final String debug;
        private final String defaultAccept;
        private final String defaultCharset;
        private final String rolesDeclared;
        private final String roleGuard;
        private final String summary;
        private final String value;
        private final String[] defaultRequestQueryData;
        private final String[] defaultRequestAttributes;
        private final String[] defaultRequestHeaders;
        private final String[] defaultResponseHeaders;
        private final String[] description;
        private final String[] path;

        Impl(Builder b) {
            super((TargetedAnnotationBuilder)b);
            this.clientVersion = b.clientVersion;
            this.contextClass = b.contextClass;
            this.debug = b.debug;
            this.defaultAccept = b.defaultAccept;
            this.defaultCharset = b.defaultCharset;
            this.defaultRequestQueryData = (String[])ArrayUtils.copyOf((Object[])b.defaultRequestQueryData);
            this.defaultRequestAttributes = (String[])ArrayUtils.copyOf((Object[])b.defaultRequestAttributes);
            this.defaultRequestHeaders = (String[])ArrayUtils.copyOf((Object[])b.defaultRequestHeaders);
            this.defaultResponseHeaders = (String[])ArrayUtils.copyOf((Object[])b.defaultResponseHeaders);
            this.description = (String[])ArrayUtils.copyOf((Object[])b.description);
            this.encoders = (Class[])ArrayUtils.copyOf((Object[])b.encoders);
            this.guards = (Class[])ArrayUtils.copyOf((Object[])b.guards);
            this.matchers = (Class[])ArrayUtils.copyOf((Object[])b.matchers);
            this.path = (String[])ArrayUtils.copyOf((Object[])b.path);
            this.roleGuard = b.roleGuard;
            this.rolesDeclared = b.rolesDeclared;
            this.summary = b.summary;
            this.swagger = b.swagger;
            this.value = b.value;
            this.postConstruct();
        }

        @Override
        public String clientVersion() {
            return this.clientVersion;
        }

        @Override
        public Class<? extends RestOpContext> contextClass() {
            return this.contextClass;
        }

        @Override
        public String debug() {
            return this.debug;
        }

        @Override
        public String defaultAccept() {
            return this.defaultAccept;
        }

        @Override
        public String defaultCharset() {
            return this.defaultCharset;
        }

        @Override
        public String[] defaultRequestQueryData() {
            return this.defaultRequestQueryData;
        }

        @Override
        public String[] defaultRequestAttributes() {
            return this.defaultRequestAttributes;
        }

        @Override
        public String[] defaultRequestHeaders() {
            return this.defaultRequestHeaders;
        }

        @Override
        public String[] defaultResponseHeaders() {
            return this.defaultResponseHeaders;
        }

        @Override
        public String[] description() {
            return this.description;
        }

        @Override
        public Class<? extends Encoder>[] encoders() {
            return this.encoders;
        }

        @Override
        public Class<? extends RestGuard>[] guards() {
            return this.guards;
        }

        @Override
        public Class<? extends RestMatcher>[] matchers() {
            return this.matchers;
        }

        @Override
        public String[] path() {
            return this.path;
        }

        @Override
        public String roleGuard() {
            return this.roleGuard;
        }

        @Override
        public String rolesDeclared() {
            return this.rolesDeclared;
        }

        @Override
        public String summary() {
            return this.summary;
        }

        @Override
        public OpSwagger swagger() {
            return this.swagger;
        }

        @Override
        public String value() {
            return this.value;
        }
    }

    public static class Builder
    extends TargetedAnnotationMBuilder {
        Class<? extends RestGuard>[] guards = new Class[0];
        Class<? extends RestMatcher>[] matchers = new Class[0];
        Class<? extends RestOpContext> contextClass = RestOpContext.Void.class;
        Class<? extends Encoder>[] encoders = new Class[0];
        OpSwagger swagger = OpSwaggerAnnotation.DEFAULT;
        String clientVersion = "";
        String debug = "";
        String defaultAccept = "";
        String defaultCharset = "";
        String rolesDeclared = "";
        String roleGuard = "";
        String summary = "";
        String value = "";
        String[] defaultRequestQueryData = new String[0];
        String[] defaultRequestAttributes = new String[0];
        String[] defaultRequestHeaders = new String[0];
        String[] defaultResponseHeaders = new String[0];
        String[] description = new String[0];
        String[] path = new String[0];

        protected Builder() {
            super(RestDelete.class);
        }

        public RestDelete build() {
            return new Impl(this);
        }

        public Builder clientVersion(String value) {
            this.clientVersion = value;
            return this;
        }

        public Builder contextClass(Class<? extends RestOpContext> value) {
            this.contextClass = value;
            return this;
        }

        public Builder debug(String value) {
            this.debug = value;
            return this;
        }

        public Builder defaultAccept(String value) {
            this.defaultAccept = value;
            return this;
        }

        public Builder defaultCharset(String value) {
            this.defaultCharset = value;
            return this;
        }

        public Builder defaultRequestQueryData(String ... value) {
            this.defaultRequestQueryData = value;
            return this;
        }

        public Builder defaultRequestAttributes(String ... value) {
            this.defaultRequestAttributes = value;
            return this;
        }

        public Builder defaultRequestHeaders(String ... value) {
            this.defaultRequestHeaders = value;
            return this;
        }

        public Builder defaultResponseHeaders(String ... value) {
            this.defaultResponseHeaders = value;
            return this;
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder encoders(Class<? extends Encoder> ... value) {
            this.encoders = value;
            return this;
        }

        public Builder guards(Class<? extends RestGuard> ... value) {
            this.guards = value;
            return this;
        }

        public Builder matchers(Class<? extends RestMatcher> ... value) {
            this.matchers = value;
            return this;
        }

        public Builder path(String ... value) {
            this.path = value;
            return this;
        }

        public Builder roleGuard(String value) {
            this.roleGuard = value;
            return this;
        }

        public Builder rolesDeclared(String value) {
            this.rolesDeclared = value;
            return this;
        }

        public Builder summary(String value) {
            this.summary = value;
            return this;
        }

        public Builder swagger(OpSwagger value) {
            this.swagger = value;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder on(String ... values) {
            super.on(values);
            return this;
        }

        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }
    }
}

