/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.processor;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.header.BasicHeader;
import org.apache.juneau.http.header.SerializedHeader;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.httppart.bean.ResponseBeanPropertyMeta;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.processor.ResponseProcessor;

public final class ResponseBeanProcessor
implements ResponseProcessor {
    @Override
    public int process(RestOpSession opSession) throws IOException {
        ResponseBeanPropertyMeta stm;
        RestRequest req = opSession.getRequest();
        RestResponse res = opSession.getResponse();
        HttpPartSerializer defaultPartSerializer = req.getOpContext().getPartSerializer();
        Object output = res.getContent(Object.class);
        if (output == null || output.getClass().getAnnotation(Response.class) == null && res.getResponseBeanMeta() == null) {
            return 0;
        }
        ResponseBeanMeta rm = res.getResponseBeanMeta();
        if (rm == null) {
            rm = req.getOpContext().getResponseBeanMeta(output);
        }
        if ((stm = rm.getStatusMethod()) != null) {
            try {
                res.setStatus((Integer)stm.getGetter().invoke(output, new Object[0]));
            }
            catch (Exception e) {
                throw new InternalServerError(e, "Could not get status.", new Object[0]);
            }
        } else if (rm.getCode() != 0) {
            res.setStatus(rm.getCode());
        }
        for (ResponseBeanPropertyMeta hm : rm.getHeaderMethods()) {
            String n = hm.getPartName().orElse(null);
            try {
                Object o = hm.getGetter().invoke(output, new Object[0]);
                HttpPartSchema ps = hm.getSchema();
                if ("*".equals(n)) {
                    for (Object o2 : this.iterate(o)) {
                        Header h = null;
                        if (o2 instanceof Map.Entry) {
                            Map.Entry x = (Map.Entry)o2;
                            String k = StringUtils.stringify(x.getKey());
                            h = new SerializedHeader(k, x.getValue(), hm.getSerializer().orElse(defaultPartSerializer).getPartSession(), ps.getProperty(k), true);
                        } else if (o2 instanceof Header) {
                            h = (Header)o2;
                        } else if (o2 instanceof NameValuePair) {
                            h = BasicHeader.of((NameValuePair)o2);
                        } else {
                            throw new InternalServerError("Invalid type ''{0}'' for header ''{1}''", ClassUtils.className(o2), n);
                        }
                        res.addHeader(h);
                    }
                    continue;
                }
                Header h = null;
                h = o instanceof Header ? (Header)o : (o instanceof NameValuePair ? BasicHeader.of((NameValuePair)o) : new SerializedHeader(n, o, hm.getSerializer().orElse(defaultPartSerializer).getPartSession(), ps, true));
                res.addHeader(h);
            }
            catch (Exception e) {
                throw new InternalServerError(e, "Could not set header ''{0}''", n);
            }
        }
        ResponseBeanPropertyMeta bm = rm.getContentMethod();
        if (bm != null) {
            Method m = bm.getGetter();
            try {
                Class<?>[] pt = m.getParameterTypes();
                if (pt.length == 1) {
                    Class<?> ptt = pt[0];
                    if (ptt == OutputStream.class) {
                        m.invoke(output, res.getOutputStream());
                    } else if (ptt == Writer.class) {
                        m.invoke(output, res.getWriter());
                    }
                    return 1;
                }
                res.setContent(m.invoke(output, new Object[0]));
            }
            catch (Exception e) {
                throw new InternalServerError(e, "Could not get content.", new Object[0]);
            }
        }
        return 0;
    }

    private Iterable<?> iterate(Object o) {
        if (o == null) {
            return Collections.emptyList();
        }
        if (o instanceof Map) {
            return ((Map)o).entrySet();
        }
        if (o.getClass().isArray()) {
            return CollectionUtils.alist((Object[])o);
        }
        if (o instanceof Collection) {
            return (Collection)o;
        }
        throw new InternalServerError("Could not iterate over Headers of type ''{0}''", ClassUtils.className(o));
    }
}

