/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.logging;

import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.juneau.assertions.StringAssertion;
import org.apache.juneau.assertions.ThrowableAssertion;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.rest.logging.BasicRestLogger;
import org.apache.juneau.rest.logging.RestLogger;
import org.apache.juneau.rest.logging.RestLoggerRule;
import org.apache.juneau.rest.logging.RestLoggingDetail;

public class BasicTestCaptureRestLogger
extends BasicRestLogger {
    private AtomicReference<LogRecord> lastRecord = new AtomicReference();

    public BasicTestCaptureRestLogger(RestLogger.Builder builder) {
        super(builder);
    }

    public BasicTestCaptureRestLogger() {
        super(BasicTestCaptureRestLogger.builder());
    }

    private static RestLogger.Builder builder() {
        BeanStore bs = BeanStore.INSTANCE;
        return RestLogger.create(bs).normalRules((RestLoggerRule)RestLoggerRule.create(bs).statusFilter(x -> x >= 500).level(Level.SEVERE).requestDetail(RestLoggingDetail.HEADER).responseDetail(RestLoggingDetail.HEADER).build(), (RestLoggerRule)RestLoggerRule.create(bs).statusFilter(x -> x >= 400).level(Level.WARNING).requestDetail(RestLoggingDetail.STATUS_LINE).responseDetail(RestLoggingDetail.STATUS_LINE).build()).debugRules((RestLoggerRule)RestLoggerRule.create(bs).level(Level.SEVERE).requestDetail(RestLoggingDetail.ENTITY).responseDetail(RestLoggingDetail.ENTITY).build());
    }

    @Override
    protected void log(Level level, String msg, Throwable e) {
        LogRecord r = new LogRecord(level, msg);
        r.setThrown(e);
        this.lastRecord.set(r);
    }

    public String getMessage() {
        LogRecord r = this.lastRecord.get();
        return r == null ? null : r.getMessage();
    }

    public String getMessageAndReset() {
        String msg = this.getMessage();
        this.reset();
        return msg;
    }

    public StringAssertion assertMessage() {
        return new StringAssertion(this.getMessage());
    }

    public StringAssertion assertMessageAndReset() {
        return new StringAssertion(this.getMessageAndReset());
    }

    public Level getLevel() {
        LogRecord r = this.lastRecord.get();
        return r == null ? null : r.getLevel();
    }

    public Throwable getThrown() {
        LogRecord r = this.lastRecord.get();
        return r == null ? null : r.getThrown();
    }

    public ThrowableAssertion<Throwable> assertThrown() {
        return new ThrowableAssertion<Throwable>(this.getThrown());
    }

    public BasicTestCaptureRestLogger reset() {
        this.lastRecord.set(null);
        return this;
    }
}

