/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;

public class EntityTag {
    private final String value;
    private final boolean isWeak;
    private final boolean isAny;

    public static EntityTag of(Object value) {
        Object o = ObjectUtils.unwrap(value);
        return o == null ? null : new EntityTag(o.toString());
    }

    public EntityTag(String value) {
        Assertions.assertArgNotNull("value", value);
        value = StringUtils.trim(StringUtils.emptyIfNull(value));
        this.isWeak = value.startsWith("W/");
        this.isAny = "*".equals(value);
        if (!this.isAny) {
            if (this.isWeak) {
                value = value.substring(2);
            }
            if (value.length() > 1 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                value = value.substring(1, value.length() - 1);
            } else {
                throw ThrowableUtils.illegalArgumentException("Invalid value for entity-tag: [{0}]", this.isWeak ? "W/" + value : value);
            }
        }
        this.value = value;
    }

    public String getEntityValue() {
        return this.value;
    }

    public boolean isWeak() {
        return this.isWeak;
    }

    public boolean isAny() {
        return this.isAny;
    }

    public String toString() {
        return (this.isWeak ? "W/" : "") + (this.isAny() ? "*" : '\"' + this.value + '\"');
    }
}

