/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.entity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.http.entity.BasicHttpEntity;
import org.apache.juneau.http.entity.HttpEntityBuilder;
import org.apache.juneau.internal.IOUtils;

public class ByteArrayEntity
extends BasicHttpEntity {
    private static final byte[] EMPTY = new byte[0];

    public static HttpEntityBuilder<ByteArrayEntity> create() {
        return new HttpEntityBuilder<Class<ByteArrayEntity>>(ByteArrayEntity.class);
    }

    public ByteArrayEntity(HttpEntityBuilder<?> builder) {
        super(builder);
    }

    public HttpEntityBuilder<ByteArrayEntity> copy() {
        return new HttpEntityBuilder<ByteArrayEntity>(this);
    }

    private byte[] bytes() {
        return this.contentOrElse(EMPTY);
    }

    @Override
    public String asString() throws IOException {
        return new String(this.bytes(), IOUtils.UTF8);
    }

    @Override
    public byte[] asBytes() throws IOException {
        return this.bytes();
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public long getContentLength() {
        return this.isSupplied() ? super.getContentLength() : (long)this.bytes().length;
    }

    @Override
    public InputStream getContent() throws IOException {
        return new ByteArrayInputStream(this.bytes());
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        Assertions.assertArgNotNull("out", out);
        out.write(this.bytes());
    }
}

