/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.Optional;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.ThrowableUtils;

@FluentSetters
public class BeanBuilder<T> {
    private Class<? extends T> type;
    private Class<? extends T> defaultType;
    private T impl;
    private final BeanStore beanStore;

    protected BeanBuilder(Class<? extends T> defaultType, BeanStore beanStore) {
        this.type = defaultType;
        this.defaultType = this.type;
        this.beanStore = beanStore;
    }

    protected BeanBuilder(Class<? extends T> defaultType) {
        this(defaultType, BeanStore.INSTANCE);
    }

    protected BeanBuilder(BeanBuilder<T> copyFrom) {
        this.type = copyFrom.type;
        this.impl = copyFrom.impl;
        this.beanStore = copyFrom.beanStore;
    }

    public T build() {
        if (this.impl != null) {
            return this.impl;
        }
        if (this.type == null || this.type == this.defaultType) {
            return this.buildDefault();
        }
        return this.creator().run();
    }

    protected BeanCreator<? extends T> creator() {
        return this.beanStore.createBean(this.type().orElseThrow(() -> ThrowableUtils.runtimeException("Type not specified.", new Object[0]))).builder(BeanBuilder.class, this);
    }

    protected T buildDefault() {
        return this.beanStore.createBean(this.type().orElseThrow(() -> ThrowableUtils.runtimeException("Type not specified.", new Object[0]))).builder(BeanBuilder.class, this).run();
    }

    @FluentSetter
    public BeanBuilder<T> type(Class<?> value) {
        this.type = value;
        return this;
    }

    protected Optional<Class<? extends T>> type() {
        return CollectionUtils.optional(this.type);
    }

    @FluentSetter
    public BeanBuilder<T> impl(Object value) {
        this.impl = value;
        return this;
    }

    protected Optional<T> impl() {
        return CollectionUtils.optional(this.impl);
    }

    public BeanStore beanStore() {
        return this.beanStore;
    }
}

