/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client.remote;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.http.Header;
import org.apache.juneau.collections.AMap;
import org.apache.juneau.http.BasicHeader;
import org.apache.juneau.http.HeaderSupplier;
import org.apache.juneau.http.header.BasicStringHeader;
import org.apache.juneau.http.remote.Remote;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.rest.client.remote.RemoteMethodMeta;
import org.apache.juneau.rest.client.remote.RemoteResource;
import org.apache.juneau.svl.VarResolver;

public class RemoteMeta {
    private final Map<Method, RemoteMethodMeta> methods;
    private final HeaderSupplier headerSupplier = HeaderSupplier.create().resolving();

    /*
     * WARNING - void declaration
     */
    public RemoteMeta(Class<?> c) {
        void var5_9;
        String path = "";
        ClassInfo ci = ClassInfo.of(c);
        for (RemoteResource remoteResource : ci.getAnnotations(RemoteResource.class)) {
            if (remoteResource.path().isEmpty()) continue;
            path = StringUtils.trimSlashes(remoteResource.path());
        }
        for (org.apache.juneau.http.remote.RemoteResource remoteResource : ci.getAnnotations(org.apache.juneau.http.remote.RemoteResource.class)) {
            if (remoteResource.path().isEmpty()) continue;
            path = StringUtils.trimSlashes(remoteResource.path());
        }
        String versionHeader = "X-Client-Version";
        Object var5_8 = null;
        for (Remote r : ci.getAnnotations(Remote.class)) {
            if (!r.path().isEmpty()) {
                path = StringUtils.trimSlashes(RemoteMeta.resolve(r.path()));
            }
            for (String h : r.headers()) {
                this.headerSupplier.add(BasicHeader.ofPair(RemoteMeta.resolve(h)));
            }
            if (!r.version().isEmpty()) {
                String string = RemoteMeta.resolve(r.version());
            }
            if (!r.versionHeader().isEmpty()) {
                versionHeader = RemoteMeta.resolve(r.versionHeader());
            }
            if (r.headerSupplier() == HeaderSupplier.Null.class) continue;
            try {
                this.headerSupplier.add(r.headerSupplier().newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate HeaderSupplier class.", e);
            }
        }
        if (var5_9 != null) {
            this.headerSupplier.add(BasicStringHeader.of(versionHeader, var5_9));
        }
        AMap<Method, RemoteMethodMeta> methods = AMap.of();
        for (MethodInfo m : ci.getPublicMethods()) {
            methods.put(m.inner(), new RemoteMethodMeta(path, m.inner(), "GET"));
        }
        this.methods = methods.unmodifiable();
    }

    public RemoteMethodMeta getMethodMeta(Method m) {
        return this.methods.get(m);
    }

    public Iterable<Header> getHeaders() {
        return this.headerSupplier;
    }

    private static String resolve(String s) {
        return VarResolver.DEFAULT.resolve(s);
    }
}

