/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.juneau.BasicIllegalArgumentException;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.MetaProvider;
import org.apache.juneau.Value;
import org.apache.juneau.Visibility;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.collections.AMap;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.UnmodifiableArray;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.FieldInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ReflectFlags;

@BeanIgnore
public final class ClassInfo {
    private final Type t;
    final Class<?> c;
    private ClassInfo proxyFor;
    private final boolean isParameterizedType;
    private ClassInfo[] interfaces;
    private ClassInfo[] declaredInterfaces;
    private ClassInfo[] parents;
    private ClassInfo[] allParents;
    private MethodInfo[] publicMethods;
    private MethodInfo[] declaredMethods;
    private MethodInfo[] allMethods;
    private MethodInfo[] allMethodsParentFirst;
    private ConstructorInfo[] publicConstructors;
    private ConstructorInfo[] declaredConstructors;
    private FieldInfo[] publicFields;
    private FieldInfo[] declaredFields;
    private FieldInfo[] allFields;
    private FieldInfo[] allFieldsParentFirst;
    private int dim = -1;
    private ClassInfo componentType;
    private static final Map<Class<?>, ClassInfo> CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, Class<?>> pmap1 = new HashMap();
    private static final Map<Class<?>, Class<?>> pmap2 = new HashMap();
    private static final Map<Class<?>, Object> primitiveDefaultMap;

    protected ClassInfo(Class<?> c, Type t, Class<?> proxyFor) {
        this.t = t;
        this.c = c;
        this.proxyFor = proxyFor == null ? null : ClassInfo.of(proxyFor);
        this.isParameterizedType = t == null ? false : t instanceof ParameterizedType;
    }

    public static ClassInfo of(Type t) {
        if (t == null) {
            return null;
        }
        return new ClassInfo(ClassUtils.toClass(t), t, null);
    }

    public static ClassInfo of(Class<?> c) {
        if (c == null) {
            return null;
        }
        return new ClassInfo(c, c, null);
    }

    public static ClassInfo ofc(Class<?> c) {
        if (c == null) {
            return null;
        }
        ClassInfo ci = CACHE.get(c);
        if (ci == null) {
            ci = ClassInfo.of(c);
            CACHE.put(c, ci);
        }
        return ci;
    }

    public static ClassInfo of(Class<?> c, Type t) {
        return new ClassInfo(c, t, null);
    }

    public static ClassInfo of(Object o) {
        if (o == null) {
            return null;
        }
        return new ClassInfo(o.getClass(), o.getClass(), ClassInfo.getProxyFor(o));
    }

    public static ClassInfo ofc(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        ClassInfo ci = CACHE.get(c);
        if (ci == null) {
            ci = ClassInfo.of(o);
            CACHE.put(c, ci);
        }
        return ci;
    }

    private static Class<?> getProxyFor(Object o) {
        Class<?> c = o.getClass();
        String s = c.getName();
        if (s.indexOf(36) == -1 || !s.contains("$$EnhancerBySpringCGLIB$$")) {
            return null;
        }
        for (Method m : c.getMethods()) {
            if (!m.getName().equals("getTargetClass") || m.getParameterCount() != 0 || !m.getReturnType().equals(Class.class)) continue;
            try {
                return (Class)m.invoke(o, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Type innerType() {
        return this.t;
    }

    public <T> Class<T> inner() {
        return this.c;
    }

    public ClassInfo resolved() {
        if (Value.isType(this.t)) {
            return ClassInfo.of(Value.getParameterType(this.t))._getProxiedClassInfo();
        }
        return this._getProxiedClassInfo();
    }

    private ClassInfo _getProxiedClassInfo() {
        return this.proxyFor == null ? this : this.proxyFor;
    }

    public ClassInfo getParent() {
        return this.c == null ? null : ClassInfo.of(this.c.getSuperclass());
    }

    public List<ClassInfo> getDeclaredInterfaces() {
        return new UnmodifiableArray<ClassInfo>(this._getDeclaredInterfaces());
    }

    public List<ClassInfo> getInterfacesChildFirst() {
        return new UnmodifiableArray<ClassInfo>(this._getInterfaces());
    }

    public List<ClassInfo> getInterfacesParentFirst() {
        return new UnmodifiableArray<ClassInfo>(this._getInterfaces(), true);
    }

    public List<ClassInfo> getParentsChildFirst() {
        return new UnmodifiableArray<ClassInfo>(this._getParents());
    }

    public List<ClassInfo> getParentsParentFirst() {
        return new UnmodifiableArray<ClassInfo>(this._getParents(), true);
    }

    public List<ClassInfo> getAllParentsChildFirst() {
        return new UnmodifiableArray<ClassInfo>(this._getAllParents());
    }

    public List<ClassInfo> getAllParentsParentFirst() {
        return new UnmodifiableArray<ClassInfo>(this._getAllParents(), true);
    }

    private ClassInfo[] _getInterfaces() {
        if (this.interfaces == null) {
            LinkedHashSet<ClassInfo> s = new LinkedHashSet<ClassInfo>();
            for (ClassInfo ci : this.getParentsChildFirst()) {
                for (ClassInfo ci2 : ci.getDeclaredInterfaces()) {
                    s.add(ci2);
                    for (ClassInfo ci3 : ci2.getInterfacesChildFirst()) {
                        s.add(ci3);
                    }
                }
            }
            this.interfaces = s.toArray(new ClassInfo[s.size()]);
        }
        return this.interfaces;
    }

    private ClassInfo[] _getDeclaredInterfaces() {
        if (this.declaredInterfaces == null) {
            Class[] ii = this.c == null ? new Class[]{} : this.c.getInterfaces();
            ClassInfo[] l = new ClassInfo[ii.length];
            for (int i = 0; i < ii.length; ++i) {
                l[i] = ClassInfo.of(ii[i]);
            }
            this.declaredInterfaces = l;
        }
        return this.declaredInterfaces;
    }

    private ClassInfo[] _getParents() {
        if (this.parents == null) {
            ArrayList<ClassInfo> l = new ArrayList<ClassInfo>();
            for (Class<?> pc = this.c; pc != null && pc != Object.class; pc = pc.getSuperclass()) {
                l.add(ClassInfo.of(pc));
            }
            this.parents = l.toArray(new ClassInfo[l.size()]);
        }
        return this.parents;
    }

    private ClassInfo[] _getAllParents() {
        if (this.allParents == null) {
            int i;
            ClassInfo[] a1 = this._getParents();
            ClassInfo[] a2 = this._getInterfaces();
            ClassInfo[] l = new ClassInfo[a1.length + a2.length];
            for (i = 0; i < a1.length; ++i) {
                l[i] = a1[i];
            }
            for (i = 0; i < a2.length; ++i) {
                l[i + a1.length] = a2[i];
            }
            this.allParents = l;
        }
        return this.allParents;
    }

    public List<MethodInfo> getPublicMethods() {
        return new UnmodifiableArray<MethodInfo>(this._getPublicMethods());
    }

    public MethodInfo getPublicMethod(String name, Class<?> ... args) {
        for (MethodInfo mi : this._getPublicMethods()) {
            if (!mi.hasName(name) || !mi.hasParamTypes(args)) continue;
            return mi;
        }
        return null;
    }

    public MethodInfo getMethod(String name, Class<?> ... args) {
        for (MethodInfo mi : this._getAllMethods()) {
            if (!mi.hasName(name) || !mi.hasParamTypes(args)) continue;
            return mi;
        }
        return null;
    }

    public List<MethodInfo> getDeclaredMethods() {
        return new UnmodifiableArray<MethodInfo>(this._getDeclaredMethods());
    }

    public List<MethodInfo> getAllMethods() {
        return new UnmodifiableArray<MethodInfo>(this._getAllMethods());
    }

    public List<MethodInfo> getAllMethodsParentFirst() {
        return new UnmodifiableArray<MethodInfo>(this._getAllMethodsParentFirst());
    }

    private MethodInfo[] _getPublicMethods() {
        if (this.publicMethods == null) {
            Method[] mm = this.c == null ? new Method[]{} : this.c.getMethods();
            ArrayList<MethodInfo> l = new ArrayList<MethodInfo>(mm.length);
            for (Method m : mm) {
                if (m.getDeclaringClass() == Object.class) continue;
                l.add(MethodInfo.of(this, m, this._getProxyTarget(m)));
            }
            l.sort(null);
            this.publicMethods = l.toArray(new MethodInfo[l.size()]);
        }
        return this.publicMethods;
    }

    private MethodInfo[] _getDeclaredMethods() {
        if (this.declaredMethods == null) {
            Method[] mm = this.c == null ? new Method[]{} : this.c.getDeclaredMethods();
            ArrayList<MethodInfo> l = new ArrayList<MethodInfo>(mm.length);
            for (Method m : mm) {
                if ("$jacocoInit".equals(m.getName())) continue;
                l.add(MethodInfo.of(this, m, this._getProxyTarget(m)));
            }
            l.sort(null);
            this.declaredMethods = l.toArray(new MethodInfo[l.size()]);
        }
        return this.declaredMethods;
    }

    private MethodInfo[] _getAllMethods() {
        if (this.allMethods == null) {
            ArrayList<MethodInfo> l = new ArrayList<MethodInfo>();
            for (ClassInfo c : this.getAllParentsChildFirst()) {
                c._appendDeclaredMethods(l);
            }
            this.allMethods = l.toArray(new MethodInfo[l.size()]);
        }
        return this.allMethods;
    }

    private MethodInfo[] _getAllMethodsParentFirst() {
        if (this.allMethodsParentFirst == null) {
            ArrayList<MethodInfo> l = new ArrayList<MethodInfo>();
            for (ClassInfo c : this.getAllParentsParentFirst()) {
                c._appendDeclaredMethods(l);
            }
            this.allMethodsParentFirst = l.toArray(new MethodInfo[l.size()]);
        }
        return this.allMethodsParentFirst;
    }

    private List<MethodInfo> _appendDeclaredMethods(List<MethodInfo> l) {
        l.addAll(this.getDeclaredMethods());
        return l;
    }

    private Method _getProxyTarget(Method m) {
        MethodInfo m2;
        if (this.proxyFor != null && (m2 = this.proxyFor.getMethod(m.getName(), m.getParameterTypes())) != null) {
            return m2.inner();
        }
        return m;
    }

    private Constructor<?> _getProxyTarget(Constructor<?> c) {
        ConstructorInfo c2;
        if (this.proxyFor != null && (c2 = this.proxyFor.getConstructor(Visibility.PRIVATE, c.getParameterTypes())) != null) {
            return c2.inner();
        }
        return c;
    }

    public MethodInfo getStaticCreateMethod(Class<?> ic, String ... additionalNames) {
        if (this.c != null) {
            for (MethodInfo m : this.getPublicMethods()) {
                if (!m.isAll(ReflectFlags.STATIC, ReflectFlags.PUBLIC, ReflectFlags.NOT_DEPRECATED) || !m.hasReturnType(this.c) || !m.hasParamTypes(ic)) continue;
                String n = m.getSimpleName();
                String cn = ic.getSimpleName();
                if (!(StringUtils.isOneOf(n, "create", "from", "fromValue", "parse", "valueOf") || StringUtils.isOneOf(n, additionalNames) || n.startsWith("from") && n.substring(4).equals(cn) || n.startsWith("for") && n.substring(3).equals(cn)) && (!n.startsWith("parse") || !n.substring(5).equals(cn))) continue;
                return m;
            }
        }
        return null;
    }

    public MethodInfo getStaticCreator(Object ... args) {
        if (this.c != null) {
            Class<?>[] argTypes = ClassUtils.getClasses(args);
            for (MethodInfo m : this.getPublicMethods()) {
                if (!m.isAll(ReflectFlags.STATIC, ReflectFlags.PUBLIC, ReflectFlags.NOT_DEPRECATED) || !m.hasReturnType(this.c) || !m.getSimpleName().equals("create") || !m.hasMatchingParamTypes(argTypes)) continue;
                return m;
            }
        }
        return null;
    }

    public MethodInfo getStaticCreatorFuzzy(Object ... args) {
        int bestCount = -1;
        MethodInfo bestMatch = null;
        if (this.c != null) {
            Class<?>[] argTypes = ClassUtils.getClasses(args);
            for (MethodInfo m : this.getPublicMethods()) {
                int mn;
                if (!m.isAll(ReflectFlags.STATIC, ReflectFlags.PUBLIC, ReflectFlags.NOT_DEPRECATED) || !m.hasReturnType(this.c) || !m.getSimpleName().equals("create") || (mn = m.fuzzyArgsMatch(argTypes)) <= bestCount) continue;
                bestCount = mn;
                bestMatch = m;
            }
        }
        return bestMatch;
    }

    public MethodInfo getStaticPublicMethod(String name, Class<?> rt, Class<?> ... args) {
        if (this.c != null) {
            for (MethodInfo m : this.getPublicMethods()) {
                if (!m.isAll(ReflectFlags.STATIC, ReflectFlags.PUBLIC, ReflectFlags.NOT_DEPRECATED) || !name.equals(m.getSimpleName()) || !m.hasReturnType(rt) || !m.hasParamTypes(args)) continue;
                return m;
            }
        }
        return null;
    }

    public Method getStaticPublicMethodInner(String name, Class<?> rt, Class<?> ... args) {
        MethodInfo mi = this.getStaticPublicMethod(name, rt, args);
        return mi == null ? null : mi.inner();
    }

    public MethodInfo getBuilderCreateMethod() {
        for (MethodInfo m : this.getDeclaredMethods()) {
            if (!m.isAll(ReflectFlags.PUBLIC, ReflectFlags.STATIC) || !m.hasName("create") || m.hasReturnType(Void.TYPE) || m.hasReturnType(this.c)) continue;
            return m;
        }
        return null;
    }

    public MethodInfo getBuilderBuildMethod() {
        for (MethodInfo m : this.getDeclaredMethods()) {
            if (!m.isAll(ReflectFlags.NOT_STATIC) || !m.hasName("build") || m.hasParams() || m.hasReturnType(Void.TYPE)) continue;
            return m;
        }
        return null;
    }

    public List<ConstructorInfo> getPublicConstructors() {
        return new UnmodifiableArray<ConstructorInfo>(this._getPublicConstructors());
    }

    public ConstructorInfo getPublicConstructor(Class<?> ... args) {
        for (ConstructorInfo ci : this._getPublicConstructors()) {
            if (!ci.hasParamTypes(args)) continue;
            return ci;
        }
        return null;
    }

    public ConstructorInfo getDeclaredConstructor(Class<?> ... args) {
        for (ConstructorInfo ci : this._getDeclaredConstructors()) {
            if (!ci.hasParamTypes(args)) continue;
            return ci;
        }
        return null;
    }

    public ConstructorInfo getAvailablePublicConstructor(Class<?> ... args) {
        return this._getConstructor(Visibility.PUBLIC, false, args);
    }

    public List<ConstructorInfo> getDeclaredConstructors() {
        return new UnmodifiableArray<ConstructorInfo>(this._getDeclaredConstructors());
    }

    public ConstructorInfo getPublicConstructor(Object ... args) {
        return this.getPublicConstructor(ClassUtils.getClasses(args));
    }

    public ConstructorInfo getPublicConstructorFuzzy(Object ... args) {
        return this._getConstructor(Visibility.PUBLIC, true, ClassUtils.getClasses(args));
    }

    public ConstructorInfo getConstructor(Visibility vis, Class<?> ... argTypes) {
        return this._getConstructor(vis, false, argTypes);
    }

    private ConstructorInfo[] _getPublicConstructors() {
        if (this.publicConstructors == null) {
            Constructor[] cc = this.c == null ? new Constructor[]{} : this.c.getConstructors();
            ArrayList<ConstructorInfo> l = new ArrayList<ConstructorInfo>(cc.length);
            for (Constructor ccc : cc) {
                l.add(ConstructorInfo.of(this, ccc, this._getProxyTarget(ccc)));
            }
            l.sort(null);
            this.publicConstructors = l.toArray(new ConstructorInfo[l.size()]);
        }
        return this.publicConstructors;
    }

    private ConstructorInfo[] _getDeclaredConstructors() {
        if (this.declaredConstructors == null) {
            Constructor[] cc = this.c == null ? new Constructor[]{} : this.c.getDeclaredConstructors();
            ArrayList<ConstructorInfo> l = new ArrayList<ConstructorInfo>(cc.length);
            for (Constructor ccc : cc) {
                l.add(ConstructorInfo.of(this, ccc, this._getProxyTarget(ccc)));
            }
            l.sort(null);
            this.declaredConstructors = l.toArray(new ConstructorInfo[l.size()]);
        }
        return this.declaredConstructors;
    }

    private ConstructorInfo _getConstructor(Visibility vis, boolean fuzzyArgs, Class<?> ... argTypes) {
        if (fuzzyArgs) {
            int bestCount = -1;
            ConstructorInfo bestMatch = null;
            for (ConstructorInfo n : this._getDeclaredConstructors()) {
                int m;
                if (!vis.isVisible(n.inner()) || (m = n.fuzzyArgsMatch(argTypes)) <= bestCount) continue;
                bestCount = m;
                bestMatch = n;
            }
            return bestMatch;
        }
        boolean isMemberClass = this.isNonStaticMemberClass();
        for (ConstructorInfo n : this._getDeclaredConstructors()) {
            List<ClassInfo> paramTypes = n.getParamTypes();
            if (isMemberClass) {
                paramTypes = paramTypes.subList(1, paramTypes.size());
            }
            if (!n.hasMatchingParamTypes(argTypes) || !vis.isVisible(n.inner())) continue;
            return n;
        }
        return null;
    }

    public ConstructorInfo getNoArgConstructor(Visibility v) {
        if (this.isAbstract()) {
            return null;
        }
        boolean isMemberClass = this.isNonStaticMemberClass();
        for (ConstructorInfo cc : this._getDeclaredConstructors()) {
            if (!cc.hasNumParams(isMemberClass ? 1 : 0) || !cc.isVisible(v)) continue;
            return cc.makeAccessible(v);
        }
        return null;
    }

    public List<FieldInfo> getPublicFields() {
        return new UnmodifiableArray<FieldInfo>(this._getPublicFields());
    }

    public List<FieldInfo> getDeclaredFields() {
        return new UnmodifiableArray<FieldInfo>(this._getDeclaredFields());
    }

    public List<FieldInfo> getAllFields() {
        return new UnmodifiableArray<FieldInfo>(this._getAllFields());
    }

    public List<FieldInfo> getAllFieldsParentFirst() {
        return new UnmodifiableArray<FieldInfo>(this._getAllFieldsParentFirst());
    }

    public FieldInfo getPublicField(String name) {
        for (FieldInfo f : this._getPublicFields()) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public FieldInfo getDeclaredField(String name) {
        for (FieldInfo f : this._getDeclaredFields()) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public FieldInfo getStaticPublicField(String name) {
        for (FieldInfo f : this._getPublicFields()) {
            if (!f.isStatic() || !f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public Field getStaticPublicFieldInner(String name) {
        for (FieldInfo f : this._getPublicFields()) {
            if (!f.isStatic() || !f.getName().equals(name)) continue;
            return f.inner();
        }
        return null;
    }

    private List<FieldInfo> _appendDeclaredFields(List<FieldInfo> l) {
        for (FieldInfo f : this._getDeclaredFields()) {
            l.add(f);
        }
        return l;
    }

    private Map<String, FieldInfo> _appendDeclaredPublicFields(Map<String, FieldInfo> m) {
        for (FieldInfo f : this._getDeclaredFields()) {
            String fn = f.getName();
            if (!f.isPublic() || m.containsKey(fn) || "$jacocoData".equals(fn)) continue;
            m.put(f.getName(), f);
        }
        return m;
    }

    private FieldInfo[] _getPublicFields() {
        if (this.publicFields == null) {
            LinkedHashMap<String, FieldInfo> m = new LinkedHashMap<String, FieldInfo>();
            for (ClassInfo c : this._getParents()) {
                c._appendDeclaredPublicFields(m);
            }
            ArrayList l = new ArrayList(m.values());
            l.sort(null);
            this.publicFields = l.toArray(new FieldInfo[l.size()]);
        }
        return this.publicFields;
    }

    private FieldInfo[] _getDeclaredFields() {
        if (this.declaredFields == null) {
            Field[] ff = this.c == null ? new Field[]{} : this.c.getDeclaredFields();
            ArrayList<FieldInfo> l = new ArrayList<FieldInfo>(ff.length);
            for (Field f : ff) {
                if ("$jacocoData".equals(f.getName())) continue;
                l.add(FieldInfo.of(this, f));
            }
            l.sort(null);
            this.declaredFields = l.toArray(new FieldInfo[l.size()]);
        }
        return this.declaredFields;
    }

    private FieldInfo[] _getAllFields() {
        if (this.allFields == null) {
            ArrayList<FieldInfo> l = new ArrayList<FieldInfo>();
            for (ClassInfo c : this._getAllParents()) {
                c._appendDeclaredFields(l);
            }
            this.allFields = l.toArray(new FieldInfo[l.size()]);
        }
        return this.allFields;
    }

    private FieldInfo[] _getAllFieldsParentFirst() {
        if (this.allFieldsParentFirst == null) {
            ArrayList<FieldInfo> l = new ArrayList<FieldInfo>();
            for (ClassInfo c : this.getAllParentsParentFirst()) {
                c._appendDeclaredFields(l);
            }
            this.allFieldsParentFirst = l.toArray(new FieldInfo[l.size()]);
        }
        return this.allFieldsParentFirst;
    }

    public <T extends Annotation> T getLastAnnotation(Class<T> a) {
        return this.getLastAnnotation(a, MetaProvider.DEFAULT);
    }

    public <T extends Annotation> T getLastAnnotation(Class<T> a, MetaProvider mp) {
        return this.findAnnotation(a, mp);
    }

    public boolean hasAnnotation(Class<? extends Annotation> a) {
        return this.getLastAnnotation(a) != null;
    }

    public <T extends Annotation> T getDeclaredAnnotation(Class<T> a) {
        return a == null ? null : (T)this.c.getDeclaredAnnotation(a);
    }

    public <T extends Annotation> T getPackageAnnotation(Class<T> a) {
        Package p = this.c == null ? null : this.c.getPackage();
        return p == null ? null : (T)p.getAnnotation(a);
    }

    public <T extends Annotation> AnnotationInfo<T> getDeclaredAnnotationInfo(Class<T> a) {
        T ca = this.getDeclaredAnnotation(a);
        return ca == null ? null : AnnotationInfo.of(this, ca);
    }

    public <T extends Annotation> AnnotationInfo<T> getPackageAnnotationInfo(Class<T> a) {
        T ca = this.getPackageAnnotation(a);
        return ca == null ? null : AnnotationInfo.of(this.getPackage(), ca);
    }

    public <T extends Annotation> List<T> getAnnotations(Class<T> a) {
        return this.appendAnnotations(new ArrayList(), a);
    }

    public <T extends Annotation> List<T> getAnnotations(Class<T> a, MetaProvider mp) {
        return this.appendAnnotations(new ArrayList(), a, mp);
    }

    public <T extends Annotation> List<AnnotationInfo<T>> getAnnotationInfos(Class<T> a) {
        return this.appendAnnotationInfos(new ArrayList<AnnotationInfo<T>>(), a);
    }

    public AnnotationList getAnnotationList() {
        return this.getAnnotationList(null);
    }

    public AnnotationList getAnnotationList(Predicate<AnnotationInfo<?>> filter) {
        return this.appendAnnotationList(new AnnotationList(filter));
    }

    public <T extends Annotation> List<T> appendAnnotations(List<T> l, Class<T> a) {
        return this.appendAnnotations(l, a, MetaProvider.DEFAULT);
    }

    public <T extends Annotation> List<T> appendAnnotations(List<T> l, Class<T> a, MetaProvider mp) {
        CollectionUtils.addIfNotNull(l, this.getPackageAnnotation(a));
        for (ClassInfo ci : this.getInterfacesParentFirst()) {
            for (Annotation t : mp.getDeclaredAnnotations(a, ci.inner())) {
                l.add(t);
            }
        }
        for (ClassInfo ci : this.getParentsParentFirst()) {
            for (Annotation t : mp.getDeclaredAnnotations(a, ci.inner())) {
                l.add(t);
            }
        }
        return l;
    }

    public <T extends Annotation> List<AnnotationInfo<T>> appendAnnotationInfos(List<AnnotationInfo<T>> l, Class<T> a) {
        CollectionUtils.addIfNotNull(l, this.getPackageAnnotationInfo(a));
        for (ClassInfo ci : this.getInterfacesParentFirst()) {
            CollectionUtils.addIfNotNull(l, ci.getDeclaredAnnotationInfo(a));
        }
        for (ClassInfo ci : this.getParentsParentFirst()) {
            CollectionUtils.addIfNotNull(l, ci.getDeclaredAnnotationInfo(a));
        }
        return l;
    }

    @SafeVarargs
    public final Annotation getAnyLastAnnotation(MetaProvider mp, Class<? extends Annotation> ... annotations) {
        for (Class<? extends Annotation> ca : annotations) {
            Annotation x = this.getLastAnnotation(ca, mp);
            if (x == null) continue;
            return x;
        }
        for (ClassInfo ci : this.getInterfacesChildFirst()) {
            for (Class<? extends Annotation> ca : annotations) {
                Annotation x = ci.getLastAnnotation(ca, mp);
                if (x == null) continue;
                return x;
            }
        }
        ClassInfo ci = this.getParent();
        return ci == null ? null : ci.getAnyLastAnnotation(mp, annotations);
    }

    AnnotationList appendAnnotationList(AnnotationList m) {
        Package p = this.c.getPackage();
        if (p != null) {
            for (Annotation a : p.getDeclaredAnnotations()) {
                m.add(AnnotationInfo.of(p, a));
            }
        }
        for (ClassInfo ci : this.getInterfacesParentFirst()) {
            Annotation[] annotationArray = ci.c.getDeclaredAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation a = annotationArray[i];
                m.add(AnnotationInfo.of(ci, a));
            }
        }
        for (ClassInfo ci : this.getParentsParentFirst()) {
            for (Annotation a : ci.c.getDeclaredAnnotations()) {
                m.add(AnnotationInfo.of(ci, a));
            }
        }
        return m;
    }

    <T extends Annotation> T findAnnotation(Class<T> a, MetaProvider mp) {
        T t;
        if (a == null) {
            return null;
        }
        Iterator<T> iterator = mp.getDeclaredAnnotations(a, this.c).iterator();
        if (iterator.hasNext()) {
            Annotation t2 = (Annotation)iterator.next();
            return (T)t2;
        }
        ClassInfo sci = this.getParent();
        if (sci != null && (t = sci.getLastAnnotation(a, mp)) != null) {
            return t;
        }
        for (ClassInfo c2 : this.getInterfacesChildFirst()) {
            t = c2.getLastAnnotation(a, mp);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public boolean isAll(ReflectFlags ... flags) {
        block14: for (ReflectFlags f : flags) {
            switch (f) {
                case DEPRECATED: {
                    if (!this.isNotDeprecated()) continue block14;
                    return false;
                }
                case NOT_DEPRECATED: {
                    if (!this.isDeprecated()) continue block14;
                    return false;
                }
                case PUBLIC: {
                    if (!this.isNotPublic()) continue block14;
                    return false;
                }
                case NOT_PUBLIC: {
                    if (!this.isPublic()) continue block14;
                    return false;
                }
                case STATIC: {
                    if (!this.isNotStatic()) continue block14;
                    return false;
                }
                case NOT_STATIC: {
                    if (!this.isStatic()) continue block14;
                    return false;
                }
                case MEMBER: {
                    if (!this.isNotMemberClass()) continue block14;
                    return false;
                }
                case NOT_MEMBER: {
                    if (!this.isMemberClass()) continue block14;
                    return false;
                }
                case ABSTRACT: {
                    if (!this.isNotAbstract()) continue block14;
                    return false;
                }
                case NOT_ABSTRACT: {
                    if (!this.isAbstract()) continue block14;
                    return false;
                }
                case INTERFACE: {
                    if (!this.isClass()) continue block14;
                    return false;
                }
                case CLASS: {
                    if (!this.isInterface()) continue block14;
                    return false;
                }
                default: {
                    throw new RuntimeException("Invalid flag for class: " + (Object)((Object)f));
                }
            }
        }
        return true;
    }

    public boolean isAny(ReflectFlags ... flags) {
        block14: for (ReflectFlags f : flags) {
            switch (f) {
                case DEPRECATED: {
                    if (!this.isDeprecated()) continue block14;
                    return true;
                }
                case NOT_DEPRECATED: {
                    if (!this.isNotDeprecated()) continue block14;
                    return true;
                }
                case PUBLIC: {
                    if (!this.isPublic()) continue block14;
                    return true;
                }
                case NOT_PUBLIC: {
                    if (!this.isNotPublic()) continue block14;
                    return true;
                }
                case STATIC: {
                    if (!this.isStatic()) continue block14;
                    return true;
                }
                case NOT_STATIC: {
                    if (!this.isNotStatic()) continue block14;
                    return true;
                }
                case MEMBER: {
                    if (!this.isMemberClass()) continue block14;
                    return true;
                }
                case NOT_MEMBER: {
                    if (!this.isNotMemberClass()) continue block14;
                    return true;
                }
                case ABSTRACT: {
                    if (!this.isAbstract()) continue block14;
                    return true;
                }
                case NOT_ABSTRACT: {
                    if (!this.isNotAbstract()) continue block14;
                    return true;
                }
                case INTERFACE: {
                    if (!this.isInterface()) continue block14;
                    return true;
                }
                case CLASS: {
                    if (!this.isClass()) continue block14;
                    return true;
                }
                default: {
                    throw new RuntimeException("Invalid flag for class: " + (Object)((Object)f));
                }
            }
        }
        return false;
    }

    public boolean isDeprecated() {
        return this.c != null && this.c.isAnnotationPresent(Deprecated.class);
    }

    public boolean isNotDeprecated() {
        return this.c == null || !this.c.isAnnotationPresent(Deprecated.class);
    }

    public boolean isPublic() {
        return this.c != null && Modifier.isPublic(this.c.getModifiers());
    }

    public boolean isNotPublic() {
        return this.c == null || !Modifier.isPublic(this.c.getModifiers());
    }

    public boolean isStatic() {
        return this.c != null && Modifier.isStatic(this.c.getModifiers());
    }

    public boolean isNotStatic() {
        return this.c == null || !Modifier.isStatic(this.c.getModifiers());
    }

    public boolean isAbstract() {
        return this.c != null && Modifier.isAbstract(this.c.getModifiers());
    }

    public boolean isNotAbstract() {
        return this.c == null || !Modifier.isAbstract(this.c.getModifiers());
    }

    public boolean isMemberClass() {
        return this.c != null && this.c.isMemberClass();
    }

    public boolean isNotMemberClass() {
        return this.c == null || !this.c.isMemberClass();
    }

    public boolean isNonStaticMemberClass() {
        return this.c != null && this.c.isMemberClass() && !this.isStatic();
    }

    public boolean isNotNonStaticMemberClass() {
        return !this.isNonStaticMemberClass();
    }

    public boolean isLocalClass() {
        return this.c != null && this.c.isLocalClass();
    }

    public boolean isNotLocalClass() {
        return this.c == null || !this.c.isLocalClass();
    }

    public boolean isVisible(Visibility v) {
        return this.c != null && v.isVisible(this.c);
    }

    public boolean isPrimitive() {
        return this.c != null && this.c.isPrimitive();
    }

    public boolean isNotPrimitive() {
        return this.c == null || !this.c.isPrimitive();
    }

    public boolean isInterface() {
        return this.c != null && this.c.isInterface();
    }

    public boolean isClass() {
        return this.c != null && !this.c.isInterface();
    }

    public boolean isRuntimeException() {
        return this.isChildOf(RuntimeException.class);
    }

    public boolean hasPrimitiveWrapper() {
        return pmap1.containsKey(this.c);
    }

    public Class<?> getPrimitiveWrapper() {
        return pmap1.get(this.c);
    }

    public Class<?> getPrimitiveForWrapper() {
        return pmap2.get(this.c);
    }

    public Class<?> getWrapperIfPrimitive() {
        if (this.c != null && !this.c.isPrimitive()) {
            return this.c;
        }
        return pmap1.get(this.c);
    }

    public ClassInfo getWrapperInfoIfPrimitive() {
        if (this.c == null || !this.c.isPrimitive()) {
            return this;
        }
        return ClassInfo.of(pmap1.get(this.c));
    }

    public Object getPrimitiveDefault() {
        return primitiveDefaultMap.get(this.c);
    }

    public String getFullName() {
        Class ct = this.getComponentType().inner();
        int dim = this.getDimensions();
        if (ct != null && dim == 0 && !this.isParameterizedType) {
            return ct.getName();
        }
        StringBuilder sb = new StringBuilder(128);
        this.appendFullName(sb);
        return sb.toString();
    }

    public String[] getNames() {
        return new String[]{this.getFullName(), this.c.getName(), this.getShortName(), this.getSimpleName()};
    }

    public StringBuilder appendFullName(StringBuilder sb) {
        Class ct = this.getComponentType().inner();
        int dim = this.getDimensions();
        if (ct != null && dim == 0 && !this.isParameterizedType) {
            return sb.append(ct.getName());
        }
        sb.append(ct != null ? ct.getName() : this.t.getTypeName());
        if (this.isParameterizedType) {
            ParameterizedType pt = (ParameterizedType)this.t;
            sb.append('<');
            boolean first = true;
            for (Type t2 : pt.getActualTypeArguments()) {
                if (!first) {
                    sb.append(',');
                }
                first = false;
                ClassInfo.of(t2).appendFullName(sb);
            }
            sb.append('>');
        }
        for (int i = 0; i < dim; ++i) {
            sb.append('[').append(']');
        }
        return sb;
    }

    public String getShortName() {
        Class ct = this.getComponentType().inner();
        int dim = this.getDimensions();
        if (!(ct == null || dim != 0 || this.isParameterizedType || this.isMemberClass() || this.c.isLocalClass())) {
            return ct.getSimpleName();
        }
        StringBuilder sb = new StringBuilder(32);
        this.appendShortName(sb);
        return sb.toString();
    }

    public StringBuilder appendShortName(StringBuilder sb) {
        Class ct = this.getComponentType().inner();
        int dim = this.getDimensions();
        if (ct != null) {
            if (ct.isLocalClass()) {
                sb.append(ClassInfo.of(ct.getEnclosingClass()).getSimpleName()).append('$').append(ct.getSimpleName());
            } else if (ct.isMemberClass()) {
                sb.append(ClassInfo.of(ct.getDeclaringClass()).getSimpleName()).append('$').append(ct.getSimpleName());
            } else {
                sb.append(ct.getSimpleName());
            }
        } else {
            sb.append(this.t.getTypeName());
        }
        if (this.isParameterizedType) {
            ParameterizedType pt = (ParameterizedType)this.t;
            sb.append('<');
            boolean first = true;
            for (Type t2 : pt.getActualTypeArguments()) {
                if (!first) {
                    sb.append(',');
                }
                first = false;
                ClassInfo.of(t2).appendShortName(sb);
            }
            sb.append('>');
        }
        for (int i = 0; i < dim; ++i) {
            sb.append('[').append(']');
        }
        return sb;
    }

    public String getSimpleName() {
        return this.c != null ? this.c.getSimpleName() : this.t.getTypeName();
    }

    public String getName() {
        return this.c != null ? this.c.getName() : this.t.getTypeName();
    }

    public String getReadableName() {
        if (this.c == null) {
            return this.t.getTypeName();
        }
        if (!this.c.isArray()) {
            return this.c.getSimpleName();
        }
        Class<?> c = this.c;
        StringBuilder sb = new StringBuilder();
        while (c.isArray()) {
            sb.append("Array");
            c = c.getComponentType();
        }
        return c.getSimpleName() + sb;
    }

    public boolean isParentOf(Class<?> child) {
        return this.c != null && child != null && this.c.isAssignableFrom(child);
    }

    public boolean isParentOfFuzzyPrimitives(Class<?> child) {
        if (this.c == null || child == null) {
            return false;
        }
        if (this.c.isAssignableFrom(child)) {
            return true;
        }
        if (this.isPrimitive() || child.isPrimitive()) {
            return this.getWrapperIfPrimitive().isAssignableFrom(ClassInfo.of(child).getWrapperIfPrimitive());
        }
        return false;
    }

    public boolean isParentOfFuzzyPrimitives(ClassInfo child) {
        if (this.c == null || child == null) {
            return false;
        }
        if (this.c.isAssignableFrom(child.inner())) {
            return true;
        }
        if (this.isPrimitive() || child.isPrimitive()) {
            return this.getWrapperIfPrimitive().isAssignableFrom(child.getWrapperIfPrimitive());
        }
        return false;
    }

    public boolean isParentOf(Type child) {
        if (child instanceof Class) {
            return this.isParentOf((Class)child);
        }
        return false;
    }

    public boolean isParentOfFuzzyPrimitives(Type child) {
        if (child instanceof Class) {
            return this.isParentOfFuzzyPrimitives((Class)child);
        }
        return false;
    }

    public boolean isStrictChildOf(Class<?> parent) {
        return this.c != null && parent != null && parent.isAssignableFrom(this.c) && !this.c.equals(parent);
    }

    public boolean isChildOf(Class<?> parent) {
        return this.c != null && parent != null && parent.isAssignableFrom(this.c);
    }

    public boolean isChildOfAny(Class<?> ... parents) {
        for (Class<?> p : parents) {
            if (!this.isChildOf(p)) continue;
            return true;
        }
        return false;
    }

    public boolean isChildOf(Type parent) {
        if (parent instanceof Class) {
            return this.isChildOf((Class)parent);
        }
        return false;
    }

    public boolean isChildOf(ClassInfo parent) {
        return this.isChildOf(parent.inner());
    }

    public boolean is(Class<?> c) {
        return this.c != null && this.c.equals(c);
    }

    public boolean is(ClassInfo c) {
        if (this.c != null) {
            return this.c.equals(c.inner());
        }
        return this.t.equals(c.t);
    }

    public boolean isAny(Class<?> ... types) {
        for (Class<?> cc : types) {
            if (!this.is(cc)) continue;
            return true;
        }
        return false;
    }

    public Package getPackage() {
        return this.c == null ? null : this.c.getPackage();
    }

    public boolean hasPackage() {
        return this.getPackage() != null;
    }

    public boolean isProxy() {
        return this.proxyFor != null;
    }

    public ClassInfo getProxyFor() {
        return this.proxyFor;
    }

    public int getDimensions() {
        if (this.dim == -1) {
            Class<?> ct;
            int d = 0;
            for (ct = this.c; ct != null && ct.isArray(); ct = ct.getComponentType()) {
                ++d;
            }
            this.dim = d;
            this.componentType = ct == this.c ? this : ClassInfo.of(ct);
        }
        return this.dim;
    }

    public ClassInfo getComponentType() {
        if (this.componentType == null) {
            if (this.c == null) {
                this.componentType = this;
            } else {
                this.getDimensions();
            }
        }
        return this.componentType;
    }

    public boolean isEnum() {
        return this.c != null && this.c.isEnum();
    }

    public Object newInstance() throws ExecutableException {
        if (this.c == null) {
            throw new ExecutableException("Type ''{0}'' cannot be instantiated", this.getFullName());
        }
        try {
            return this.c.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ExecutableException(e);
        }
    }

    public Class<?> getParameterType(int index, Class<?> pt) {
        if (pt == null) {
            throw new BasicIllegalArgumentException("Parameterized type cannot be null", new Object[0]);
        }
        HashMap<Type, Type> typeMap = new HashMap<Type, Type>();
        Class<?> cc = this.c;
        while (pt != cc.getSuperclass()) {
            ClassInfo.extractTypes(typeMap, cc);
            if ((cc = cc.getSuperclass()) != null) continue;
            throw new BasicIllegalArgumentException("Class ''{0}'' is not a subclass of parameterized type ''{1}''", this.c.getSimpleName(), pt.getSimpleName());
        }
        Type gsc = cc.getGenericSuperclass();
        if (!(gsc instanceof ParameterizedType)) {
            throw new BasicIllegalArgumentException("Class ''{0}'' is not a parameterized type", pt.getSimpleName());
        }
        ParameterizedType cpt = (ParameterizedType)gsc;
        Type[] atArgs = cpt.getActualTypeArguments();
        if (index >= atArgs.length) {
            throw new BasicIllegalArgumentException("Invalid type index. index={0}, argsLength={1}", index, atArgs.length);
        }
        Type actualType = cpt.getActualTypeArguments()[index];
        if (typeMap.containsKey(actualType)) {
            actualType = (Type)typeMap.get(actualType);
        }
        if (actualType instanceof Class) {
            return (Class)actualType;
        }
        if (actualType instanceof GenericArrayType) {
            Type gct = ((GenericArrayType)actualType).getGenericComponentType();
            if (gct instanceof ParameterizedType) {
                return Array.newInstance((Class)((ParameterizedType)gct).getRawType(), 0).getClass();
            }
        } else if (actualType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)actualType;
            LinkedList nestedOuterTypes = new LinkedList();
            for (Class<?> ec = cc.getEnclosingClass(); ec != null; ec = ec.getEnclosingClass()) {
                Class<?> outerClass = cc.getClass();
                nestedOuterTypes.add(outerClass);
                HashMap<Type, Type> outerTypeMap = new HashMap<Type, Type>();
                ClassInfo.extractTypes(outerTypeMap, outerClass);
                for (Map.Entry entry : outerTypeMap.entrySet()) {
                    TypeVariable keyType;
                    Type key = (Type)entry.getKey();
                    Type value = (Type)entry.getValue();
                    if (!(key instanceof TypeVariable) || !(keyType = (TypeVariable)key).getName().equals(typeVariable.getName()) || !ClassInfo.isInnerClass(keyType.getGenericDeclaration(), typeVariable.getGenericDeclaration())) continue;
                    if (value instanceof Class) {
                        return (Class)value;
                    }
                    typeVariable = (TypeVariable)entry.getValue();
                }
            }
        } else if (actualType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)actualType).getRawType();
        }
        throw new BasicIllegalArgumentException("Could not resolve variable ''{0}'' to a type.", actualType.getTypeName());
    }

    private static boolean isInnerClass(GenericDeclaration od, GenericDeclaration id) {
        if (od instanceof Class && id instanceof Class) {
            Class oc = (Class)od;
            Class<?> ic = (Class<?>)id;
            while ((ic = ic.getEnclosingClass()) != null) {
                if (ic != oc) continue;
                return true;
            }
        }
        return false;
    }

    private static void extractTypes(Map<Type, Type> typeMap, Class<?> c) {
        Type gs = c.getGenericSuperclass();
        if (gs instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)gs;
            TypeVariable<Class<T>>[] typeParameters = ((Class)pt.getRawType()).getTypeParameters();
            Type[] actualTypeArguments = pt.getActualTypeArguments();
            for (int i = 0; i < typeParameters.length; ++i) {
                if (typeMap.containsKey(actualTypeArguments[i])) {
                    actualTypeArguments[i] = typeMap.get(actualTypeArguments[i]);
                }
                typeMap.put(typeParameters[i], actualTypeArguments[i]);
            }
        }
    }

    public String toString() {
        return this.t.toString();
    }

    public int hashCode() {
        return this.t.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof ClassInfo && ObjectUtils.eq(this, (ClassInfo)o, (x, y) -> ObjectUtils.eq(x.t, y.t));
    }

    static {
        pmap1.put(Boolean.TYPE, Boolean.class);
        pmap1.put(Byte.TYPE, Byte.class);
        pmap1.put(Short.TYPE, Short.class);
        pmap1.put(Character.TYPE, Character.class);
        pmap1.put(Integer.TYPE, Integer.class);
        pmap1.put(Long.TYPE, Long.class);
        pmap1.put(Float.TYPE, Float.class);
        pmap1.put(Double.TYPE, Double.class);
        pmap2.put(Boolean.class, Boolean.TYPE);
        pmap2.put(Byte.class, Byte.TYPE);
        pmap2.put(Short.class, Short.TYPE);
        pmap2.put(Character.class, Character.TYPE);
        pmap2.put(Integer.class, Integer.TYPE);
        pmap2.put(Long.class, Long.TYPE);
        pmap2.put(Float.class, Float.TYPE);
        pmap2.put(Double.class, Double.TYPE);
        primitiveDefaultMap = Collections.unmodifiableMap(AMap.of().a(Boolean.TYPE, false).a(Character.TYPE, (Boolean)((Object)Character.valueOf('\u0000'))).a(Short.TYPE, (Boolean)((Object)Short.valueOf((short)0))).a(Integer.TYPE, (Boolean)((Object)Integer.valueOf(0))).a(Long.TYPE, (Boolean)((Object)Long.valueOf(0L))).a(Float.TYPE, (Boolean)((Object)Float.valueOf(0.0f))).a(Double.TYPE, (Boolean)((Object)Double.valueOf(0.0))).a(Byte.TYPE, (Boolean)((Object)Byte.valueOf((byte)0))).a(Boolean.class, false).a(Character.class, (Boolean)((Object)Character.valueOf('\u0000'))).a(Short.class, (Boolean)((Object)Short.valueOf((short)0))).a(Integer.class, (Boolean)((Object)Integer.valueOf(0))).a(Long.class, (Boolean)((Object)Long.valueOf(0L))).a(Float.class, (Boolean)((Object)Float.valueOf(0.0f))).a(Double.class, (Boolean)((Object)Double.valueOf(0.0))).a(Byte.class, (Boolean)((Object)Byte.valueOf((byte)0))));
    }
}

