/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.rootpane;

import com.github.weisj.darklaf.platform.DecorationsHandler;
import com.github.weisj.darklaf.platform.decorations.CustomTitlePane;
import com.github.weisj.darklaf.ui.rootpane.DarkRootPaneUI;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.LogUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.logging.Logger;
import javax.swing.JRootPane;

class DarkSubstanceRootLayout
implements LayoutManager2 {
    private static final Logger LOGGER = LogUtil.getLogger(DarkSubstanceRootLayout.class);

    DarkSubstanceRootLayout() {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension mbd;
        int cpWidth = 0;
        int cpHeight = 0;
        int mbWidth = 0;
        int mbHeight = 0;
        int tpWidth = 0;
        int tpHeight = 0;
        Insets i = parent.getInsets();
        DecorationsHandler.getSharedInstance().adjustWindowInsets(DarkUIUtil.getWindow(parent), i);
        JRootPane root = (JRootPane)parent;
        CustomTitlePane titlePane = this.getTitlePane(root);
        Dimension cpd = root.getContentPane() != null ? root.getContentPane().getPreferredSize() : root.getSize();
        LOGGER.finer("[PrefSize] JRootPane content size: " + cpd);
        if (cpd != null) {
            cpWidth = cpd.width;
            cpHeight = cpd.height;
        }
        if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getPreferredSize()) != null) {
            mbWidth = mbd.width;
            mbHeight = mbd.height;
        }
        if (titlePane != null) {
            Dimension tpd = titlePane.getPreferredSize();
            if (tpd != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            LOGGER.finer("[PrefSize] JRootPane titlePane size: " + tpd);
        }
        return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i.left + i.right, cpHeight + mbHeight + tpHeight + i.top + i.bottom);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Dimension mbd;
        int cpWidth = 0;
        int cpHeight = 0;
        int mbWidth = 0;
        int mbHeight = 0;
        int tpWidth = 0;
        int tpHeight = 0;
        Insets i = parent.getInsets();
        JRootPane root = (JRootPane)parent;
        CustomTitlePane titlePane = this.getTitlePane(root);
        Dimension cpd = root.getContentPane() != null ? root.getContentPane().getMinimumSize() : root.getSize();
        LOGGER.finer("[MinSize] JRootPane content size: " + cpd);
        if (cpd != null) {
            cpWidth = cpd.width;
            cpHeight = cpd.height;
        }
        if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMinimumSize()) != null) {
            mbWidth = mbd.width;
            mbHeight = mbd.height;
        }
        if (titlePane != null) {
            Dimension tpd = titlePane.getMinimumSize();
            if (tpd != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            LOGGER.finer("[MinSize] JRootPane titlePane size: " + tpd);
        }
        return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i.left + i.right, cpHeight + mbHeight + tpHeight + i.top + i.bottom);
    }

    protected CustomTitlePane getTitlePane(JRootPane root) {
        if (root.getUI() instanceof DarkRootPaneUI) {
            return ((DarkRootPaneUI)root.getUI()).getTitlePane();
        }
        return null;
    }

    @Override
    public void layoutContainer(Container parent) {
        JRootPane root = (JRootPane)parent;
        Rectangle b = root.getBounds();
        Insets i = root.getInsets();
        b.setLocation(0, 0);
        DarkUIUtil.applyInsets(b, i);
        if (root.getLayeredPane() != null) {
            root.getLayeredPane().setBounds(b.x, b.y, b.width, b.height);
        }
        if (root.getGlassPane() != null) {
            root.getGlassPane().setBounds(b.x, b.y, b.width, b.height);
        }
        DecorationsHandler.getSharedInstance().adjustContentArea(root, b);
        this.layoutContent(root, b.x, b.y, b.width, b.height);
    }

    public void layoutContent(JRootPane root, int x, int y, int w, int h) {
        Dimension tpd;
        int nextY = y;
        CustomTitlePane titlePane = this.getTitlePane(root);
        if (titlePane != null && (tpd = titlePane.getPreferredSize()) != null) {
            int tpHeight = tpd.height;
            titlePane.setBounds(x, y, w, tpHeight);
            nextY += tpHeight;
        }
        if (root.getJMenuBar() != null) {
            Dimension mbd = root.getJMenuBar().getPreferredSize();
            root.getJMenuBar().setBounds(x, nextY, w, mbd.height);
            nextY += mbd.height;
        }
        if (root.getContentPane() != null) {
            root.getContentPane().setBounds(x, nextY, w, h < nextY ? 0 : h - nextY);
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        int maxWidth;
        int maxHeight;
        Dimension tpd;
        CustomTitlePane titlePane;
        Dimension mbd;
        Dimension cpd;
        int cpWidth = Integer.MAX_VALUE;
        int cpHeight = Integer.MAX_VALUE;
        int mbWidth = Integer.MAX_VALUE;
        int mbHeight = Integer.MAX_VALUE;
        int tpWidth = Integer.MAX_VALUE;
        int tpHeight = Integer.MAX_VALUE;
        Insets i = target.getInsets();
        JRootPane root = (JRootPane)target;
        if (root.getContentPane() != null && (cpd = root.getContentPane().getMaximumSize()) != null) {
            cpWidth = cpd.width;
            cpHeight = cpd.height;
        }
        if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMaximumSize()) != null) {
            mbWidth = mbd.width;
            mbHeight = mbd.height;
        }
        if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof DarkRootPaneUI && (titlePane = ((DarkRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMaximumSize()) != null) {
            tpWidth = tpd.width;
            tpHeight = tpd.height;
        }
        if ((maxHeight = Math.max(Math.max(cpHeight, mbHeight), tpHeight)) != Integer.MAX_VALUE) {
            maxHeight = cpHeight + mbHeight + tpHeight + i.top + i.bottom;
        }
        if ((maxWidth = Math.max(Math.max(cpWidth, mbWidth), tpWidth)) != Integer.MAX_VALUE) {
            maxWidth += i.left + i.right;
        }
        return new Dimension(maxWidth, maxHeight);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }
}

