/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.jmeter.samplers.SampleResult;

public class LoopbackHTTPSocket
extends Socket {
    private final LoopbackOutputStream os = new LoopbackOutputStream();

    private LoopbackHTTPSocket() throws IOException {
        this.os.write("HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\n\r\n".getBytes(SampleResult.DEFAULT_HTTP_ENCODING));
    }

    public LoopbackHTTPSocket(String host, int port, InetAddress localAddress, int localPort, int timeout) throws IOException {
        this();
    }

    public LoopbackHTTPSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        this();
    }

    public LoopbackHTTPSocket(String host, int port) throws UnknownHostException, IOException {
        this();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.os;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new LoopBackInputStream(this.os);
    }

    static class LoopbackOutputStream
    extends ByteArrayOutputStream {
        LoopbackOutputStream() {
        }

        byte[] getBuffer() {
            return this.buf;
        }
    }

    static class LoopBackInputStream
    extends ByteArrayInputStream {
        private final LoopbackOutputStream os;

        @Override
        public synchronized int read() {
            this.buf = this.os.getBuffer();
            this.count = this.buf.length;
            return super.read();
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) {
            this.buf = this.os.getBuffer();
            this.count = this.buf.length;
            return super.read(b, off, len);
        }

        public LoopBackInputStream(LoopbackOutputStream _os) {
            super(_os.getBuffer());
            this.os = _os;
        }
    }
}

