/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SoftDeleteResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String SOFT_DELETE_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.21";
    @NotNull
    private static final String JSON_FIELD_SOFT_DELETED_ENTRY_DN = "soft-deleted-entry-dn";
    private static final long serialVersionUID = 3163679387266190228L;
    @NotNull
    private final String softDeletedEntryDN;

    SoftDeleteResponseControl() {
        this.softDeletedEntryDN = null;
    }

    public SoftDeleteResponseControl(@NotNull String softDeletedEntryDN) {
        super(SOFT_DELETE_RESPONSE_OID, false, new ASN1OctetString(softDeletedEntryDN));
        Validator.ensureNotNull(softDeletedEntryDN);
        this.softDeletedEntryDN = softDeletedEntryDN;
    }

    public SoftDeleteResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SOFT_DELETE_RESPONSE_NO_VALUE.get());
        }
        this.softDeletedEntryDN = value.stringValue();
        if (!DN.isValidDN(this.softDeletedEntryDN)) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SOFT_DELETE_RESPONSE_VALUE_NOT_DN.get());
        }
    }

    @Override
    @NotNull
    public SoftDeleteResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new SoftDeleteResponseControl(oid, isCritical, value);
    }

    @NotNull
    public String getSoftDeletedEntryDN() {
        return this.softDeletedEntryDN;
    }

    @Nullable
    public static SoftDeleteResponseControl get(@NotNull LDAPResult deleteResult) throws LDAPException {
        Control c = deleteResult.getResponseControl(SOFT_DELETE_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof SoftDeleteResponseControl) {
            return (SoftDeleteResponseControl)c;
        }
        return new SoftDeleteResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_SOFT_DELETE_RESPONSE.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        return new JSONObject(new JSONField("oid", SOFT_DELETE_RESPONSE_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_SOFT_DELETE_RESPONSE.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(new JSONField(JSON_FIELD_SOFT_DELETED_ENTRY_DN, this.softDeletedEntryDN))));
    }

    @NotNull
    public static SoftDeleteResponseControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new SoftDeleteResponseControl(jsonControl.getOID(), jsonControl.getCriticality(), rawValue);
        }
        JSONObject valueObject = jsonControl.getValueObject();
        String softDeletedEntryDN = valueObject.getFieldAsString(JSON_FIELD_SOFT_DELETED_ENTRY_DN);
        if (softDeletedEntryDN == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SOFT_DELETE_RESPONSE_JSON_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_SOFT_DELETED_ENTRY_DN));
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_SOFT_DELETED_ENTRY_DN)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SOFT_DELETE_RESPONSE_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new SoftDeleteResponseControl(softDeletedEntryDN);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("SoftDeleteResponseControl(softDeletedEntryDN='");
        buffer.append(this.softDeletedEntryDN);
        buffer.append("')");
    }
}

