/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Optional;
import java.util.Set;
import org.apache.james.core.Username;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNameException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.indexer.ReIndexer;
import org.apache.james.task.Task;
import org.apache.james.task.TaskManager;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.routes.MailboxesRoutes;
import org.apache.james.webadmin.routes.ReindexingRunningOptionsParser;
import org.apache.james.webadmin.service.ClearMailboxContentTask;
import org.apache.james.webadmin.service.UserMailboxesService;
import org.apache.james.webadmin.tasks.TaskFromRequest;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.MailboxHaveChildrenException;
import org.apache.james.webadmin.utils.Responses;
import org.apache.james.webadmin.validation.MailboxName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Route;
import spark.Service;

public class UserMailboxesRoutes
implements Routes {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserMailboxesRoutes.class);
    public static final String USER_MAILBOXES_OPERATIONS_INJECTION_KEY = "userMailboxesOperations";
    public static final String MAILBOX_NAME = ":mailboxName";
    public static final String MAILBOXES = "mailboxes";
    private static final String USER_NAME = ":userName";
    public static final String USERS_BASE = "/users";
    public static final String USER_MAILBOXES_BASE = "/users/:userName/mailboxes";
    public static final String SPECIFIC_MAILBOX = "/users/:userName/mailboxes/:mailboxName";
    public static final String MESSAGE_COUNT_PATH = "/users/:userName/mailboxes/:mailboxName/messageCount";
    public static final String UNSEEN_MESSAGE_COUNT_PATH = "/users/:userName/mailboxes/:mailboxName/unseenMessageCount";
    public static final String MESSAGES_PATH = "/users/:userName/mailboxes/:mailboxName/messages";
    private final UserMailboxesService userMailboxesService;
    private final JsonTransformer jsonTransformer;
    private final TaskManager taskManager;
    private final Set<TaskFromRequestRegistry.TaskRegistration> usersMailboxesTaskRegistration;
    private Service service;

    private static Username getUsernameParam(Request request) {
        return Username.of((String)request.params(USER_NAME));
    }

    private static UserMailboxesService.Options getOptions(Request request) {
        if (request.queryParams().contains("force")) {
            return UserMailboxesService.Options.Force;
        }
        return UserMailboxesService.Options.Check;
    }

    @Inject
    UserMailboxesRoutes(UserMailboxesService userMailboxesService, JsonTransformer jsonTransformer, TaskManager taskManager, @Named(value="userMailboxesOperations") Set<TaskFromRequestRegistry.TaskRegistration> usersMailboxesTaskRegistration) {
        this.userMailboxesService = userMailboxesService;
        this.jsonTransformer = jsonTransformer;
        this.taskManager = taskManager;
        this.usersMailboxesTaskRegistration = usersMailboxesTaskRegistration;
    }

    public String getBasePath() {
        return USER_MAILBOXES_BASE;
    }

    public void define(Service service) {
        this.service = service;
        this.defineMailboxExists();
        this.defineGetUserMailboxes();
        this.defineCreateUserMailbox();
        this.defineDeleteUserMailbox();
        this.defineDeleteUserMailboxes();
        this.messageCount();
        this.reIndexMailboxesRoute().ifPresent(route -> service.post(USER_MAILBOXES_BASE, route, (ResponseTransformer)this.jsonTransformer));
        this.unseenMessageCount();
        TaskFromRequest clearMailboxContentTaskRequest = this::clearMailboxContent;
        service.delete(MESSAGES_PATH, clearMailboxContentTaskRequest.asRoute(this.taskManager), (ResponseTransformer)this.jsonTransformer);
    }

    public void defineGetUserMailboxes() {
        this.service.get(USER_MAILBOXES_BASE, (request, response) -> {
            response.status(200);
            try {
                return this.userMailboxesService.listMailboxes(UserMailboxesRoutes.getUsernameParam(request), UserMailboxesRoutes.getOptions(request));
            }
            catch (IllegalStateException e) {
                LOGGER.info("Invalid get on user mailboxes", (Throwable)e);
                throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message("Invalid get on user mailboxes").cause((Exception)e).haltError();
            }
        }, (ResponseTransformer)this.jsonTransformer);
    }

    public Optional<Route> reIndexMailboxesRoute() {
        return TaskFromRequestRegistry.builder().parameterName("task").registrations(this.usersMailboxesTaskRegistration).buildAsRouteOptional(this.taskManager);
    }

    public void defineDeleteUserMailbox() {
        this.service.delete(SPECIFIC_MAILBOX, (request, response) -> {
            try {
                this.userMailboxesService.deleteMailbox(UserMailboxesRoutes.getUsernameParam(request), new MailboxName(request.params(MAILBOX_NAME)), UserMailboxesRoutes.getOptions(request));
                return Responses.returnNoContent((Response)response);
            }
            catch (IllegalStateException e) {
                LOGGER.info("Invalid delete on user mailbox", (Throwable)e);
                throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message("Invalid delete on user mailboxes").cause((Exception)e).haltError();
            }
            catch (MailboxHaveChildrenException e) {
                LOGGER.info("Attempt to delete a mailbox with children");
                throw ErrorResponder.builder().statusCode(409).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Attempt to delete a mailbox with children").cause((Exception)e).haltError();
            }
            catch (IllegalArgumentException | MailboxNameException e) {
                LOGGER.info("Attempt to delete an invalid mailbox", e);
                throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Attempt to delete an invalid mailbox").cause((Exception)e).haltError();
            }
        });
    }

    public void defineDeleteUserMailboxes() {
        this.service.delete(USER_MAILBOXES_BASE, (request, response) -> {
            try {
                this.userMailboxesService.deleteMailboxes(UserMailboxesRoutes.getUsernameParam(request), UserMailboxesRoutes.getOptions(request));
                return Responses.returnNoContent((Response)response);
            }
            catch (IllegalStateException e) {
                LOGGER.info("Invalid delete on user mailboxes", (Throwable)e);
                throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message("Invalid delete on user mailboxes").cause((Exception)e).haltError();
            }
        });
    }

    public void defineMailboxExists() {
        this.service.get(SPECIFIC_MAILBOX, (request, response) -> {
            try {
                if (this.userMailboxesService.testMailboxExists(UserMailboxesRoutes.getUsernameParam(request), new MailboxName(request.params(MAILBOX_NAME)), UserMailboxesRoutes.getOptions(request))) {
                    return Responses.returnNoContent((Response)response);
                }
                throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message("Mailbox does not exist").haltError();
            }
            catch (IllegalStateException e) {
                LOGGER.info("Invalid get on user mailbox", (Throwable)e);
                throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message("Invalid get on user mailboxes").cause((Exception)e).haltError();
            }
            catch (IllegalArgumentException | MailboxNameException e) {
                LOGGER.info("Attempt to test existence of an invalid mailbox", e);
                throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Attempt to test existence of an invalid mailbox").cause((Exception)e).haltError();
            }
        });
    }

    public void defineCreateUserMailbox() {
        this.service.put(SPECIFIC_MAILBOX, (request, response) -> {
            try {
                this.userMailboxesService.createMailbox(UserMailboxesRoutes.getUsernameParam(request), new MailboxName(request.params(MAILBOX_NAME)), UserMailboxesRoutes.getOptions(request));
                return Responses.returnNoContent((Response)response);
            }
            catch (IllegalStateException e) {
                LOGGER.info("Invalid put on user mailbox", (Throwable)e);
                throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message("Invalid get on user mailboxes").cause((Exception)e).haltError();
            }
            catch (IllegalArgumentException | MailboxNameException e) {
                LOGGER.info("Attempt to create an invalid mailbox", e);
                throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Attempt to create an invalid mailbox").cause((Exception)e).haltError();
            }
        });
    }

    public void messageCount() {
        this.service.get(MESSAGE_COUNT_PATH, (request, response) -> {
            try {
                return this.userMailboxesService.messageCount(UserMailboxesRoutes.getUsernameParam(request), new MailboxName(request.params(MAILBOX_NAME)), UserMailboxesRoutes.getOptions(request));
            }
            catch (IllegalStateException | MailboxNotFoundException e) {
                LOGGER.info("Invalid get on user mailbox", e);
                throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message("Invalid get on user mailboxes").cause((Exception)e).haltError();
            }
            catch (IllegalArgumentException | MailboxNameException e) {
                LOGGER.info("Attempt to test existence of an invalid mailbox", e);
                throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Attempt to test existence of an invalid mailbox").cause((Exception)e).haltError();
            }
        });
    }

    public void unseenMessageCount() {
        this.service.get(UNSEEN_MESSAGE_COUNT_PATH, (request, response) -> {
            try {
                return this.userMailboxesService.unseenMessageCount(UserMailboxesRoutes.getUsernameParam(request), new MailboxName(request.params(MAILBOX_NAME)), UserMailboxesRoutes.getOptions(request));
            }
            catch (IllegalStateException | MailboxNotFoundException e) {
                LOGGER.info("Invalid get on user mailbox", e);
                throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message("Invalid get on user mailboxes").cause((Exception)e).haltError();
            }
            catch (IllegalArgumentException | MailboxNameException e) {
                LOGGER.info("Attempt to test existence of an invalid mailbox", e);
                throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Attempt to test existence of an invalid mailbox").cause((Exception)e).haltError();
            }
        });
    }

    public Task clearMailboxContent(Request request) throws UsersRepositoryException, MailboxException {
        Username username = UserMailboxesRoutes.getUsernameParam(request);
        MailboxName mailboxName = new MailboxName(request.params(MAILBOX_NAME));
        try {
            this.userMailboxesService.usernamePreconditions(username, UserMailboxesRoutes.getOptions(request));
            this.userMailboxesService.mailboxExistPreconditions(username, mailboxName);
        }
        catch (IllegalStateException e) {
            LOGGER.info("Invalid put on user mailbox", (Throwable)e);
            throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message("Invalid get on user mailboxes").cause((Exception)e).haltError();
        }
        return new ClearMailboxContentTask(username, mailboxName, this.userMailboxesService);
    }

    public static class UserReIndexingTaskRegistration
    extends TaskFromRequestRegistry.TaskRegistration {
        @Inject
        public UserReIndexingTaskRegistration(ReIndexer reIndexer) {
            super(MailboxesRoutes.RE_INDEX, request -> reIndexer.reIndex(UserMailboxesRoutes.getUsernameParam(request), ReindexingRunningOptionsParser.parse(request)));
        }
    }
}

