/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http;

import io.netty.resolver.AddressResolverGroup;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.TcpResources;

public final class HttpResources
extends TcpResources {
    final AtomicReference<ConnectionProvider> http2ConnectionProvider = new AtomicReference();
    static final BiFunction<LoopResources, ConnectionProvider, HttpResources> ON_HTTP_NEW = HttpResources::new;
    static final AtomicReference<HttpResources> httpResources = new AtomicReference();

    public static void disposeLoopsAndConnections() {
        HttpResources resources = httpResources.getAndSet(null);
        if (resources != null) {
            ConnectionProvider provider = resources.http2ConnectionProvider.get();
            if (provider != null) {
                provider.dispose();
            }
            resources._dispose();
        }
    }

    public static Mono<Void> disposeLoopsAndConnectionsLater() {
        return HttpResources.disposeLoopsAndConnectionsLater(Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_QUIET_PERIOD), Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_TIMEOUT));
    }

    public static Mono<Void> disposeLoopsAndConnectionsLater(Duration quietPeriod, Duration timeout) {
        Objects.requireNonNull(quietPeriod, "quietPeriod");
        Objects.requireNonNull(timeout, "timeout");
        return Mono.defer(() -> {
            HttpResources resources = httpResources.getAndSet(null);
            if (resources != null) {
                ConnectionProvider provider = resources.http2ConnectionProvider.get();
                Mono disposeProvider = Mono.empty();
                if (provider != null) {
                    disposeProvider = provider.disposeLater();
                }
                return Mono.when((Publisher[])new Publisher[]{disposeProvider, resources._disposeLater(quietPeriod, timeout)});
            }
            return Mono.empty();
        });
    }

    public static HttpResources get() {
        return (HttpResources)HttpResources.getOrCreate(httpResources, null, null, ON_HTTP_NEW, (String)"http");
    }

    public static HttpResources reset() {
        HttpResources.disposeLoopsAndConnections();
        return (HttpResources)HttpResources.getOrCreate(httpResources, null, null, ON_HTTP_NEW, (String)"http");
    }

    public static HttpResources set(ConnectionProvider provider) {
        return (HttpResources)HttpResources.getOrCreate(httpResources, null, (ConnectionProvider)provider, ON_HTTP_NEW, (String)"http");
    }

    public static HttpResources set(LoopResources loops) {
        return (HttpResources)HttpResources.getOrCreate(httpResources, (LoopResources)loops, null, ON_HTTP_NEW, (String)"http");
    }

    HttpResources(LoopResources loops, ConnectionProvider provider) {
        super(loops, provider);
    }

    public void disposeWhen(SocketAddress remoteAddress) {
        ConnectionProvider provider = this.http2ConnectionProvider.get();
        if (provider != null) {
            provider.disposeWhen(remoteAddress);
        }
        super.disposeWhen(remoteAddress);
    }

    public AddressResolverGroup<?> getOrCreateDefaultResolver() {
        return super.getOrCreateDefaultResolver();
    }

    public ConnectionProvider getOrCreateHttp2ConnectionProvider(Function<ConnectionProvider, ConnectionProvider> create) {
        ConnectionProvider provider = this.http2ConnectionProvider.get();
        if (provider == null) {
            ConnectionProvider newProvider = create.apply((ConnectionProvider)this);
            if (!this.http2ConnectionProvider.compareAndSet(null, newProvider)) {
                newProvider.dispose();
            }
            provider = this.getOrCreateHttp2ConnectionProvider(create);
        }
        return provider;
    }
}

