/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.indices.resolve_index.ResolveIndexAliasItem;
import org.opensearch.client.opensearch.indices.resolve_index.ResolveIndexItem;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ResolveIndexResponse
implements JsonpSerializable {
    private final List<ResolveIndexItem> indices;
    private final List<ResolveIndexAliasItem> aliases;
    public static final JsonpDeserializer<ResolveIndexResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ResolveIndexResponse::setupResolveIndexResponseDeserializer);

    private ResolveIndexResponse(Builder builder) {
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
        this.aliases = ApiTypeHelper.unmodifiableRequired(builder.aliases, (Object)this, "aliases");
    }

    public static ResolveIndexResponse of(Function<Builder, ObjectBuilder<ResolveIndexResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ResolveIndexItem> indices() {
        return this.indices;
    }

    public final List<ResolveIndexAliasItem> aliases() {
        return this.aliases;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (ResolveIndexItem resolveIndexItem : this.indices) {
                resolveIndexItem.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.aliases)) {
            generator.writeKey("aliases");
            generator.writeStartArray();
            for (ResolveIndexAliasItem resolveIndexAliasItem : this.aliases) {
                resolveIndexAliasItem.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupResolveIndexResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(ResolveIndexItem._DESERIALIZER), "indices");
        op.add(Builder::aliases, JsonpDeserializer.arrayDeserializer(ResolveIndexAliasItem._DESERIALIZER), "aliases");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ResolveIndexResponse> {
        private List<ResolveIndexItem> indices;
        private List<ResolveIndexAliasItem> aliases;

        public final Builder indices(List<ResolveIndexItem> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(ResolveIndexItem value, ResolveIndexItem ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder indices(Function<ResolveIndexItem.Builder, ObjectBuilder<ResolveIndexItem>> fn) {
            return this.indices(fn.apply(new ResolveIndexItem.Builder()).build(), new ResolveIndexItem[0]);
        }

        public final Builder aliases(List<ResolveIndexAliasItem> list) {
            this.aliases = Builder._listAddAll(this.aliases, list);
            return this;
        }

        public final Builder aliases(ResolveIndexAliasItem value, ResolveIndexAliasItem ... values) {
            this.aliases = Builder._listAdd(this.aliases, value, values);
            return this;
        }

        public final Builder aliases(Function<ResolveIndexAliasItem.Builder, ObjectBuilder<ResolveIndexAliasItem>> fn) {
            return this.aliases(fn.apply(new ResolveIndexAliasItem.Builder()).build(), new ResolveIndexAliasItem[0]);
        }

        @Override
        public ResolveIndexResponse build() {
            this._checkSingleUse();
            return new ResolveIndexResponse(this);
        }
    }
}

