/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpUtils;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.AggregateBase;
import org.opensearch.client.util.ApiTypeHelper;

public abstract class SingleMetricAggregateBase
extends AggregateBase {
    private final double value;
    @Nullable
    private final String valueAsString;

    protected SingleMetricAggregateBase(AbstractBuilder<?> builder) {
        super(builder);
        this.value = ApiTypeHelper.requireNonNull(builder.value, this, "value");
        this.valueAsString = builder.valueAsString;
    }

    public final double value() {
        return this.value;
    }

    @Nullable
    public final String valueAsString() {
        return this.valueAsString;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("value");
        JsonpUtils.serializeDoubleOrNull(generator, this.value, 0.0);
        if (this.valueAsString != null) {
            generator.writeKey("value_as_string");
            generator.write(this.valueAsString);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupSingleMetricAggregateBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        AggregateBase.setupAggregateBaseDeserializer(op);
        op.add(AbstractBuilder::value, JsonpDeserializer.doubleOrNullDeserializer(0.0), "value");
        op.add(AbstractBuilder::valueAsString, JsonpDeserializer.stringDeserializer(), "value_as_string");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends AggregateBase.AbstractBuilder<BuilderT> {
        private Double value;
        @Nullable
        private String valueAsString;

        protected AbstractBuilder() {
        }

        public final BuilderT value(double value) {
            this.value = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT valueAsString(@Nullable String value) {
            this.valueAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

