/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.parsing;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.AggregateMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionSignature;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.ViewMetadata;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.schema.DefaultKeyspaceMetadata;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.AggregateParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.FunctionParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.SchemaParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.SimpleJsonParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.TableParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.UserDefinedTypeParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.ViewParser;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.SchemaRows;
import com.datastax.oss.driver.internal.core.metadata.schema.refresh.SchemaRefresh;
import com.datastax.oss.driver.internal.core.util.NanoTime;
import com.datastax.oss.driver.shaded.guava.common.base.MoreObjects;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CassandraSchemaParser
implements SchemaParser {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraSchemaParser.class);
    private final SchemaRows rows;
    private final UserDefinedTypeParser userDefinedTypeParser;
    private final TableParser tableParser;
    private final ViewParser viewParser;
    private final FunctionParser functionParser;
    private final AggregateParser aggregateParser;
    private final String logPrefix;
    private final long startTimeNs = System.nanoTime();

    public CassandraSchemaParser(SchemaRows rows, InternalDriverContext context) {
        this.rows = rows;
        this.logPrefix = context.getSessionName();
        this.userDefinedTypeParser = new UserDefinedTypeParser(rows.dataTypeParser(), context);
        this.tableParser = new TableParser(rows, context);
        this.viewParser = new ViewParser(rows, context);
        this.functionParser = new FunctionParser(rows.dataTypeParser(), context);
        this.aggregateParser = new AggregateParser(rows.dataTypeParser(), context);
    }

    @Override
    public SchemaRefresh parse() {
        KeyspaceMetadata keyspace;
        ImmutableMap.Builder keyspacesBuilder = ImmutableMap.builder();
        for (AdminRow row : this.rows.keyspaces()) {
            keyspace = this.parseKeyspace(row);
            keyspacesBuilder.put((Object)keyspace.getName(), (Object)keyspace);
        }
        for (AdminRow row : this.rows.virtualKeyspaces()) {
            keyspace = this.parseVirtualKeyspace(row);
            keyspacesBuilder.put((Object)keyspace.getName(), (Object)keyspace);
        }
        SchemaRefresh refresh = new SchemaRefresh((Map<CqlIdentifier, KeyspaceMetadata>)keyspacesBuilder.build());
        LOG.debug("[{}] Schema parsing took {}", (Object)this.logPrefix, (Object)NanoTime.formatTimeSince(this.startTimeNs));
        return refresh;
    }

    private KeyspaceMetadata parseKeyspace(AdminRow keyspaceRow) {
        ImmutableMap replicationOptions;
        CqlIdentifier keyspaceId = CqlIdentifier.fromInternal(keyspaceRow.getString("keyspace_name"));
        boolean durableWrites = (Boolean)MoreObjects.firstNonNull((Object)keyspaceRow.getBoolean("durable_writes"), (Object)false);
        if (keyspaceRow.contains("strategy_class")) {
            String strategyClass = keyspaceRow.getString("strategy_class");
            Map<String, String> strategyOptions = SimpleJsonParser.parseStringMap(keyspaceRow.getString("strategy_options"));
            replicationOptions = ImmutableMap.builder().putAll(strategyOptions).put((Object)"class", (Object)strategyClass).build();
        } else {
            replicationOptions = keyspaceRow.getMapOfStringToString("replication");
        }
        Map<CqlIdentifier, UserDefinedType> types = this.parseTypes(keyspaceId);
        return new DefaultKeyspaceMetadata(keyspaceId, durableWrites, false, (Map<String, String>)replicationOptions, types, this.parseTables(keyspaceId, types), this.parseViews(keyspaceId, types), this.parseFunctions(keyspaceId, types), this.parseAggregates(keyspaceId, types));
    }

    private KeyspaceMetadata parseVirtualKeyspace(AdminRow keyspaceRow) {
        CqlIdentifier keyspaceId = CqlIdentifier.fromInternal(keyspaceRow.getString("keyspace_name"));
        boolean durableWrites = (Boolean)MoreObjects.firstNonNull((Object)keyspaceRow.getBoolean("durable_writes"), (Object)false);
        Map<String, String> replicationOptions = Collections.emptyMap();
        Map<CqlIdentifier, UserDefinedType> types = this.parseTypes(keyspaceId);
        return new DefaultKeyspaceMetadata(keyspaceId, durableWrites, true, replicationOptions, types, this.parseVirtualTables(keyspaceId, types), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    }

    private Map<CqlIdentifier, UserDefinedType> parseTypes(CqlIdentifier keyspaceId) {
        return this.userDefinedTypeParser.parse(this.rows.types().get((Object)keyspaceId), keyspaceId);
    }

    private Map<CqlIdentifier, TableMetadata> parseVirtualTables(CqlIdentifier keyspaceId, Map<CqlIdentifier, UserDefinedType> types) {
        ImmutableMap.Builder tablesBuilder = ImmutableMap.builder();
        for (AdminRow tableRow : this.rows.virtualTables().get((Object)keyspaceId)) {
            TableMetadata table = this.tableParser.parseVirtualTable(tableRow, keyspaceId, types);
            if (table == null) continue;
            tablesBuilder.put((Object)table.getName(), (Object)table);
        }
        return tablesBuilder.build();
    }

    private Map<CqlIdentifier, TableMetadata> parseTables(CqlIdentifier keyspaceId, Map<CqlIdentifier, UserDefinedType> types) {
        ImmutableMap.Builder tablesBuilder = ImmutableMap.builder();
        for (AdminRow tableRow : this.rows.tables().get((Object)keyspaceId)) {
            TableMetadata table = this.tableParser.parseTable(tableRow, keyspaceId, types);
            if (table == null) continue;
            tablesBuilder.put((Object)table.getName(), (Object)table);
        }
        return tablesBuilder.build();
    }

    private Map<CqlIdentifier, ViewMetadata> parseViews(CqlIdentifier keyspaceId, Map<CqlIdentifier, UserDefinedType> types) {
        ImmutableMap.Builder viewsBuilder = ImmutableMap.builder();
        for (AdminRow viewRow : this.rows.views().get((Object)keyspaceId)) {
            ViewMetadata view = this.viewParser.parseView(viewRow, keyspaceId, types);
            if (view == null) continue;
            viewsBuilder.put((Object)view.getName(), (Object)view);
        }
        return viewsBuilder.build();
    }

    private Map<FunctionSignature, FunctionMetadata> parseFunctions(CqlIdentifier keyspaceId, Map<CqlIdentifier, UserDefinedType> types) {
        ImmutableMap.Builder functionsBuilder = ImmutableMap.builder();
        for (AdminRow functionRow : this.rows.functions().get((Object)keyspaceId)) {
            FunctionMetadata function = this.functionParser.parseFunction(functionRow, keyspaceId, types);
            if (function == null) continue;
            functionsBuilder.put((Object)function.getSignature(), (Object)function);
        }
        return functionsBuilder.build();
    }

    private Map<FunctionSignature, AggregateMetadata> parseAggregates(CqlIdentifier keyspaceId, Map<CqlIdentifier, UserDefinedType> types) {
        ImmutableMap.Builder aggregatesBuilder = ImmutableMap.builder();
        for (AdminRow aggregateRow : this.rows.aggregates().get((Object)keyspaceId)) {
            AggregateMetadata aggregate = this.aggregateParser.parseAggregate(aggregateRow, keyspaceId, types);
            if (aggregate == null) continue;
            aggregatesBuilder.put((Object)aggregate.getSignature(), (Object)aggregate);
        }
        return aggregatesBuilder.build();
    }
}

