/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.Username;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.core.JmapRfc8621Configuration;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.core.Session;
import org.apache.james.jmap.core.UrlPrefixes$;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.routes.SessionRoutes$;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.user.api.DelegationStore;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import play.api.libs.json.Json$;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Set;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\t%r!B\u000f\u001f\u0011\u0003Ic!B\u0016\u001f\u0011\u0003a\u0003\"B\u001a\u0002\t\u0003!\u0004bB\u001b\u0002\u0005\u0004%IA\u000e\u0005\u0007\u0005\u0006\u0001\u000b\u0011B\u001c\t\u000f\r\u000b!\u0019!C\u0005m!1A)\u0001Q\u0001\n]Bq!R\u0001C\u0002\u0013%a\t\u0003\u0004N\u0003\u0001\u0006Ia\u0012\u0004\u0005Wy\u0001a\n\u0003\u0005\\\u0013\t\u0015\r\u0011\"\u0001]\u0011!\u0019\u0017B!A!\u0002\u0013i\u0006\u0002\u00033\n\u0005\u000b\u0007I\u0011A3\t\u0011%L!\u0011!Q\u0001\n\u0019D\u0001B[\u0005\u0003\u0006\u0004%\ta\u001b\u0005\ti&\u0011\t\u0011)A\u0005Y\"AQ/\u0003BC\u0002\u0013\u0005a\u000f\u0003\u0005~\u0013\t\u0005\t\u0015!\u0003x\u0011\u0015\u0019\u0014\u0002\"\u0001\u007f\u0011%\tI#\u0003b\u0001\n\u0013\tY\u0003\u0003\u0005\u0002<%\u0001\u000b\u0011BA\u0017\u0011%\ti$\u0003b\u0001\n\u0013\tY\u0003\u0003\u0005\u0002@%\u0001\u000b\u0011BA\u0017\u0011\u0019y\u0012\u0002\"\u0011\u0002B!9\u0011\u0011L\u0005\u0005\n\u0005m\u0003bBAF\u0013\u0011%\u0011Q\u0012\u0005\b\u0003wKA\u0011AA_\u0011\u001d\t\u0019/\u0003C\u0005\u0003KD\u0011B!\u0005\n#\u0003%IAa\u0005\u0002\u001bM+7o]5p]J{W\u000f^3t\u0015\ty\u0002%\u0001\u0004s_V$Xm\u001d\u0006\u0003C\t\nAA[7ba*\u00111\u0005J\u0001\u0006U\u0006lWm\u001d\u0006\u0003K\u0019\na!\u00199bG\",'\"A\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005)\nQ\"\u0001\u0010\u0003\u001bM+7o]5p]J{W\u000f^3t'\t\tQ\u0006\u0005\u0002/c5\tqFC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011tF\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%\nABS'B!~\u001bViU*J\u001f:+\u0012a\u000e\t\u0003q}r!!O\u001f\u0011\u0005izS\"A\u001e\u000b\u0005qB\u0013A\u0002\u001fs_>$h(\u0003\u0002?_\u00051\u0001K]3eK\u001aL!\u0001Q!\u0003\rM#(/\u001b8h\u0015\tqt&A\u0007K\u001b\u0006\u0003vlU#T'&{e\nI\u0001\u0010/\u0016cEjX&O\u001f^suLS'B!\u0006\u0001r+\u0012'M?.suj\u0016(`\u00156\u000b\u0005\u000bI\u0001\u0007\u0019>;u)\u0012*\u0016\u0003\u001d\u0003\"\u0001S&\u000e\u0003%S!A\u0013\u0014\u0002\u000bMdg\r\u000e6\n\u00051K%A\u0002'pO\u001e,'/A\u0004M\u001f\u001e;UI\u0015\u0011\u0014\u0007%yu\u000b\u0005\u0002Q+6\t\u0011K\u0003\u0002S'\u0006!A.\u00198h\u0015\u0005!\u0016\u0001\u00026bm\u0006L!AV)\u0003\r=\u0013'.Z2u!\tA\u0016,D\u0001!\u0013\tQ\u0006E\u0001\u0006K\u001b\u0006\u0003&k\\;uKN\fQ\"Y;uQ\u0016tG/[2bi>\u0014X#A/\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001\u0004\u0013\u0001\u00025uiBL!AY0\u0003\u001b\u0005+H\u000f[3oi&\u001c\u0017\r^8s\u00039\tW\u000f\u001e5f]RL7-\u0019;pe\u0002\nqb]3tg&|gnU;qa2LWM]\u000b\u0002MB\u0011!fZ\u0005\u0003Qz\u0011qbU3tg&|gnU;qa2LWM]\u0001\u0011g\u0016\u001c8/[8o'V\u0004\b\u000f\\5fe\u0002\nq\u0002Z3mK\u001e\fG/[8o'R|'/Z\u000b\u0002YB\u0011QN]\u0007\u0002]*\u0011q\u000e]\u0001\u0004CBL'BA9#\u0003\u0011)8/\u001a:\n\u0005Mt'a\u0004#fY\u0016<\u0017\r^5p]N#xN]3\u0002!\u0011,G.Z4bi&|gn\u0015;pe\u0016\u0004\u0013\u0001\u00076nCB\u0014fm\u0019\u001d7eE\u001auN\u001c4jOV\u0014\u0018\r^5p]V\tq\u000f\u0005\u0002yw6\t\u0011P\u0003\u0002{A\u0005!1m\u001c:f\u0013\ta\u0018P\u0001\rK[\u0006\u0004(KZ29mI\n4i\u001c8gS\u001e,(/\u0019;j_:\f\u0011D[7baJ37\r\u000f\u001c3c\r{gNZ5hkJ\fG/[8oAQIq0!\u0001\u0002\u001c\u0005u\u0011q\u0004\t\u0003U%AQa\u0017\nA\u0002uC\u0003\"!\u0001\u0002\u0006\u0005U\u0011q\u0003\t\u0005\u0003\u000f\t\t\"\u0004\u0002\u0002\n)!\u00111BA\u0007\u0003\u0019IgN[3di*\u0011\u0011qB\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0003'\tIAA\u0003OC6,G-A\u0003wC2,X-\t\u0002\u0002\u001a\u0005A!KR\".qY\u0012\u0014\u0007C\u0003e%\u0001\u0007a\rC\u0003k%\u0001\u0007A\u000eC\u0003v%\u0001\u0007q\u000fK\u0002\u0013\u0003G\u0001B!a\u0002\u0002&%!\u0011qEA\u0005\u0005\u0019IeN[3di\u0006yq-\u001a8fe\u0006$XmU3tg&|g.\u0006\u0002\u0002.A!\u0011qFA\u001b\u001d\rA\u0016\u0011G\u0005\u0004\u0003g\u0001\u0013!\u0003&N\u0003B\u0013v.\u001e;f\u0013\u0011\t9$!\u000f\u0003\r\u0005\u001bG/[8o\u0015\r\t\u0019\u0004I\u0001\u0011O\u0016tWM]1uKN+7o]5p]\u0002\n\u0011C]3eSJ,7\r\u001e+p'\u0016\u001c8/[8o\u0003I\u0011X\rZ5sK\u000e$Hk\\*fgNLwN\u001c\u0011\u0015\u0005\u0005\r\u0003CBA#\u0003\u001f\n\u0019&\u0004\u0002\u0002H)!\u0011\u0011JA&\u0003\u0019\u0019HO]3b[*\u0019\u0011QJ*\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003#\n9E\u0001\u0004TiJ,\u0017-\u001c\t\u00041\u0006U\u0013bAA,A\tI!*T!Q%>,H/Z\u0001\u0012O\u0016$H)\u001a7fO\u0006$X\rZ+tKJ\u001cH\u0003BA/\u0003w\u0002b!a\u0018\u0002n\u0005ETBAA1\u0015\u0011\t\u0019'!\u001a\u0002\u0013A,(\r\\5tQ\u0016\u0014(b\u0001\u0019\u0002h)\u0019!0!\u001b\u000b\u0005\u0005-\u0014a\u0002:fC\u000e$xN]\u0005\u0005\u0003_\n\tGA\u0003T\r2,\b\u0010\u0005\u0003\u0002t\u0005]TBAA;\u0015\tQ(%\u0003\u0003\u0002z\u0005U$\u0001C+tKJt\u0017-\\3\t\u000f\u0005u\u0004\u00041\u0001\u0002\u0000\u0005qQ.Y5mE>D8+Z:tS>t\u0007\u0003BAA\u0003\u000fk!!a!\u000b\u0007\u0005\u0015%%A\u0004nC&d'm\u001c=\n\t\u0005%\u00151\u0011\u0002\u000f\u001b\u0006LGNY8y'\u0016\u001c8/[8o\u0003-\u0019XM\u001c3SKN\u0004xN\u001c3\u0015\r\u0005=\u00151TAS!\u0019\ty&!%\u0002\u0016&!\u00111SA1\u0005\u0015\u0019Vj\u001c8p!\r\u0001\u0016qS\u0005\u0004\u00033\u000b&\u0001\u0002,pS\u0012Dq!!(\u001a\u0001\u0004\ty*A\u0004tKN\u001c\u0018n\u001c8\u0011\u0007a\f\t+C\u0002\u0002$f\u0014qaU3tg&|g\u000eC\u0004\u0002(f\u0001\r!!+\u0002\tI,7\u000f\u001d\t\u0005\u0003W\u000b9,\u0004\u0002\u0002.*!\u0011qVAY\u0003\u0019\u0019XM\u001d<fe*\u0019\u0001-a-\u000b\t\u0005U\u0016\u0011N\u0001\u0006]\u0016$H/_\u0005\u0005\u0003s\u000biK\u0001\nIiR\u00048+\u001a:wKJ\u0014Vm\u001d9p]N,\u0017!D3se>\u0014\b*\u00198eY&tw\r\u0006\u0004\u0002@\u0006%\u0017q\u001c\t\u0007\u0003\u0003\f)-!&\u000e\u0005\u0005\r'\u0002BA2\u0003OJA!a2\u0002D\n!Qj\u001c8p\u0011\u001d\tYM\u0007a\u0001\u0003\u001b\f\u0011\u0002\u001e5s_^\f'\r\\3\u0011\t\u0005=\u0017\u0011\u001c\b\u0005\u0003#\f)ND\u0002;\u0003'L\u0011\u0001M\u0005\u0004\u0003/|\u0013a\u00029bG.\fw-Z\u0005\u0005\u00037\fiNA\u0005UQJ|w/\u00192mK*\u0019\u0011q[\u0018\t\u000f\u0005\u0005(\u00041\u0001\u0002*\u0006A!/Z:q_:\u001cX-\u0001\bsKN\u0004xN\u001c3EKR\f\u0017\u000e\\:\u0015\u0011\u0005}\u0016q]Av\u0003kDq!!;\u001c\u0001\u0004\tI+\u0001\niiR\u00048+\u001a:wKJ\u0014Vm\u001d9p]N,\u0007bBAw7\u0001\u0007\u0011q^\u0001\bI\u0016$\u0018-\u001b7t!\rA\u0018\u0011_\u0005\u0004\u0003gL(A\u0004)s_\ndW-\u001c#fi\u0006LGn\u001d\u0005\n\u0003o\\\u0002\u0013!a\u0001\u0003s\f!b\u001d;biV\u001c8i\u001c3f!\u0011\tYP!\u0004\u000e\u0005\u0005u(b\u00011\u0002\u0000*!!\u0011\u0001B\u0002\u0003\u0015\u0019w\u000eZ3d\u0015\u0011\u0011)Aa\u0002\u0002\u000f!\fg\u000e\u001a7fe*!\u0011Q\u0017B\u0005\u0015\t\u0011Y!\u0001\u0002j_&!!qBA\u007f\u0005IAE\u000f\u001e9SKN\u0004xN\\:f'R\fG/^:\u00021I,7\u000f]8oI\u0012+G/Y5mg\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u0016)\"\u0011\u0011 B\fW\t\u0011I\u0002\u0005\u0003\u0003\u001c\t\u0015RB\u0001B\u000f\u0015\u0011\u0011yB!\t\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0012_\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u001d\"Q\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class SessionRoutes
implements JMAPRoutes {
    private final Authenticator authenticator;
    private final SessionSupplier sessionSupplier;
    private final DelegationStore delegationStore;
    private final JmapRfc8621Configuration jmapRfc8621Configuration;
    private final JMAPRoute.Action generateSession;
    private final JMAPRoute.Action redirectToSession;

    public Mono<Void> handleInternalError(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleInternalError(x$1, x$2, x$3);
    }

    public Mono<Void> handleBadRequest(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleBadRequest(x$1, x$2, x$3);
    }

    public Mono<Void> handleAuthenticationFailure(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleAuthenticationFailure(x$1, x$2, x$3);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    public DelegationStore delegationStore() {
        return this.delegationStore;
    }

    public JmapRfc8621Configuration jmapRfc8621Configuration() {
        return this.jmapRfc8621Configuration;
    }

    private JMAPRoute.Action generateSession() {
        return this.generateSession;
    }

    private JMAPRoute.Action redirectToSession() {
        return this.redirectToSession;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(Endpoint.ofFixedPath((HttpMethod)HttpMethod.GET, (String)SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$JMAP_SESSION())).action(this.generateSession()).corsHeaders(), JMAPRoute.builder().endpoint(Endpoint.ofFixedPath((HttpMethod)HttpMethod.OPTIONS, (String)SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$JMAP_SESSION())).action(JMAPRoutes.CORS_CONTROL).noCorsHeaders(), JMAPRoute.builder().endpoint(Endpoint.ofFixedPath((HttpMethod)HttpMethod.GET, (String)SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$WELL_KNOWN_JMAP())).action(this.redirectToSession()).corsHeaders(), JMAPRoute.builder().endpoint(Endpoint.ofFixedPath((HttpMethod)HttpMethod.OPTIONS, (String)SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$WELL_KNOWN_JMAP())).action(JMAPRoutes.CORS_CONTROL).noCorsHeaders()});
    }

    private SFlux<Username> getDelegatedUsers(MailboxSession mailboxSession) {
        return SFlux$.MODULE$.apply(this.delegationStore().delegatedUsers((Username)OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mailboxSession.getLoggedInUser())).getOrElse((Function0 & Serializable)() -> mailboxSession.getUser())));
    }

    private SMono<Void> sendRespond(Session session, HttpServerResponse resp) {
        return SMono$.MODULE$.fromCallable(() -> Json$.MODULE$.stringify(ResponseSerializer$.MODULE$.serialize(session))).map((Function1 & Serializable)x$1 -> x$1.getBytes(StandardCharsets.UTF_8)).flatMap((Function1 & Serializable)bytes -> SMono$.MODULE$.apply((Publisher)resp.header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json; charset=UTF-8").status(HttpResponseStatus.OK).header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(((byte[])bytes).length)).sendByteArray((Publisher)SMono$.MODULE$.just(bytes)).then()));
    }

    public Mono<Void> errorHandling(Throwable throwable, HttpServerResponse response) {
        Throwable throwable2 = throwable;
        if (throwable2 instanceof UnauthorizedException) {
            UnauthorizedException unauthorizedException = (UnauthorizedException)throwable2;
            SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$LOGGER().warn("Unauthorized", (Throwable)unauthorizedException);
            HttpResponseStatus x$1 = HttpResponseStatus.UNAUTHORIZED;
            String x$2 = unauthorizedException.getMessage();
            String x$3 = ProblemDetails$.MODULE$.apply$default$1();
            Option<String> x$4 = ProblemDetails$.MODULE$.apply$default$3();
            return this.respondDetails(unauthorizedException.addHeaders(response), new ProblemDetails(x$3, x$1, x$4, x$2), HttpResponseStatus.UNAUTHORIZED);
        }
        SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$LOGGER().error("Unexpected error upon requesting session", throwable2);
        HttpResponseStatus x$5 = HttpResponseStatus.INTERNAL_SERVER_ERROR;
        String x$6 = throwable2.getMessage();
        String x$7 = ProblemDetails$.MODULE$.apply$default$1();
        Option<String> x$8 = ProblemDetails$.MODULE$.apply$default$3();
        return this.respondDetails(response, new ProblemDetails(x$7, x$5, x$8, x$6), HttpResponseStatus.INTERNAL_SERVER_ERROR);
    }

    private Mono<Void> respondDetails(HttpServerResponse httpServerResponse, ProblemDetails details, HttpResponseStatus statusCode) {
        return SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details).toString()).map((Function1 & Serializable)x$2 -> x$2.getBytes(StandardCharsets.UTF_8)).flatMap((Function1 & Serializable)bytes -> SMono$.MODULE$.fromPublisher((Publisher)httpServerResponse.status(details.status()).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(((byte[])bytes).length)).sendByteArray((Publisher)SMono$.MODULE$.just(bytes)).then())).asJava();
    }

    private HttpResponseStatus respondDetails$default$3() {
        return HttpResponseStatus.BAD_REQUEST;
    }

    public static final /* synthetic */ void $anonfun$generateSession$4(SessionRoutes $this, HttpServerRequest request$1, Pair x0$1, SynchronousSink x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 != null) {
            Pair baseUserAndDelegatedUsers = (Pair)tuple2._1();
            SynchronousSink sink = (SynchronousSink)tuple2._2();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)$this.sessionSupplier().generate((Username)baseUserAndDelegatedUsers.getLeft(), (Set<Username>)((IterableOnceOps)baseUserAndDelegatedUsers.getRight()).toSet(), UrlPrefixes$.MODULE$.from($this.jmapRfc8621Configuration(), request$1)).fold((Function1 & Serializable)x$1 -> {
                sink.error(x$1);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)session -> {
                sink.next((Object)session);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Inject
    public SessionRoutes(@Named(value="RFC-8621") Authenticator authenticator, SessionSupplier sessionSupplier, DelegationStore delegationStore, JmapRfc8621Configuration jmapRfc8621Configuration) {
        this.authenticator = authenticator;
        this.sessionSupplier = sessionSupplier;
        this.delegationStore = delegationStore;
        this.jmapRfc8621Configuration = jmapRfc8621Configuration;
        this.generateSession = (request, response) -> SMono$.MODULE$.fromPublisher((Publisher)this.authenticator().authenticate(request)).flatMap((Function1 & Serializable)mailboxSession -> this.getDelegatedUsers((MailboxSession)mailboxSession).collectSeq().map((Function1 & Serializable)seq -> Pair.of((Object)mailboxSession.getUser(), (Object)seq))).handle((Function2 & Serializable)(x0$1, x1$1) -> {
            SessionRoutes.$anonfun$generateSession$4(this, request, x0$1, x1$1);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)session -> this.sendRespond((Session)session, response)).onErrorResume((Function1 & Serializable)throwable -> SMono$.MODULE$.fromPublisher(this.errorHandling((Throwable)throwable, response))).asJava();
        this.redirectToSession = JMAPRoutes.redirectTo((String)SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$JMAP_SESSION());
    }
}

