/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.opensearch;

import org.apache.james.backends.opensearch.AliasName;
import org.apache.james.backends.opensearch.IndexCreationFactory;
import org.apache.james.backends.opensearch.IndexName;
import org.apache.james.backends.opensearch.OpenSearchConfiguration;
import org.apache.james.backends.opensearch.ReactorOpenSearchClient;
import org.apache.james.backends.opensearch.ReadAliasName;
import org.apache.james.backends.opensearch.WriteAliasName;
import org.apache.james.mailbox.opensearch.MailboxMappingFactory;
import org.apache.james.mailbox.opensearch.MailboxOpenSearchConstants;

public class MailboxIndexCreationUtil {
    public static ReactorOpenSearchClient prepareClient(ReactorOpenSearchClient client, ReadAliasName readAlias, WriteAliasName writeAlias, IndexName indexName, OpenSearchConfiguration configuration) {
        return new IndexCreationFactory(configuration).useIndex(indexName).addAlias(new AliasName[]{readAlias}).addAlias(new AliasName[]{writeAlias}).createIndexAndAliases(client, MailboxMappingFactory.getMappingContent());
    }

    public static ReactorOpenSearchClient prepareDefaultClient(ReactorOpenSearchClient client, OpenSearchConfiguration configuration) {
        return MailboxIndexCreationUtil.prepareClient(client, MailboxOpenSearchConstants.DEFAULT_MAILBOX_READ_ALIAS, MailboxOpenSearchConstants.DEFAULT_MAILBOX_WRITE_ALIAS, MailboxOpenSearchConstants.DEFAULT_MAILBOX_INDEX, configuration);
    }
}

