/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.james.transport.mailets.Sign;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMIMESign
extends Sign {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMIMESign.class);

    @Override
    public String getMailetInfo() {
        return "SMIME Signature Mailet";
    }

    @Override
    protected Set<String> getAllowedInitParameters() {
        return ImmutableSet.of("debug", "keyStoreFileName", "keyStorePassword", "keyStoreType", "keyAlias", "keyAliasPassword", new String[]{"signerName", "postmasterSigns", "rebuildFrom", "explanationText"});
    }

    @Override
    public String getExplanationText() {
        String explanationText = super.getExplanationText();
        if (explanationText == null) {
            explanationText = "The message this file is attached to has been signed on the server by\r\n\t\"[signerName]\" <[signerAddress]>\r\nto certify that the sender is known and truly has the following address (reverse-path):\r\n\t[reversePath]\r\nand that the original message has the following message headers:\r\n\r\n[headers]\r\n\r\nThe signature envelopes this attachment too.\r\nPlease check the signature integrity.\r\n\r\n\t\"[signerName]\" <[signerAddress]>";
        }
        return explanationText;
    }

    @Override
    protected void initKeyHolderClass() throws MessagingException {
        String keyHolderClassName = "org.apache.james.transport.SMIMEKeyHolder";
        try {
            this.setKeyHolderClass(Class.forName(keyHolderClassName));
        }
        catch (ClassNotFoundException cnfe) {
            throw new MessagingException(keyHolderClassName + "does not exist.");
        }
        if (this.isDebug()) {
            LOGGER.debug("keyHolderClass: {}", (Object)this.getKeyHolderClass());
        }
    }

    @Override
    protected void initPostmasterSigns() {
        this.setPostmasterSigns(this.getInitParameter("postmasterSigns") == null ? true : Boolean.parseBoolean(this.getInitParameter("postmasterSigns")));
    }

    @Override
    protected void initRebuildFrom() throws MessagingException {
        this.setRebuildFrom(this.getInitParameter("rebuildFrom") == null ? true : Boolean.parseBoolean(this.getInitParameter("rebuildFrom")));
        if (this.isDebug()) {
            if (this.isRebuildFrom()) {
                LOGGER.debug("Will modify the \"From:\" header.");
            } else {
                LOGGER.debug("Will leave the \"From:\" header unchanged.");
            }
        }
    }

    @Override
    protected MimeBodyPart getWrapperBodyPart(Mail mail) throws MessagingException, IOException {
        String explanationText = this.getExplanationText();
        if (explanationText == null) {
            return null;
        }
        MimeMessage originalMessage = mail.getMessage();
        MimeBodyPart messagePart = new MimeBodyPart();
        MimeBodyPart signatureReason = new MimeBodyPart();
        String contentType = originalMessage.getContentType();
        Object content = originalMessage.getContent();
        if (contentType == null || content == null) {
            throw new MessagingException("Either the content type or the content is null");
        }
        messagePart.setContent(content, contentType);
        String headers = this.getMessageHeaders(originalMessage);
        signatureReason.setText(this.getReplacedExplanationText(this.getExplanationText(), this.getSignerName(), this.getKeyHolder().getSignerAddress(), mail.getMaybeSender().asString(), headers));
        signatureReason.setFileName("SignatureExplanation.txt");
        MimeMultipart wrapperMultiPart = new MimeMultipart();
        wrapperMultiPart.addBodyPart(messagePart);
        wrapperMultiPart.addBodyPart(signatureReason);
        MimeBodyPart wrapperBodyPart = new MimeBodyPart();
        wrapperBodyPart.setContent(wrapperMultiPart);
        return wrapperBodyPart;
    }
}

