/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.api;

import org.eclipse.milo.opcua.sdk.server.Lifecycle;
import org.eclipse.milo.opcua.sdk.server.LifecycleManager;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.UaNodeManager;
import org.eclipse.milo.opcua.sdk.server.api.AddressSpaceComposite;
import org.eclipse.milo.opcua.sdk.server.api.ManagedAddressSpaceFragment;

public abstract class ManagedAddressSpaceFragmentWithLifecycle
extends ManagedAddressSpaceFragment
implements Lifecycle {
    private final LifecycleManager lifecycleManager = new LifecycleManager();
    private final AddressSpaceComposite composite;

    public ManagedAddressSpaceFragmentWithLifecycle(OpcUaServer server) {
        this(server, server.getAddressSpaceManager());
    }

    public ManagedAddressSpaceFragmentWithLifecycle(OpcUaServer server, final AddressSpaceComposite composite) {
        super(server);
        this.composite = composite;
        this.getLifecycleManager().addLifecycle(new Lifecycle(){

            @Override
            public void startup() {
                ManagedAddressSpaceFragmentWithLifecycle.this.registerWithComposite(composite);
                ManagedAddressSpaceFragmentWithLifecycle.this.registerNodeManager(ManagedAddressSpaceFragmentWithLifecycle.this.getNodeManager());
            }

            @Override
            public void shutdown() {
                composite.unregister(ManagedAddressSpaceFragmentWithLifecycle.this);
                ManagedAddressSpaceFragmentWithLifecycle.this.unregisterNodeManager(ManagedAddressSpaceFragmentWithLifecycle.this.getNodeManager());
            }
        });
    }

    public ManagedAddressSpaceFragmentWithLifecycle(OpcUaServer server, UaNodeManager nodeManager) {
        this(server, nodeManager, server.getAddressSpaceManager());
    }

    public ManagedAddressSpaceFragmentWithLifecycle(OpcUaServer server, UaNodeManager nodeManager, final AddressSpaceComposite composite) {
        super(server, nodeManager);
        this.composite = composite;
        this.getLifecycleManager().addLifecycle(new Lifecycle(){

            @Override
            public void startup() {
                ManagedAddressSpaceFragmentWithLifecycle.this.registerWithComposite(composite);
                ManagedAddressSpaceFragmentWithLifecycle.this.registerNodeManager(ManagedAddressSpaceFragmentWithLifecycle.this.getNodeManager());
            }

            @Override
            public void shutdown() {
                composite.unregister(ManagedAddressSpaceFragmentWithLifecycle.this);
                ManagedAddressSpaceFragmentWithLifecycle.this.unregisterNodeManager(ManagedAddressSpaceFragmentWithLifecycle.this.getNodeManager());
            }
        });
    }

    @Override
    public final void startup() {
        this.lifecycleManager.startup();
    }

    @Override
    public final void shutdown() {
        this.lifecycleManager.shutdown();
    }

    public AddressSpaceComposite getComposite() {
        return this.composite;
    }

    protected LifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    protected void registerWithComposite(AddressSpaceComposite composite) {
        composite.register(this);
    }

    protected void registerNodeManager(UaNodeManager nodeManager) {
        this.getServer().getAddressSpaceManager().register(nodeManager);
    }

    protected void unregisterNodeManager(UaNodeManager nodeManager) {
        this.getServer().getAddressSpaceManager().unregister(nodeManager);
    }
}

