/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.event.batch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;

public class SubscriptionPipeTabletIterationSnapshot {
    private final List<EnrichedEvent> iteratedEnrichedEvents = new ArrayList<EnrichedEvent>();
    private final List<PipeRawTabletInsertionEvent> parsedEnrichedEvents = new ArrayList<PipeRawTabletInsertionEvent>();

    public List<EnrichedEvent> getIteratedEnrichedEvents() {
        return Collections.unmodifiableList(this.iteratedEnrichedEvents);
    }

    public void addIteratedEnrichedEvent(EnrichedEvent enrichedEvent) {
        this.iteratedEnrichedEvents.add(enrichedEvent);
    }

    public void addParsedEnrichedEvent(PipeRawTabletInsertionEvent enrichedEvent) {
        this.parsedEnrichedEvents.add(enrichedEvent);
    }

    public void ack() {
        this.closeIteratedEnrichedEvents();
        this.decreaseReferenceCountOfParsedEnrichedEvents();
    }

    public void cleanUp() {
        this.closeIteratedEnrichedEvents();
        this.clearReferenceCountOfParsedEnrichedEvents();
    }

    private void closeIteratedEnrichedEvents() {
        for (EnrichedEvent enrichedEvent : this.iteratedEnrichedEvents) {
            if (enrichedEvent instanceof PipeTsFileInsertionEvent) {
                ((PipeTsFileInsertionEvent)enrichedEvent).close();
            }
            if (enrichedEvent instanceof PipeInsertNodeTabletInsertionEvent) {
                ((PipeInsertNodeTabletInsertionEvent)enrichedEvent).close();
            }
            if (!(enrichedEvent instanceof PipeRawTabletInsertionEvent)) continue;
            ((PipeRawTabletInsertionEvent)enrichedEvent).close();
        }
    }

    private void decreaseReferenceCountOfParsedEnrichedEvents() {
        for (PipeRawTabletInsertionEvent event : this.parsedEnrichedEvents) {
            event.decreaseReferenceCount(this.getClass().getName(), true);
        }
    }

    private void clearReferenceCountOfParsedEnrichedEvents() {
        for (PipeRawTabletInsertionEvent event : this.parsedEnrichedEvents) {
            event.clearReferenceCount(this.getClass().getName());
        }
    }
}

