/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WrappedInsertStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;

public class InsertRow
extends WrappedInsertStatement {
    public InsertRow(InsertRowStatement insertRowStatement, MPPQueryContext context) {
        super(insertRowStatement, context);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitInsertRow(this, context);
    }

    @Override
    public InsertRowStatement getInnerTreeStatement() {
        return (InsertRowStatement)super.getInnerTreeStatement();
    }

    @Override
    public void updateAfterSchemaValidation(MPPQueryContext context) throws QueryProcessException {
        this.getInnerTreeStatement().updateAfterSchemaValidation(context);
    }

    @Override
    public String getTableName() {
        return this.getInnerTreeStatement().getDevicePath().getFullPath();
    }

    @Override
    public List<Object[]> getDeviceIdList() {
        InsertRowStatement insertRowStatement = this.getInnerTreeStatement();
        Object[] segments = insertRowStatement.getTableDeviceID().getSegments();
        return Collections.singletonList(Arrays.copyOfRange(segments, 1, segments.length));
    }

    @Override
    public List<String> getAttributeColumnNameList() {
        InsertRowStatement insertRowStatement = this.getInnerTreeStatement();
        return insertRowStatement.getAttributeColumnNameList();
    }

    @Override
    public List<Object[]> getAttributeValueList() {
        InsertRowStatement insertRowStatement = this.getInnerTreeStatement();
        List<Integer> attrColumnIndices = insertRowStatement.getAttrColumnIndices();
        Object[] attrValues = new Object[attrColumnIndices.size()];
        for (int j = 0; j < attrColumnIndices.size(); ++j) {
            int columnIndex = attrColumnIndices.get(j);
            attrValues[j] = insertRowStatement.getValues()[columnIndex];
        }
        return Collections.singletonList(attrValues);
    }
}

