/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.analyzer.predicate.schema;

import java.util.Objects;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.predicate.schema.ExtractPredicateColumnNameVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BetweenPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NotExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckSchemaPredicateVisitor
extends AstVisitor<Boolean, Context> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckSchemaPredicateVisitor.class);
    private static final long LOG_INTERVAL_MS = 60000L;
    private long lastLogTime = System.currentTimeMillis();

    @Override
    public Boolean visitExpression(Expression node, Context context) {
        return this.processColumn(node, context);
    }

    @Override
    protected Boolean visitLogicalExpression(LogicalExpression node, Context context) {
        if (node.getOperator().equals((Object)LogicalExpression.Operator.AND)) {
            if (System.currentTimeMillis() - this.lastLogTime >= 60000L) {
                LOGGER.info("And expression encountered during id determined checking, will be classified into fuzzy expression. Sql: {}", (Object)context.queryContext.getSql());
                this.lastLogTime = System.currentTimeMillis();
            }
            return true;
        }
        if (context.isDirectDeviceQuery) {
            return true;
        }
        return node.getTerms().stream().anyMatch(predicate -> predicate.accept(this, context));
    }

    @Override
    protected Boolean visitNotExpression(NotExpression node, Context context) {
        if (node.getValue().getExpressionType().equals((Object)TableExpressionType.LOGICAL_EXPRESSION)) {
            if (System.currentTimeMillis() - this.lastLogTime >= 60000L) {
                LOGGER.info("Logical expression type encountered in not expression child during id determined checking, will be classified into fuzzy expression. Sql: {}", (Object)context.queryContext.getSql());
                this.lastLogTime = System.currentTimeMillis();
            }
            return true;
        }
        return node.getValue().accept(this, context);
    }

    @Override
    protected Boolean visitComparisonExpression(ComparisonExpression node, Context context) {
        return !(node.getLeft() instanceof Literal) && !(node.getRight() instanceof Literal) || this.processColumn(node, context);
    }

    @Override
    protected Boolean visitBetweenPredicate(BetweenPredicate node, Context context) {
        return node.getValue() instanceof SymbolReference && (node.getMin() instanceof SymbolReference || node.getMax() instanceof SymbolReference) || this.processColumn(node, context);
    }

    private boolean processColumn(Expression node, Context context) {
        TsTableColumnSchema schema = context.table.getColumnSchema(node.accept(ExtractPredicateColumnNameVisitor.getInstance(), null));
        if (Objects.isNull(schema)) {
            return true;
        }
        if (schema.getColumnCategory() == TsTableColumnCategory.TIME || schema.getColumnCategory() == TsTableColumnCategory.FIELD) {
            throw new SemanticException("The TIME/FIELD columns are currently not allowed in devices related operations");
        }
        return schema.getColumnCategory().equals((Object)TsTableColumnCategory.ATTRIBUTE);
    }

    public static class Context {
        private final TsTable table;
        private final MPPQueryContext queryContext;
        private final boolean isDirectDeviceQuery;

        public Context(TsTable table, MPPQueryContext queryContext, boolean isDirectDeviceQuery) {
            this.table = table;
            this.queryContext = queryContext;
            this.isDirectDeviceQuery = isDirectDeviceQuery;
        }
    }
}

