/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.write;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.exception.query.OutOfTTLException;
import org.apache.iotdb.db.queryengine.plan.analyze.IAnalysis;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TableDeviceSchemaCache;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class RelationalInsertTabletNode
extends InsertTabletNode {
    private IDeviceID[] deviceIDs;
    private boolean singleDevice;

    public RelationalInsertTabletNode(PlanNodeId id, PartialPath devicePath, boolean isAligned, String[] measurements, TSDataType[] dataTypes, MeasurementSchema[] measurementSchemas, long[] times, BitMap[] bitMaps, Object[] columns, int rowCount, TsTableColumnCategory[] columnCategories) {
        super(id, devicePath, isAligned, measurements, dataTypes, measurementSchemas, times, bitMaps, columns, rowCount);
        this.setColumnCategories(columnCategories);
    }

    public RelationalInsertTabletNode(PlanNodeId id) {
        super(id);
    }

    @TestOnly
    public RelationalInsertTabletNode(PlanNodeId id, PartialPath devicePath, boolean isAligned, String[] measurements, TSDataType[] dataTypes, long[] times, BitMap[] bitMaps, Object[] columns, int rowCount, TsTableColumnCategory[] columnCategories) {
        super(id, devicePath, isAligned, measurements, dataTypes, times, bitMaps, columns, rowCount);
        this.setColumnCategories(columnCategories);
    }

    public void setSingleDevice() {
        this.singleDevice = true;
    }

    @Override
    public IDeviceID getDeviceID(int rowIdx) {
        if (this.singleDevice) {
            if (this.deviceIDs == null) {
                this.deviceIDs = new IDeviceID[1];
            }
            if (this.deviceIDs[0] == null) {
                String[] deviceIdSegments = new String[this.idColumnIndices.size() + 1];
                deviceIdSegments[0] = this.getTableName();
                for (int i = 0; i < this.idColumnIndices.size(); ++i) {
                    Integer columnIndex = (Integer)this.idColumnIndices.get(i);
                    Object idSeg = ((Object[])this.columns[columnIndex])[0];
                    boolean isNull = this.bitMaps != null && this.bitMaps[columnIndex] != null && this.bitMaps[columnIndex].isMarked(0);
                    deviceIdSegments[i + 1] = !isNull && idSeg != null ? idSeg.toString() : null;
                }
                this.deviceIDs[0] = IDeviceID.Factory.DEFAULT_FACTORY.create(deviceIdSegments);
            }
            return this.deviceIDs[0];
        }
        if (this.deviceIDs == null) {
            this.deviceIDs = new IDeviceID[this.rowCount];
        }
        if (this.deviceIDs[rowIdx] == null) {
            String[] deviceIdSegments = new String[this.idColumnIndices.size() + 1];
            deviceIdSegments[0] = this.getTableName();
            for (int i = 0; i < this.idColumnIndices.size(); ++i) {
                Integer columnIndex = (Integer)this.idColumnIndices.get(i);
                Object idSeg = ((Object[])this.columns[columnIndex])[rowIdx];
                boolean isNull = this.bitMaps != null && this.bitMaps[columnIndex] != null && this.bitMaps[columnIndex].isMarked(rowIdx);
                deviceIdSegments[i + 1] = !isNull && idSeg != null ? idSeg.toString() : null;
            }
            IDeviceID currentDeviceId = IDeviceID.Factory.DEFAULT_FACTORY.create(deviceIdSegments);
            this.deviceIDs[rowIdx] = rowIdx > 0 && currentDeviceId.equals(this.deviceIDs[rowIdx - 1]) ? this.deviceIDs[rowIdx - 1] : currentDeviceId;
        }
        return this.deviceIDs[rowIdx];
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitRelationalInsertTablet(this, context);
    }

    @Override
    protected InsertTabletNode getEmptySplit(int count) {
        long[] subTimes = new long[count];
        Object[] values = this.initTabletValues(this.dataTypes.length, count, this.dataTypes);
        BitMap[] newBitMaps = this.bitMaps == null ? null : this.initBitmaps(this.dataTypes.length, count);
        RelationalInsertTabletNode split = new RelationalInsertTabletNode(this.getPlanNodeId(), this.targetPath, this.isAligned, this.measurements, this.dataTypes, this.measurementSchemas, subTimes, newBitMaps, values, subTimes.length, this.columnCategories);
        if (this.singleDevice) {
            split.setSingleDevice();
        }
        return split;
    }

    @Override
    protected Map<TRegionReplicaSet, List<Integer>> splitByReplicaSet(Map<IDeviceID, InsertTabletNode.PartitionSplitInfo> deviceIDSplitInfoMap, IAnalysis analysis) {
        HashMap<TRegionReplicaSet, List<Integer>> splitMap = new HashMap<TRegionReplicaSet, List<Integer>>();
        HashMap<IDeviceID, TEndPoint> endPointMap = new HashMap<IDeviceID, TEndPoint>();
        for (Map.Entry<IDeviceID, InsertTabletNode.PartitionSplitInfo> entry : deviceIDSplitInfoMap.entrySet()) {
            List replicaSets;
            IDeviceID deviceID = entry.getKey();
            InsertTabletNode.PartitionSplitInfo splitInfo = entry.getValue();
            splitInfo.replicaSets = replicaSets = analysis.getDataPartitionInfo().getDataRegionReplicaSetForWriting(deviceID, splitInfo.timePartitionSlots, analysis.getDatabaseName());
            endPointMap.put(deviceID, ((TDataNodeLocation)((TRegionReplicaSet)replicaSets.get(replicaSets.size() - 1)).getDataNodeLocations().get(0)).getClientRpcEndPoint());
            for (int i = 0; i < replicaSets.size(); ++i) {
                List subRanges = splitMap.computeIfAbsent((TRegionReplicaSet)replicaSets.get(i), x -> new ArrayList());
                subRanges.add(splitInfo.ranges.get(2 * i));
                subRanges.add(splitInfo.ranges.get(2 * i + 1));
            }
        }
        ArrayList<TEndPoint> redirectNodeList = new ArrayList<TEndPoint>(this.times.length);
        for (int i = 0; i < this.times.length; ++i) {
            IDeviceID deviceId = this.getDeviceID(i);
            redirectNodeList.add((TEndPoint)endPointMap.get(deviceId));
        }
        analysis.setRedirectNodeList(redirectNodeList);
        return splitMap;
    }

    public static RelationalInsertTabletNode deserialize(ByteBuffer byteBuffer) {
        RelationalInsertTabletNode insertNode = new RelationalInsertTabletNode(new PlanNodeId(""));
        insertNode.subDeserialize(byteBuffer);
        insertNode.setPlanNodeId(PlanNodeId.deserialize(byteBuffer));
        return insertNode;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        super.serializeAttributes(byteBuffer);
        for (int i = 0; i < this.measurements.length; ++i) {
            if (this.measurements[i] == null) continue;
            this.columnCategories[i].serialize(byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        super.serializeAttributes(stream);
        for (int i = 0; i < this.measurements.length; ++i) {
            if (this.measurements[i] == null) continue;
            this.columnCategories[i].serialize((OutputStream)stream);
        }
    }

    @Override
    public void subDeserialize(ByteBuffer buffer) {
        super.subDeserialize(buffer);
        TsTableColumnCategory[] columnCategories = new TsTableColumnCategory[this.measurements.length];
        for (int i = 0; i < this.measurements.length; ++i) {
            columnCategories[i] = TsTableColumnCategory.deserialize((ByteBuffer)buffer);
        }
        this.setColumnCategories(columnCategories);
    }

    @Override
    void subSerialize(IWALByteBufferView buffer, List<int[]> rangeList) {
        super.subSerialize(buffer, rangeList);
        for (int i = 0; i < this.measurements.length; ++i) {
            if (this.measurements[i] == null) continue;
            buffer.put(this.columnCategories[i].getCategory());
        }
    }

    @Override
    protected void subDeserializeFromWAL(ByteBuffer buffer) {
        super.subDeserializeFromWAL(buffer);
        TsTableColumnCategory[] columnCategories = new TsTableColumnCategory[this.measurements.length];
        for (int i = 0; i < this.measurements.length; ++i) {
            columnCategories[i] = TsTableColumnCategory.deserialize((ByteBuffer)buffer);
        }
        this.setColumnCategories(columnCategories);
    }

    @Override
    protected void subDeserializeFromWAL(DataInputStream stream) throws IOException {
        super.subDeserializeFromWAL(stream);
        TsTableColumnCategory[] columnCategories = new TsTableColumnCategory[this.measurements.length];
        for (int i = 0; i < this.measurements.length; ++i) {
            columnCategories[i] = TsTableColumnCategory.deserialize((InputStream)stream);
        }
        this.setColumnCategories(columnCategories);
    }

    public static RelationalInsertTabletNode deserializeFromWAL(DataInputStream stream) throws IOException {
        RelationalInsertTabletNode insertNode = new RelationalInsertTabletNode(new PlanNodeId(""));
        insertNode.subDeserializeFromWAL(stream);
        return insertNode;
    }

    public static RelationalInsertTabletNode deserializeFromWAL(ByteBuffer buffer) {
        RelationalInsertTabletNode insertNode = new RelationalInsertTabletNode(new PlanNodeId(""));
        insertNode.subDeserializeFromWAL(buffer);
        return insertNode;
    }

    @Override
    int subSerializeSize(int start, int end) {
        return super.subSerializeSize(start, end) + this.columnCategories.length * 1;
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.RELATIONAL_INSERT_TABLET;
    }

    @Override
    public List<Pair<IDeviceID, Integer>> splitByDevice(int start, int end) {
        ArrayList<Pair<IDeviceID, Integer>> result = new ArrayList<Pair<IDeviceID, Integer>>();
        IDeviceID prevDeviceId = this.getDeviceID(start);
        for (int i = start + 1; i < end; ++i) {
            IDeviceID currentDeviceId = this.getDeviceID(i);
            if (currentDeviceId.equals(prevDeviceId)) continue;
            result.add((Pair<IDeviceID, Integer>)new Pair((Object)prevDeviceId, (Object)i));
            prevDeviceId = this.getDeviceID(i);
        }
        result.add(new Pair((Object)prevDeviceId, (Object)end));
        return result;
    }

    @Override
    public int checkTTL(TSStatus[] results, long ttl) throws OutOfTTLException {
        return this.checkTTLInternal(results, ttl, false);
    }

    @Override
    public String getTableName() {
        return this.targetPath.getFullPath();
    }

    @Override
    protected PartialPath readTargetPath(ByteBuffer buffer) {
        return new PartialPath(ReadWriteIOUtils.readString((ByteBuffer)buffer), false);
    }

    @Override
    protected PartialPath readTargetPath(DataInputStream stream) throws IOException {
        return new PartialPath(ReadWriteIOUtils.readString((InputStream)stream), false);
    }

    @Override
    public void updateLastCache(String databaseName) {
        String[] rawMeasurements = this.getRawMeasurements();
        List<Pair<IDeviceID, Integer>> deviceEndOffsetPairs = this.splitByDevice(0, this.rowCount);
        int startOffset = 0;
        for (Pair<IDeviceID, Integer> deviceEndOffsetPair : deviceEndOffsetPairs) {
            IDeviceID deviceID = (IDeviceID)deviceEndOffsetPair.getLeft();
            int endOffset = (Integer)deviceEndOffsetPair.getRight();
            TimeValuePair[] timeValuePairs = new TimeValuePair[rawMeasurements.length];
            for (int i = 0; i < rawMeasurements.length; ++i) {
                timeValuePairs[i] = this.composeLastTimeValuePair(i, startOffset, endOffset);
            }
            TableDeviceSchemaCache.getInstance().updateLastCacheIfExists(databaseName, deviceID, rawMeasurements, timeValuePairs);
            startOffset = endOffset;
        }
    }
}

