/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionSourceFileDeletedException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionTaskMetadataInfo;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.FileInfo;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.MetadataIndexNode;
import org.apache.tsfile.file.metadata.statistics.BinaryStatistics;
import org.apache.tsfile.file.metadata.statistics.StringStatistics;
import org.apache.tsfile.read.TsFileDeviceIterator;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionEstimateUtils {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");

    static FileInfo calculateFileInfo(TsFileSequenceReader reader) throws IOException {
        int totalChunkNum = 0;
        int maxChunkNum = 0;
        int maxAlignedSeriesNumInDevice = -1;
        int maxDeviceChunkNum = 0;
        long maxMemCostToReadAlignedSeriesMetadata = 0L;
        long maxMemCostToReadNonAlignedSeriesMetadata = 0L;
        TsFileDeviceIterator deviceIterator = reader.getAllDevicesIteratorWithIsAligned();
        long totalMetadataSize = 0L;
        while (deviceIterator.hasNext()) {
            int deviceChunkNum = 0;
            int alignedSeriesNumInDevice = 0;
            Pair deviceWithIsAlignedPair = deviceIterator.next();
            IDeviceID device = (IDeviceID)deviceWithIsAlignedPair.left;
            boolean isAlignedDevice = (Boolean)deviceWithIsAlignedPair.right;
            long memCostToReadMetadata = 0L;
            Iterator measurementChunkMetadataListMapIterator = reader.getMeasurementChunkMetadataListMapIterator(device);
            while (measurementChunkMetadataListMapIterator.hasNext()) {
                Map measurementChunkMetadataListMap = (Map)measurementChunkMetadataListMapIterator.next();
                if (isAlignedDevice) {
                    alignedSeriesNumInDevice += measurementChunkMetadataListMap.size();
                }
                for (Map.Entry measurementChunkMetadataList : measurementChunkMetadataListMap.entrySet()) {
                    int currentChunkMetadataListSize = ((List)measurementChunkMetadataList.getValue()).size();
                    long measurementNameRamSize = RamUsageEstimator.sizeOf((String)((String)measurementChunkMetadataList.getKey()));
                    long chunkMetadataMemCost = 0L;
                    long currentSeriesRamSize = measurementNameRamSize;
                    for (ChunkMetadata chunkMetadata : (List)measurementChunkMetadataList.getValue()) {
                        if (chunkMetadata != null) {
                            TSDataType dataType = chunkMetadata.getDataType();
                            long l = chunkMetadataMemCost = chunkMetadataMemCost != 0L ? chunkMetadataMemCost : ChunkMetadata.calculateRamSize((String)chunkMetadata.getMeasurementUid(), (TSDataType)dataType) - measurementNameRamSize;
                            if (dataType == TSDataType.TEXT) {
                                currentSeriesRamSize += chunkMetadata.getStatistics().getRetainedSizeInBytes() - BinaryStatistics.INSTANCE_SIZE;
                                continue;
                            }
                            if (dataType != TSDataType.STRING) break;
                            currentSeriesRamSize += chunkMetadata.getStatistics().getRetainedSizeInBytes() - StringStatistics.INSTANCE_SIZE;
                            continue;
                        }
                        LOGGER.warn("{} has null chunk metadata, file is {}", (Object)(device.toString() + "." + (String)measurementChunkMetadataList.getKey()), (Object)reader.getFileName());
                    }
                    currentSeriesRamSize += chunkMetadataMemCost * (long)currentChunkMetadataListSize;
                    if (isAlignedDevice) {
                        memCostToReadMetadata += currentSeriesRamSize;
                    } else {
                        maxMemCostToReadNonAlignedSeriesMetadata = Math.max(maxMemCostToReadNonAlignedSeriesMetadata, currentSeriesRamSize);
                    }
                    deviceChunkNum += currentChunkMetadataListSize;
                    totalChunkNum += currentChunkMetadataListSize;
                    maxChunkNum = Math.max(maxChunkNum, currentChunkMetadataListSize);
                    totalMetadataSize += currentSeriesRamSize;
                }
            }
            if (isAlignedDevice) {
                maxAlignedSeriesNumInDevice = Math.max(maxAlignedSeriesNumInDevice, alignedSeriesNumInDevice);
            }
            maxDeviceChunkNum = Math.max(maxDeviceChunkNum, deviceChunkNum);
            maxMemCostToReadAlignedSeriesMetadata = Math.max(maxMemCostToReadAlignedSeriesMetadata, memCostToReadMetadata);
        }
        long averageChunkMetadataSize = totalChunkNum == 0 ? 0L : totalMetadataSize / (long)totalChunkNum;
        return new FileInfo(totalChunkNum, maxChunkNum, maxAlignedSeriesNumInDevice, maxDeviceChunkNum, averageChunkMetadataSize, maxMemCostToReadAlignedSeriesMetadata, maxMemCostToReadNonAlignedSeriesMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CompactionTaskMetadataInfo collectMetadataInfoFromDisk(List<TsFileResource> resources, CompactionType taskType) throws IOException {
        CompactionEstimateUtils.addReadLock(resources);
        CompactionTaskMetadataInfo metadataInfo = new CompactionTaskMetadataInfo();
        long cost = 0L;
        HashMap<IDeviceID, Long> deviceMetadataSizeMap = new HashMap<IDeviceID, Long>();
        try {
            for (TsFileResource resource : resources) {
                if (resource.modFileExists()) {
                    cost += resource.getModFile().getSize();
                }
                try (CompactionTsFileReader reader = new CompactionTsFileReader(resource.getTsFilePath(), taskType);){
                    for (Map.Entry<IDeviceID, Long> entry : CompactionEstimateUtils.getDeviceMetadataSizeMapAndCollectMetadataInfo(reader, metadataInfo).entrySet()) {
                        deviceMetadataSizeMap.merge(entry.getKey(), entry.getValue(), Long::sum);
                    }
                }
            }
            metadataInfo.metadataMemCost = cost + deviceMetadataSizeMap.values().stream().max(Long::compareTo).orElse(0L);
            CompactionTaskMetadataInfo compactionTaskMetadataInfo = metadataInfo;
            return compactionTaskMetadataInfo;
        }
        finally {
            CompactionEstimateUtils.releaseReadLock(resources);
        }
    }

    static CompactionTaskMetadataInfo collectMetadataInfoFromCachedFileInfo(List<TsFileResource> resources, Map<TsFileResource, FileInfo.RoughFileInfo> cachedFileInfo, boolean hasConcurrentSubTask) {
        CompactionTaskMetadataInfo metadataInfo = new CompactionTaskMetadataInfo();
        for (TsFileResource resource : resources) {
            metadataInfo.metadataMemCost += resource.getModFile().getSize();
            long maxMemToReadAlignedSeries = cachedFileInfo.get((Object)resource).maxMemToReadAlignedSeries;
            long maxMemToReadNonAlignedSeries = cachedFileInfo.get((Object)resource).maxMemToReadNonAlignedSeries;
            metadataInfo.metadataMemCost = metadataInfo.metadataMemCost + Math.max(maxMemToReadAlignedSeries, maxMemToReadNonAlignedSeries * (long)(hasConcurrentSubTask ? IoTDBDescriptor.getInstance().getConfig().getSubCompactionTaskNum() : 1));
            if (maxMemToReadAlignedSeries <= 0L) continue;
            metadataInfo.hasAlignedSeries = true;
        }
        return metadataInfo;
    }

    static Map<IDeviceID, Long> getDeviceMetadataSizeMapAndCollectMetadataInfo(CompactionTsFileReader reader, CompactionTaskMetadataInfo metadataInfo) throws IOException {
        HashMap<IDeviceID, Long> deviceMetadataSizeMap = new HashMap<IDeviceID, Long>();
        TsFileDeviceIterator deviceIterator = reader.getAllDevicesIteratorWithIsAligned();
        while (deviceIterator.hasNext()) {
            Pair deviceAlignedPair = deviceIterator.next();
            IDeviceID deviceID = (IDeviceID)deviceAlignedPair.getLeft();
            boolean isAligned = (Boolean)deviceAlignedPair.getRight();
            metadataInfo.hasAlignedSeries |= isAligned;
            MetadataIndexNode firstMeasurementNodeOfCurrentDevice = deviceIterator.getFirstMeasurementNodeOfCurrentDevice();
            long totalTimeseriesMetadataSizeOfCurrentDevice = 0L;
            Map<String, Pair<Long, Long>> timeseriesMetadataOffsetByDevice = reader.getTimeseriesMetadataOffsetByDevice(firstMeasurementNodeOfCurrentDevice);
            for (Pair<Long, Long> offsetPair : timeseriesMetadataOffsetByDevice.values()) {
                totalTimeseriesMetadataSizeOfCurrentDevice += (Long)offsetPair.right - (Long)offsetPair.left;
            }
            deviceMetadataSizeMap.put(deviceID, totalTimeseriesMetadataSizeOfCurrentDevice);
        }
        return deviceMetadataSizeMap;
    }

    public static boolean shouldUseRoughEstimatedResult(long roughEstimatedMemCost) {
        return roughEstimatedMemCost > 0L && (long)IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount() * roughEstimatedMemCost < SystemInfo.getInstance().getMemorySizeForCompaction();
    }

    public static void addReadLock(List<TsFileResource> resources) throws CompactionSourceFileDeletedException {
        for (int i = 0; i < resources.size(); ++i) {
            TsFileResource resource = resources.get(i);
            resource.readLock();
            if (!resource.isDeleted()) continue;
            for (int j = 0; j <= i; ++j) {
                resources.get(j).readUnlock();
            }
            throw new CompactionSourceFileDeletedException("source file " + resource.getTsFilePath() + " is deleted");
        }
    }

    public static void releaseReadLock(List<TsFileResource> resources) {
        resources.forEach(TsFileResource::readUnlock);
    }
}

