/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.subscription.consumer;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerGroupMeta;
import org.apache.iotdb.confignode.consensus.request.write.subscription.consumer.AlterConsumerGroupPlan;
import org.apache.iotdb.confignode.persistence.subscription.SubscriptionInfo;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.subscription.AbstractOperateSubscriptionProcedure;
import org.apache.iotdb.confignode.procedure.impl.subscription.SubscriptionOperation;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterConsumerGroupProcedure
extends AbstractOperateSubscriptionProcedure {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AlterConsumerGroupProcedure.class);
    protected ConsumerGroupMeta existingConsumerGroupMeta;
    protected ConsumerGroupMeta updatedConsumerGroupMeta;

    public AlterConsumerGroupProcedure() {
    }

    public AlterConsumerGroupProcedure(ConsumerGroupMeta updatedConsumerGroupMeta) {
        this.updatedConsumerGroupMeta = updatedConsumerGroupMeta;
    }

    public AlterConsumerGroupProcedure(ConsumerGroupMeta updatedConsumerGroupMeta, AtomicReference<SubscriptionInfo> subscriptionInfo) {
        this.updatedConsumerGroupMeta = updatedConsumerGroupMeta;
        this.subscriptionInfo = subscriptionInfo;
    }

    @Override
    protected SubscriptionOperation getOperation() {
        return SubscriptionOperation.ALTER_CONSUMER_GROUP;
    }

    @Override
    public boolean executeFromValidate(ConfigNodeProcedureEnv env) throws SubscriptionException {
        LOGGER.info("AlterConsumerGroupProcedure: executeFromValidate, try to validate");
        this.validateAndGetOldAndNewMeta(env);
        return true;
    }

    protected void validateAndGetOldAndNewMeta(ConfigNodeProcedureEnv env) {
        ((SubscriptionInfo)this.subscriptionInfo.get()).validateBeforeAlterConsumerGroup(this.updatedConsumerGroupMeta);
        this.existingConsumerGroupMeta = ((SubscriptionInfo)this.subscriptionInfo.get()).getConsumerGroupMeta(this.updatedConsumerGroupMeta.getConsumerGroupId());
    }

    @Override
    public void executeFromOperateOnConfigNodes(ConfigNodeProcedureEnv env) throws SubscriptionException {
        TSStatus response;
        LOGGER.info("AlterConsumerGroupProcedure: executeFromOperateOnConfigNodes({})", (Object)this.updatedConsumerGroupMeta.getConsumerGroupId());
        try {
            response = env.getConfigManager().getConsensusManager().write(new AlterConsumerGroupPlan(this.updatedConsumerGroupMeta));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            response = new TSStatus(TSStatusCode.ALTER_CONSUMER_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
        if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new SubscriptionException(String.format("Failed to alter consumer group %s on config nodes, because %s", this.updatedConsumerGroupMeta.getConsumerGroupId(), response));
        }
    }

    @Override
    public void executeFromOperateOnDataNodes(ConfigNodeProcedureEnv env) throws SubscriptionException, IOException {
        LOGGER.info("AlterConsumerGroupProcedure: executeFromOperateOnDataNodes({})", (Object)this.updatedConsumerGroupMeta.getConsumerGroupId());
        List<TSStatus> statuses = env.pushSingleConsumerGroupOnDataNode(this.updatedConsumerGroupMeta.serialize());
        if (RpcUtils.squashResponseStatusList(statuses).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new SubscriptionException(String.format("Failed to alter consumer group (%s -> %s) on data nodes, because %s", this.existingConsumerGroupMeta, this.updatedConsumerGroupMeta, statuses));
        }
    }

    @Override
    public void rollbackFromValidate(ConfigNodeProcedureEnv env) {
        LOGGER.info("AlterConsumerGroupProcedure: rollbackFromValidate");
    }

    @Override
    public void rollbackFromOperateOnConfigNodes(ConfigNodeProcedureEnv env) throws SubscriptionException {
        TSStatus response;
        LOGGER.info("AlterConsumerGroupProcedure: rollbackFromOperateOnConfigNodes({})", (Object)this.updatedConsumerGroupMeta.getConsumerGroupId());
        try {
            response = env.getConfigManager().getConsensusManager().write(new AlterConsumerGroupPlan(this.existingConsumerGroupMeta));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            response = new TSStatus(TSStatusCode.ALTER_CONSUMER_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
        if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new SubscriptionException(String.format("Failed to rollback from altering consumer group (%s -> %s) on config nodes, because %s", this.existingConsumerGroupMeta, this.updatedConsumerGroupMeta, response));
        }
    }

    @Override
    public void rollbackFromOperateOnDataNodes(ConfigNodeProcedureEnv env) throws SubscriptionException, IOException {
        LOGGER.info("AlterConsumerGroupProcedure: rollbackFromOperateOnDataNodes");
        List<TSStatus> statuses = env.pushSingleConsumerGroupOnDataNode(this.existingConsumerGroupMeta.serialize());
        if (RpcUtils.squashResponseStatusList(statuses).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new SubscriptionException(String.format("Failed to rollback from altering consumer group (%s -> %s) on data nodes, because %s", this.existingConsumerGroupMeta, this.updatedConsumerGroupMeta, statuses));
        }
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.ALTER_CONSUMER_GROUP_PROCEDURE.getTypeCode());
        super.serialize(stream);
        if (this.updatedConsumerGroupMeta != null) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            this.updatedConsumerGroupMeta.serialize((OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
        if (this.existingConsumerGroupMeta != null) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            this.existingConsumerGroupMeta.serialize((OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
            this.updatedConsumerGroupMeta = ConsumerGroupMeta.deserialize((ByteBuffer)byteBuffer);
        }
        if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
            this.existingConsumerGroupMeta = ConsumerGroupMeta.deserialize((ByteBuffer)byteBuffer);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlterConsumerGroupProcedure that = (AlterConsumerGroupProcedure)o;
        return Objects.equals(this.getProcId(), that.getProcId()) && Objects.equals(this.getCurrentState(), that.getCurrentState()) && this.getCycles() == that.getCycles() && Objects.equals(this.updatedConsumerGroupMeta, that.updatedConsumerGroupMeta) && Objects.equals(this.existingConsumerGroupMeta, that.existingConsumerGroupMeta);
    }

    public int hashCode() {
        return Objects.hash(this.getProcId(), this.getCurrentState(), this.getCycles(), this.updatedConsumerGroupMeta, this.existingConsumerGroupMeta);
    }

    public void setExistingConsumerGroupMeta(ConsumerGroupMeta meta) {
        this.existingConsumerGroupMeta = meta;
    }

    public ConsumerGroupMeta getExistingConsumerGroupMeta() {
        return this.existingConsumerGroupMeta;
    }

    public void setUpdatedConsumerGroupMeta(ConsumerGroupMeta meta) {
        this.updatedConsumerGroupMeta = meta;
    }

    public ConsumerGroupMeta getUpdatedConsumerGroupMeta() {
        return this.updatedConsumerGroupMeta;
    }
}

