/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.service;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.cluster.rpc.thrift.AppendEntriesRequest;
import org.apache.iotdb.cluster.rpc.thrift.AppendEntryRequest;
import org.apache.iotdb.cluster.rpc.thrift.ElectionRequest;
import org.apache.iotdb.cluster.rpc.thrift.ExecutNonQueryReq;
import org.apache.iotdb.cluster.rpc.thrift.GetAggrResultRequest;
import org.apache.iotdb.cluster.rpc.thrift.GetAllPathsResult;
import org.apache.iotdb.cluster.rpc.thrift.GroupByRequest;
import org.apache.iotdb.cluster.rpc.thrift.HeartBeatRequest;
import org.apache.iotdb.cluster.rpc.thrift.HeartBeatResponse;
import org.apache.iotdb.cluster.rpc.thrift.LastQueryRequest;
import org.apache.iotdb.cluster.rpc.thrift.MeasurementSchemaRequest;
import org.apache.iotdb.cluster.rpc.thrift.MultSeriesQueryRequest;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.PreviousFillRequest;
import org.apache.iotdb.cluster.rpc.thrift.PullSchemaRequest;
import org.apache.iotdb.cluster.rpc.thrift.PullSchemaResp;
import org.apache.iotdb.cluster.rpc.thrift.PullSnapshotRequest;
import org.apache.iotdb.cluster.rpc.thrift.PullSnapshotResp;
import org.apache.iotdb.cluster.rpc.thrift.RaftNode;
import org.apache.iotdb.cluster.rpc.thrift.RequestCommitIndexResponse;
import org.apache.iotdb.cluster.rpc.thrift.SendSnapshotRequest;
import org.apache.iotdb.cluster.rpc.thrift.SingleSeriesQueryRequest;
import org.apache.iotdb.cluster.rpc.thrift.TSDataService;
import org.apache.iotdb.cluster.server.service.DataAsyncService;
import org.apache.iotdb.cluster.server.service.DataGroupEngine;
import org.apache.iotdb.cluster.utils.IOUtils;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;

public class DataGroupServiceImpls
implements TSDataService.AsyncIface,
TSDataService.Iface {
    public void sendHeartbeat(HeartBeatRequest request, AsyncMethodCallback<HeartBeatResponse> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(request.getHeader(), resultHandler, request);
        if (service != null) {
            service.sendHeartbeat(request, resultHandler);
        }
    }

    public void startElection(ElectionRequest request, AsyncMethodCallback<Long> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(request.getHeader(), resultHandler, request);
        if (service != null) {
            service.startElection(request, resultHandler);
        }
    }

    public void appendEntries(AppendEntriesRequest request, AsyncMethodCallback<Long> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(request.getHeader(), resultHandler, request);
        if (service != null) {
            service.appendEntries(request, resultHandler);
        }
    }

    public void appendEntry(AppendEntryRequest request, AsyncMethodCallback<Long> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(request.getHeader(), resultHandler, request);
        if (service != null) {
            service.appendEntry(request, resultHandler);
        }
    }

    public void sendSnapshot(SendSnapshotRequest request, AsyncMethodCallback<Void> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(request.getHeader(), resultHandler, request);
        if (service != null) {
            service.sendSnapshot(request, resultHandler);
        }
    }

    public void pullSnapshot(PullSnapshotRequest request, AsyncMethodCallback<PullSnapshotResp> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(request.getHeader(), resultHandler, request);
        if (service != null) {
            service.pullSnapshot(request, resultHandler);
        }
    }

    public void executeNonQueryPlan(ExecutNonQueryReq request, AsyncMethodCallback<TSStatus> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(request.getHeader(), resultHandler, request);
        if (service != null) {
            service.executeNonQueryPlan(request, resultHandler);
        }
    }

    public void requestCommitIndex(RaftNode header, AsyncMethodCallback<RequestCommitIndexResponse> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(header, resultHandler, "Request commit index");
        if (service != null) {
            service.requestCommitIndex(header, resultHandler);
        }
    }

    public void readFile(String filePath, long offset, int length, AsyncMethodCallback<ByteBuffer> resultHandler) {
        try {
            resultHandler.onComplete((Object)IOUtils.readFile(filePath, offset, length));
        }
        catch (IOException e) {
            resultHandler.onError((Exception)e);
        }
    }

    public void querySingleSeries(SingleSeriesQueryRequest request, AsyncMethodCallback<Long> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(request.getHeader(), resultHandler, "Query series:" + request.getPath());
        if (service != null) {
            service.querySingleSeries(request, resultHandler);
        }
    }

    public void queryMultSeries(MultSeriesQueryRequest request, AsyncMethodCallback<Long> resultHandler) throws TException {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(request.getHeader(), resultHandler, "Query series:" + request.getPath());
        if (service != null) {
            service.queryMultSeries(request, resultHandler);
        }
    }

    public void fetchSingleSeries(RaftNode header, long readerId, AsyncMethodCallback<ByteBuffer> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(header, resultHandler, "Fetch reader:" + readerId);
        if (service != null) {
            service.fetchSingleSeries(header, readerId, resultHandler);
        }
    }

    public void fetchMultSeries(RaftNode header, long readerId, List<String> paths, AsyncMethodCallback<Map<String, ByteBuffer>> resultHandler) throws TException {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(header, resultHandler, "Fetch reader:" + readerId);
        if (service != null) {
            service.fetchMultSeries(header, readerId, paths, resultHandler);
        }
    }

    public void getAllPaths(RaftNode header, List<String> paths, boolean withAlias, AsyncMethodCallback<GetAllPathsResult> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(header, resultHandler, "Find path:" + paths);
        if (service != null) {
            service.getAllPaths(header, paths, withAlias, resultHandler);
        }
    }

    public void endQuery(RaftNode header, Node thisNode, long queryId, AsyncMethodCallback<Void> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(header, resultHandler, "End query");
        if (service != null) {
            service.endQuery(header, thisNode, queryId, resultHandler);
        }
    }

    public void querySingleSeriesByTimestamp(SingleSeriesQueryRequest request, AsyncMethodCallback<Long> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(request.getHeader(), resultHandler, "Query by timestamp:" + request.getQueryId() + "#" + request.getPath() + " of " + request.getRequester());
        if (service != null) {
            service.querySingleSeriesByTimestamp(request, resultHandler);
        }
    }

    public void fetchSingleSeriesByTimestamps(RaftNode header, long readerId, List<Long> timestamps, AsyncMethodCallback<ByteBuffer> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(header, resultHandler, "Fetch by timestamp:" + readerId);
        if (service != null) {
            service.fetchSingleSeriesByTimestamps(header, readerId, timestamps, resultHandler);
        }
    }

    public void pullTimeSeriesSchema(PullSchemaRequest request, AsyncMethodCallback<PullSchemaResp> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(request.getHeader(), resultHandler, request);
        if (service != null) {
            service.pullTimeSeriesSchema(request, resultHandler);
        }
    }

    public void pullMeasurementSchema(PullSchemaRequest request, AsyncMethodCallback<PullSchemaResp> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(request.getHeader(), resultHandler, "Pull measurement schema");
        if (service != null) {
            service.pullMeasurementSchema(request, resultHandler);
        }
    }

    public void getAllDevices(RaftNode header, List<String> paths, boolean isPrefixMatch, AsyncMethodCallback<Set<String>> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(header, resultHandler, "Get all devices");
        if (service != null) {
            service.getAllDevices(header, paths, isPrefixMatch, resultHandler);
        }
    }

    public void getDevices(RaftNode header, ByteBuffer planBinary, AsyncMethodCallback<ByteBuffer> resultHandler) throws TException {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(header, resultHandler, "get devices");
        if (service != null) {
            service.getDevices(header, planBinary, resultHandler);
        }
    }

    public void getNodeList(RaftNode header, String path, int nodeLevel, AsyncMethodCallback<List<String>> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(header, resultHandler, "Get node list");
        if (service != null) {
            service.getNodeList(header, path, nodeLevel, resultHandler);
        }
    }

    public void getChildNodeInNextLevel(RaftNode header, String path, AsyncMethodCallback<Set<String>> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(header, resultHandler, "Get child node in next level");
        if (service != null) {
            service.getChildNodeInNextLevel(header, path, resultHandler);
        }
    }

    public void getChildNodePathInNextLevel(RaftNode header, String path, AsyncMethodCallback<Set<String>> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(header, resultHandler, "Get child node path in next level");
        if (service != null) {
            service.getChildNodePathInNextLevel(header, path, resultHandler);
        }
    }

    public void getAllMeasurementSchema(MeasurementSchemaRequest request, AsyncMethodCallback<ByteBuffer> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(request.getHeader(), resultHandler, "Get all measurement schema");
        if (service != null) {
            service.getAllMeasurementSchema(request, resultHandler);
        }
    }

    public void getAggrResult(GetAggrResultRequest request, AsyncMethodCallback<List<ByteBuffer>> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(request.getHeader(), resultHandler, request);
        if (service != null) {
            service.getAggrResult(request, resultHandler);
        }
    }

    public void getUnregisteredTimeseries(RaftNode header, List<String> timeseriesList, AsyncMethodCallback<List<String>> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(header, resultHandler, "Check if measurements are registered");
        if (service != null) {
            service.getUnregisteredTimeseries(header, timeseriesList, resultHandler);
        }
    }

    public void getGroupByExecutor(GroupByRequest request, AsyncMethodCallback<Long> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(request.getHeader(), resultHandler, request);
        if (service != null) {
            service.getGroupByExecutor(request, resultHandler);
        }
    }

    public void getGroupByResult(RaftNode header, long executorId, long startTime, long endTime, AsyncMethodCallback<List<ByteBuffer>> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(header, resultHandler, "Fetch group by");
        if (service != null) {
            service.getGroupByResult(header, executorId, startTime, endTime, resultHandler);
        }
    }

    public void previousFill(PreviousFillRequest request, AsyncMethodCallback<ByteBuffer> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(request.getHeader(), resultHandler, request);
        if (service != null) {
            service.previousFill(request, resultHandler);
        }
    }

    public void matchTerm(long index, long term, RaftNode header, AsyncMethodCallback<Boolean> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(header, resultHandler, "Match term");
        if (service != null) {
            service.matchTerm(index, term, header, resultHandler);
        }
    }

    public void last(LastQueryRequest request, AsyncMethodCallback<ByteBuffer> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(request.getHeader(), resultHandler, "last");
        if (service != null) {
            service.last(request, resultHandler);
        }
    }

    public void getPathCount(RaftNode header, List<String> pathsToQuery, int level, AsyncMethodCallback<Integer> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(header, resultHandler, "count path");
        if (service != null) {
            service.getPathCount(header, pathsToQuery, level, resultHandler);
        }
    }

    public void getDeviceCount(RaftNode header, List<String> pathsToQuery, AsyncMethodCallback<Integer> resultHandler) throws TException {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(header, resultHandler, "count device");
        if (service != null) {
            service.getDeviceCount(header, pathsToQuery, resultHandler);
        }
    }

    public void onSnapshotApplied(RaftNode header, List<Integer> slots, AsyncMethodCallback<Boolean> resultHandler) {
        DataAsyncService service = DataGroupEngine.getInstance().getDataAsyncService(header, resultHandler, "Snapshot applied");
        if (service != null) {
            service.onSnapshotApplied(header, slots, resultHandler);
        }
    }

    public long querySingleSeries(SingleSeriesQueryRequest request) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(request.getHeader()).querySingleSeries(request);
    }

    public long queryMultSeries(MultSeriesQueryRequest request) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(request.getHeader()).queryMultSeries(request);
    }

    public ByteBuffer fetchSingleSeries(RaftNode header, long readerId) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(header).fetchSingleSeries(header, readerId);
    }

    public Map<String, ByteBuffer> fetchMultSeries(RaftNode header, long readerId, List<String> paths) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(header).fetchMultSeries(header, readerId, paths);
    }

    public long querySingleSeriesByTimestamp(SingleSeriesQueryRequest request) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(request.getHeader()).querySingleSeriesByTimestamp(request);
    }

    public ByteBuffer fetchSingleSeriesByTimestamps(RaftNode header, long readerId, List<Long> timestamps) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(header).fetchSingleSeriesByTimestamps(header, readerId, timestamps);
    }

    public void endQuery(RaftNode header, Node thisNode, long queryId) throws TException {
        DataGroupEngine.getInstance().getDataSyncService(header).endQuery(header, thisNode, queryId);
    }

    public GetAllPathsResult getAllPaths(RaftNode header, List<String> path, boolean withAlias) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(header).getAllPaths(header, path, withAlias);
    }

    public Set<String> getAllDevices(RaftNode header, List<String> path, boolean isPrefixMatch) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(header).getAllDevices(header, path, isPrefixMatch);
    }

    public List<String> getNodeList(RaftNode header, String path, int nodeLevel) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(header).getNodeList(header, path, nodeLevel);
    }

    public Set<String> getChildNodeInNextLevel(RaftNode header, String path) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(header).getChildNodeInNextLevel(header, path);
    }

    public Set<String> getChildNodePathInNextLevel(RaftNode header, String path) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(header).getChildNodePathInNextLevel(header, path);
    }

    public ByteBuffer getAllMeasurementSchema(MeasurementSchemaRequest request) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(request.getHeader()).getAllMeasurementSchema(request);
    }

    public ByteBuffer getDevices(RaftNode header, ByteBuffer planBinary) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(header).getDevices(header, planBinary);
    }

    public List<ByteBuffer> getAggrResult(GetAggrResultRequest request) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(request.getHeader()).getAggrResult(request);
    }

    public List<String> getUnregisteredTimeseries(RaftNode header, List<String> timeseriesList) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(header).getUnregisteredTimeseries(header, timeseriesList);
    }

    public PullSnapshotResp pullSnapshot(PullSnapshotRequest request) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(request.getHeader()).pullSnapshot(request);
    }

    public long getGroupByExecutor(GroupByRequest request) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(request.getHeader()).getGroupByExecutor(request);
    }

    public List<ByteBuffer> getGroupByResult(RaftNode header, long executorId, long startTime, long endTime) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(header).getGroupByResult(header, executorId, startTime, endTime);
    }

    public PullSchemaResp pullTimeSeriesSchema(PullSchemaRequest request) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(request.getHeader()).pullTimeSeriesSchema(request);
    }

    public PullSchemaResp pullMeasurementSchema(PullSchemaRequest request) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(request.getHeader()).pullMeasurementSchema(request);
    }

    public ByteBuffer previousFill(PreviousFillRequest request) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(request.getHeader()).previousFill(request);
    }

    public ByteBuffer last(LastQueryRequest request) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(request.getHeader()).last(request);
    }

    public int getPathCount(RaftNode header, List<String> pathsToQuery, int level) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(header).getPathCount(header, pathsToQuery, level);
    }

    public boolean onSnapshotApplied(RaftNode header, List<Integer> slots) {
        return DataGroupEngine.getInstance().getDataSyncService(header).onSnapshotApplied(header, slots);
    }

    public int getDeviceCount(RaftNode header, List<String> pathsToQuery) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(header).getDeviceCount(header, pathsToQuery);
    }

    public HeartBeatResponse sendHeartbeat(HeartBeatRequest request) {
        return DataGroupEngine.getInstance().getDataSyncService(request.getHeader()).sendHeartbeat(request);
    }

    public long startElection(ElectionRequest request) {
        return DataGroupEngine.getInstance().getDataSyncService(request.getHeader()).startElection(request);
    }

    public long appendEntries(AppendEntriesRequest request) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(request.getHeader()).appendEntries(request);
    }

    public long appendEntry(AppendEntryRequest request) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(request.getHeader()).appendEntry(request);
    }

    public void sendSnapshot(SendSnapshotRequest request) throws TException {
        DataGroupEngine.getInstance().getDataSyncService(request.getHeader()).sendSnapshot(request);
    }

    public TSStatus executeNonQueryPlan(ExecutNonQueryReq request) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(request.getHeader()).executeNonQueryPlan(request);
    }

    public RequestCommitIndexResponse requestCommitIndex(RaftNode header) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(header).requestCommitIndex(header);
    }

    public ByteBuffer readFile(String filePath, long offset, int length) throws TException {
        try {
            return IOUtils.readFile(filePath, offset, length);
        }
        catch (IOException e) {
            throw new TException((Throwable)e);
        }
    }

    public boolean matchTerm(long index, long term, RaftNode header) {
        return DataGroupEngine.getInstance().getDataSyncService(header).matchTerm(index, term, header);
    }

    public ByteBuffer peekNextNotNullValue(RaftNode header, long executorId, long startTime, long endTime) throws TException {
        return DataGroupEngine.getInstance().getDataSyncService(header).peekNextNotNullValue(header, executorId, startTime, endTime);
    }

    public void peekNextNotNullValue(RaftNode header, long executorId, long startTime, long endTime, AsyncMethodCallback<ByteBuffer> resultHandler) throws TException {
        resultHandler.onComplete((Object)DataGroupEngine.getInstance().getDataSyncService(header).peekNextNotNullValue(header, executorId, startTime, endTime));
    }

    public void removeHardLink(String hardLinkPath) throws TException {
        try {
            Files.deleteIfExists(new File(hardLinkPath).toPath());
        }
        catch (IOException e) {
            throw new TException((Throwable)e);
        }
    }

    public void removeHardLink(String hardLinkPath, AsyncMethodCallback<Void> resultHandler) {
        try {
            Files.deleteIfExists(new File(hardLinkPath).toPath());
            resultHandler.onComplete(null);
        }
        catch (IOException e) {
            resultHandler.onError((Exception)e);
        }
    }
}

