/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.inner.sizetiered;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.engine.compaction.CompactionUtils;
import org.apache.iotdb.db.engine.compaction.inner.AbstractInnerSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.inner.utils.InnerSpaceCompactionUtils;
import org.apache.iotdb.db.engine.compaction.task.AbstractCompactionTask;
import org.apache.iotdb.db.engine.compaction.task.CompactionExceptionHandler;
import org.apache.iotdb.db.engine.compaction.utils.log.CompactionLogger;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceList;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.tsfile.exception.write.TsFileNotCompleteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SizeTieredCompactionTask
extends AbstractInnerSpaceCompactionTask {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    protected TsFileResourceList tsFileResourceList;
    protected boolean[] isHoldingReadLock;
    protected boolean[] isHoldingWriteLock;

    public SizeTieredCompactionTask(String logicalStorageGroupName, String virtualStorageGroupName, long timePartition, TsFileManager tsFileManager, List<TsFileResource> selectedTsFileResourceList, boolean sequence, AtomicInteger currentTaskNum) {
        super(logicalStorageGroupName + "-" + virtualStorageGroupName, timePartition, currentTaskNum, sequence, selectedTsFileResourceList, tsFileManager);
        this.isHoldingReadLock = new boolean[selectedTsFileResourceList.size()];
        this.isHoldingWriteLock = new boolean[selectedTsFileResourceList.size()];
        for (int i = 0; i < selectedTsFileResourceList.size(); ++i) {
            this.isHoldingWriteLock[i] = false;
            this.isHoldingReadLock[i] = false;
        }
        this.tsFileResourceList = sequence ? tsFileManager.getSequenceListByTimePartition(timePartition) : tsFileManager.getUnsequenceListByTimePartition(timePartition);
    }

    @Override
    protected void doCompaction() throws Exception {
        if (!this.tsFileManager.isAllowCompaction()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        String dataDirectory = ((TsFileResource)this.selectedTsFileResourceList.get(0)).getTsFile().getParent();
        TsFileResource targetTsFileResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(this.selectedTsFileResourceList, this.sequence);
        ArrayList<TsFileResource> targetTsFileList = new ArrayList<TsFileResource>(Collections.singletonList(targetTsFileResource));
        LOGGER.info("{} [Compaction] starting compaction task with {} files", (Object)this.fullStorageGroupName, (Object)this.selectedTsFileResourceList.size());
        File logFile = new File(dataDirectory + File.separator + targetTsFileResource.getTsFile().getName() + ".inner-compaction.log");
        CompactionLogger sizeTieredCompactionLogger = null;
        try {
            sizeTieredCompactionLogger = new CompactionLogger(logFile);
            sizeTieredCompactionLogger.logFiles(this.selectedTsFileResourceList, "source");
            sizeTieredCompactionLogger.logFiles(targetTsFileList, "target");
            LOGGER.info("{} [SizeTiredCompactionTask] Close the logger", (Object)this.fullStorageGroupName);
            sizeTieredCompactionLogger.close();
            LOGGER.info("{} [Compaction] compaction with {}", (Object)this.fullStorageGroupName, (Object)this.selectedTsFileResourceList);
            if (this.sequence) {
                InnerSpaceCompactionUtils.compact(targetTsFileResource, this.selectedTsFileResourceList);
            } else {
                CompactionUtils.compact(Collections.emptyList(), this.selectedTsFileResourceList, targetTsFileList);
            }
            InnerSpaceCompactionUtils.moveTargetFile(targetTsFileResource, this.fullStorageGroupName);
            LOGGER.info("{} [SizeTiredCompactionTask] start to rename mods file", (Object)this.fullStorageGroupName);
            InnerSpaceCompactionUtils.combineModsInCompaction(this.selectedTsFileResourceList, targetTsFileResource);
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException(String.format("%s [Compaction] abort", this.fullStorageGroupName));
            }
            if (this.sequence) {
                this.tsFileManager.replace(this.selectedTsFileResourceList, Collections.emptyList(), targetTsFileList, this.timePartition, true);
            } else {
                this.tsFileManager.replace(Collections.emptyList(), this.selectedTsFileResourceList, targetTsFileList, this.timePartition, false);
            }
            LOGGER.info("{} [Compaction] Compacted target files, try to get the write lock of source files", (Object)this.fullStorageGroupName);
            for (int i = 0; i < this.selectedTsFileResourceList.size(); ++i) {
                ((TsFileResource)this.selectedTsFileResourceList.get(i)).readUnlock();
                this.isHoldingReadLock[i] = false;
                ((TsFileResource)this.selectedTsFileResourceList.get(i)).writeLock();
                this.isHoldingWriteLock[i] = true;
            }
            if (targetTsFileResource.getTsFile().exists() && targetTsFileResource.getTsFile().length() < (long)"TsFile".getBytes().length * 2L + 1L) {
                throw new TsFileNotCompleteException(String.format("target file %s is smaller than magic string and version number size", targetTsFileResource));
            }
            LOGGER.info("{} [Compaction] compaction finish, start to delete old files", (Object)this.fullStorageGroupName);
            InnerSpaceCompactionUtils.deleteTsFilesInDisk(this.selectedTsFileResourceList, this.fullStorageGroupName);
            InnerSpaceCompactionUtils.deleteModificationForSourceFile(this.selectedTsFileResourceList, this.fullStorageGroupName);
            double costTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            LOGGER.info("{} [SizeTiredCompactionTask] all compaction task finish, target file is {},time cost is {} s, compaction speed is {} MB/s", new Object[]{this.fullStorageGroupName, targetTsFileResource.getTsFile().getName(), costTime, (double)this.selectedFileSize / 1024.0 / 1024.0 / costTime});
            if (logFile.exists()) {
                FileUtils.delete((File)logFile);
            }
            if (targetTsFileResource.isDeleted()) {
                targetTsFileResource.remove();
            } else {
                targetTsFileResource.setStatus(TsFileResourceStatus.CLOSED);
            }
        }
        catch (Throwable throwable) {
            LOGGER.warn("{} [Compaction] Start to handle exception", (Object)this.fullStorageGroupName);
            if (sizeTieredCompactionLogger != null) {
                sizeTieredCompactionLogger.close();
            }
            if (this.isSequence()) {
                CompactionExceptionHandler.handleException(this.fullStorageGroupName, logFile, targetTsFileList, this.selectedTsFileResourceList, Collections.emptyList(), this.tsFileManager, this.timePartition, true, this.isSequence());
            } else {
                CompactionExceptionHandler.handleException(this.fullStorageGroupName, logFile, targetTsFileList, Collections.emptyList(), this.selectedTsFileResourceList, this.tsFileManager, this.timePartition, true, this.isSequence());
            }
            throw throwable;
        }
        finally {
            this.releaseFileLocksAndResetMergingStatus();
        }
    }

    @Override
    public boolean equalsOtherTask(AbstractCompactionTask other) {
        if (other instanceof SizeTieredCompactionTask) {
            SizeTieredCompactionTask otherSizeTieredTask = (SizeTieredCompactionTask)other;
            return this.selectedTsFileResourceList.equals(otherSizeTieredTask.selectedTsFileResourceList);
        }
        return false;
    }

    @Override
    public boolean checkValidAndSetMerging() {
        for (int i = 0; i < this.selectedTsFileResourceList.size(); ++i) {
            TsFileResource resource = (TsFileResource)this.selectedTsFileResourceList.get(i);
            resource.readLock();
            this.isHoldingReadLock[i] = true;
            if (!resource.isCompacting() && resource.isClosed() && resource.getTsFile().exists() && !resource.isDeleted()) continue;
            this.releaseFileLocksAndResetMergingStatus();
            return false;
        }
        for (TsFileResource resource : this.selectedTsFileResourceList) {
            resource.setStatus(TsFileResourceStatus.COMPACTING);
        }
        return true;
    }

    private void releaseFileLocksAndResetMergingStatus() {
        for (int i = 0; i < this.selectedTsFileResourceList.size(); ++i) {
            if (this.isHoldingReadLock[i]) {
                ((TsFileResource)this.selectedTsFileResourceList.get(i)).readUnlock();
            }
            if (this.isHoldingWriteLock[i]) {
                ((TsFileResource)this.selectedTsFileResourceList.get(i)).writeUnlock();
            }
            ((TsFileResource)this.selectedTsFileResourceList.get(i)).setStatus(TsFileResourceStatus.CLOSED);
        }
    }
}

