/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.jobcontrol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.jobcontrol.Job;
import org.apache.hadoop.mapreduce.lib.jobcontrol.ControlledJob;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class JobControl
implements Runnable {
    private static final Log LOG = LogFactory.getLog(JobControl.class);
    private ThreadState runnerState;
    private LinkedList<ControlledJob> jobsInProgress = new LinkedList();
    private LinkedList<ControlledJob> successfulJobs = new LinkedList();
    private LinkedList<ControlledJob> failedJobs = new LinkedList();
    private long nextJobID = -1L;
    private String groupName;

    public JobControl(String groupName) {
        this.groupName = groupName;
        this.runnerState = ThreadState.READY;
    }

    private static List<ControlledJob> toList(LinkedList<ControlledJob> jobs) {
        ArrayList<ControlledJob> retv = new ArrayList<ControlledJob>();
        for (ControlledJob job : jobs) {
            retv.add(job);
        }
        return retv;
    }

    private synchronized List<ControlledJob> getJobsIn(ControlledJob.State state) {
        LinkedList<ControlledJob> l = new LinkedList<ControlledJob>();
        for (ControlledJob j : this.jobsInProgress) {
            if (j.getJobState() != state) continue;
            l.add(j);
        }
        return l;
    }

    public List<ControlledJob> getWaitingJobList() {
        return this.getJobsIn(ControlledJob.State.WAITING);
    }

    public List<ControlledJob> getRunningJobList() {
        return this.getJobsIn(ControlledJob.State.RUNNING);
    }

    public List<ControlledJob> getReadyJobsList() {
        return this.getJobsIn(ControlledJob.State.READY);
    }

    public synchronized List<ControlledJob> getSuccessfulJobList() {
        return JobControl.toList(this.successfulJobs);
    }

    public synchronized List<ControlledJob> getFailedJobList() {
        return JobControl.toList(this.failedJobs);
    }

    private String getNextJobID() {
        ++this.nextJobID;
        return this.groupName + this.nextJobID;
    }

    public synchronized String addJob(ControlledJob aJob) {
        String id = this.getNextJobID();
        aJob.setJobID(id);
        aJob.setJobState(ControlledJob.State.WAITING);
        this.jobsInProgress.add(aJob);
        return id;
    }

    public synchronized String addJob(Job aJob) {
        return this.addJob((ControlledJob)aJob);
    }

    public void addJobCollection(Collection<ControlledJob> jobs) {
        for (ControlledJob job : jobs) {
            this.addJob(job);
        }
    }

    public ThreadState getThreadState() {
        return this.runnerState;
    }

    public void stop() {
        this.runnerState = ThreadState.STOPPING;
    }

    public void suspend() {
        if (this.runnerState == ThreadState.RUNNING) {
            this.runnerState = ThreadState.SUSPENDED;
        }
    }

    public void resume() {
        if (this.runnerState == ThreadState.SUSPENDED) {
            this.runnerState = ThreadState.RUNNING;
        }
    }

    public synchronized boolean allFinished() {
        return this.jobsInProgress.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.runnerState = ThreadState.RUNNING;
            while (true) {
                if (this.runnerState == ThreadState.SUSPENDED) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                JobControl jobControl = this;
                synchronized (jobControl) {
                    Iterator it = this.jobsInProgress.iterator();
                    while (it.hasNext()) {
                        ControlledJob j = (ControlledJob)it.next();
                        LOG.debug((Object)("Checking state of job " + j));
                        switch (j.checkState()) {
                            case SUCCESS: {
                                this.successfulJobs.add(j);
                                it.remove();
                                break;
                            }
                            case FAILED: 
                            case DEPENDENT_FAILED: {
                                this.failedJobs.add(j);
                                it.remove();
                                break;
                            }
                            case READY: {
                                j.submit();
                                break;
                            }
                        }
                    }
                }
                if (this.runnerState != ThreadState.RUNNING && this.runnerState != ThreadState.SUSPENDED) break;
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.runnerState != ThreadState.RUNNING && this.runnerState != ThreadState.SUSPENDED) break;
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Error while trying to run jobs.", t);
            this.failAllJobs(t);
        }
        this.runnerState = ThreadState.STOPPED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void failAllJobs(Throwable t) {
        String message = "Unexpected System Error Occured: " + StringUtils.stringifyException((Throwable)t);
        Iterator it = this.jobsInProgress.iterator();
        while (it.hasNext()) {
            ControlledJob j = (ControlledJob)it.next();
            try {
                j.failJob(message);
            }
            catch (IOException e) {
                LOG.error((Object)("Error while tyring to clean up " + j.getJobName()), (Throwable)e);
            }
            catch (InterruptedException e) {
                LOG.error((Object)("Error while tyring to clean up " + j.getJobName()), (Throwable)e);
            }
            finally {
                this.failedJobs.add(j);
                it.remove();
            }
        }
    }

    public static enum ThreadState {
        RUNNING,
        SUSPENDED,
        STOPPED,
        STOPPING,
        READY;

    }
}

