/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class JavaSerializer
extends Serializer {
    private ObjectOutputStream objectStream;
    private Output lastOutput;

    public void write(Kryo kryo, Output output, Object object) {
        try {
            if (output != this.lastOutput) {
                this.objectStream = new ObjectOutputStream(output);
                this.lastOutput = output;
            } else {
                this.objectStream.reset();
            }
            this.objectStream.writeObject(object);
            this.objectStream.flush();
        }
        catch (Exception ex) {
            throw new KryoException("Error during Java serialization.", ex);
        }
    }

    public Object read(Kryo kryo, Input input, Class type) {
        try {
            return new ObjectInputStream(input).readObject();
        }
        catch (Exception ex) {
            throw new KryoException("Error during Java deserialization.", ex);
        }
    }
}

