/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.inject.Provides;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.container.filter.GZIPContentEncodingFilter;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.yarn.webapp.Controller;
import org.apache.hadoop.yarn.webapp.DefaultWrapperServlet;
import org.apache.hadoop.yarn.webapp.Dispatcher;
import org.apache.hadoop.yarn.webapp.Router;
import org.apache.hadoop.yarn.webapp.WebAppException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
public abstract class WebApp
extends ServletModule {
    private static final Logger LOG = LoggerFactory.getLogger(WebApp.class);
    private volatile String name;
    private volatile List<String> servePathSpecs = new ArrayList<String>();
    private volatile String redirectPath;
    private volatile String wsName;
    private volatile Configuration conf;
    private volatile HttpServer2 httpServer;
    private volatile GuiceFilter guiceFilter;
    private final Router router = new Router();
    static final int R_PATH = 0;
    static final int R_CONTROLLER = 1;
    static final int R_ACTION = 2;
    static final int R_PARAMS = 3;
    static final Splitter pathSplitter = Splitter.on((char)'/').trimResults().omitEmptyStrings();

    void setHttpServer(HttpServer2 server) {
        this.httpServer = (HttpServer2)Preconditions.checkNotNull((Object)server, (Object)"http server");
    }

    @Provides
    public HttpServer2 httpServer() {
        return this.httpServer;
    }

    public InetSocketAddress getListenerAddress() {
        return ((HttpServer2)Preconditions.checkNotNull((Object)this.httpServer, (Object)"httpServer")).getConnectorAddress(0);
    }

    public int port() {
        InetSocketAddress addr = ((HttpServer2)Preconditions.checkNotNull((Object)this.httpServer, (Object)"httpServer")).getConnectorAddress(0);
        return addr == null ? -1 : addr.getPort();
    }

    public void stop() {
        try {
            ((HttpServer2)Preconditions.checkNotNull((Object)this.httpServer, (Object)"httpServer")).stop();
            ((GuiceFilter)Preconditions.checkNotNull((Object)this.guiceFilter, (Object)"guiceFilter")).destroy();
        }
        catch (Exception e) {
            throw new WebAppException(e);
        }
    }

    public void joinThread() {
        try {
            ((HttpServer2)Preconditions.checkNotNull((Object)this.httpServer, (Object)"httpServer")).join();
        }
        catch (InterruptedException e) {
            LOG.info("interrupted", (Throwable)e);
        }
    }

    void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Provides
    public Configuration conf() {
        return this.conf;
    }

    @Provides
    Router router() {
        return this.router;
    }

    @Provides
    WebApp webApp() {
        return this;
    }

    void setName(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public String wsName() {
        return this.wsName;
    }

    void addServePathSpec(String path) {
        this.servePathSpecs.add(path);
    }

    public String[] getServePathSpecs() {
        return this.servePathSpecs.toArray(new String[this.servePathSpecs.size()]);
    }

    void setRedirectPath(String path) {
        this.redirectPath = path;
    }

    void setWebServices(String name) {
        this.wsName = name;
    }

    public String getRedirectPath() {
        return this.redirectPath;
    }

    void setHostClass(Class<?> cls) {
        this.router.setHostClass(cls);
    }

    void setGuiceFilter(GuiceFilter instance) {
        this.guiceFilter = instance;
    }

    public void configureServlets() {
        this.setup();
        this.serve("/", new String[]{"/__stop"}).with(Dispatcher.class);
        for (String path : this.servePathSpecs) {
            this.serve(path, new String[0]).with(Dispatcher.class);
        }
        this.configureWebAppServlets();
    }

    protected void configureWebAppServlets() {
        if (this.wsName != null) {
            String regex = "(?!/" + this.wsName + ")";
            this.serveRegex(regex, new String[0]).with(DefaultWrapperServlet.class);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("com.sun.jersey.config.feature.ImplicitViewables", "true");
            params.put("com.sun.jersey.config.feature.FilterForwardOn404", "true");
            params.put("com.sun.jersey.config.feature.XmlRootElementProcessing", "true");
            params.put("com.sun.jersey.spi.container.ContainerRequestFilters", GZIPContentEncodingFilter.class.getName());
            params.put("com.sun.jersey.spi.container.ContainerResponseFilters", GZIPContentEncodingFilter.class.getName());
            this.filter("/*", new String[0]).through(this.getWebAppFilterClass(), params);
        }
    }

    protected Class<? extends GuiceContainer> getWebAppFilterClass() {
        return GuiceContainer.class;
    }

    public void route(HTTP method, String pathSpec, Class<? extends Controller> cls, String action) {
        List<String> res = WebApp.parseRoute(pathSpec);
        this.router.add(method, res.get(0), cls, action, res.subList(3, res.size()));
    }

    public void route(String pathSpec, Class<? extends Controller> cls, String action) {
        this.route(HTTP.GET, pathSpec, cls, action);
    }

    public void route(String pathSpec, Class<? extends Controller> cls) {
        List<String> res = WebApp.parseRoute(pathSpec);
        this.router.add(HTTP.GET, res.get(0), cls, res.get(2), res.subList(3, res.size()));
    }

    static List<String> parseRoute(String pathSpec) {
        ArrayList result = Lists.newArrayList();
        result.add(WebApp.getPrefix((String)Preconditions.checkNotNull((Object)pathSpec, (Object)"pathSpec")));
        Iterable parts = pathSplitter.split((CharSequence)pathSpec);
        String controller = null;
        String action = null;
        for (String s : parts) {
            if (controller == null) {
                if (s.charAt(0) == ':') {
                    controller = "default";
                    result.add(controller);
                    action = "index";
                    result.add(action);
                } else {
                    controller = s;
                }
            } else if (action == null) {
                if (s.charAt(0) == ':') {
                    action = "index";
                    result.add(action);
                } else {
                    action = s;
                }
            }
            result.add(s);
        }
        if (controller == null) {
            result.add("default");
        }
        if (action == null) {
            result.add("index");
        }
        return result;
    }

    static String getPrefix(String pathSpec) {
        char c;
        int start = 0;
        while (CharMatcher.WHITESPACE.matches(pathSpec.charAt(start))) {
            ++start;
        }
        if (pathSpec.charAt(start) != '/') {
            throw new WebAppException("Path spec syntax error: " + pathSpec);
        }
        int ci = pathSpec.indexOf(58);
        if (ci == -1) {
            ci = pathSpec.length();
        }
        if (ci == 1) {
            return "/";
        }
        while ((c = pathSpec.charAt(--ci)) == '/' || CharMatcher.WHITESPACE.matches(c)) {
        }
        return pathSpec.substring(start, ci + 1);
    }

    public abstract void setup();

    public static enum HTTP {
        GET,
        POST,
        HEAD,
        PUT,
        DELETE;

    }
}

