import { ApolloClient } from "apollo-client";
import { BulkProcessInstanceActionResponse, ProcessInstance, ProcessListSortBy, ProcessInstanceFilter } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
import { OperationType } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
export interface ProcessListQueries {
    getProcessInstances(start: number, end: number, filters: ProcessInstanceFilter, sortBy: ProcessListSortBy): Promise<ProcessInstance[]>;
    getChildProcessInstances(rootProcessInstanceId: string): Promise<ProcessInstance[]>;
    handleProcessSkip(processInstance: ProcessInstance): Promise<void>;
    handleProcessAbort(processInstance: ProcessInstance): Promise<void>;
    handleProcessRetry(processInstance: ProcessInstance): Promise<void>;
    handleProcessMultipleAction(processInstances: ProcessInstance[], operationType: OperationType): Promise<BulkProcessInstanceActionResponse>;
}
export declare class GraphQLProcessListQueries implements ProcessListQueries {
    private readonly client;
    constructor(client: ApolloClient<any>);
    getProcessInstances(offset: number, limit: number, filters: ProcessInstanceFilter, sortBy: ProcessListSortBy): Promise<ProcessInstance[]>;
    getChildProcessInstances(rootProcessInstanceId: string): Promise<ProcessInstance[]>;
    handleProcessSkip(processInstance: ProcessInstance): Promise<void>;
    handleProcessAbort(processInstance: ProcessInstance): Promise<void>;
    handleProcessRetry(processInstance: ProcessInstance): Promise<void>;
    handleProcessMultipleAction(processInstances: ProcessInstance[], operationType: OperationType): Promise<BulkProcessInstanceActionResponse>;
}
//# sourceMappingURL=ProcessListQueries.d.ts.map