import { Job, JobOperationResult, ProcessInstance } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
import { ProcessDetailsQueries } from "./ProcessDetailsQueries";
import { SvgSuccessResponse, SvgErrorResponse, TriggerableNode, NodeInstance } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
export interface OnOpenProcessInstanceDetailsListener {
    onOpen(id: string): void;
}
export interface ProcessDetailsUnSubscribeHandler {
    unSubscribe: () => void;
}
export interface ProcessDetailsState {
    id: string;
}
export interface ProcessDetailsGatewayApi {
    processDetailsState: any;
    getProcessDiagram: (data: ProcessInstance) => Promise<SvgSuccessResponse | SvgErrorResponse>;
    handleProcessAbort: (processInstance: ProcessInstance) => Promise<void>;
    cancelJob: (job: Pick<Job, "id" | "endpoint">) => Promise<JobOperationResult>;
    rescheduleJob: (job: Job, repeatInterval: number | string, repeatLimit: number | string, scheduleDate: Date) => Promise<{
        modalTitle: string;
        modalContent: string;
    }>;
    getTriggerableNodes(processInstance: ProcessInstance): Promise<TriggerableNode[]>;
    handleNodeTrigger(processInstance: ProcessInstance, node: any): Promise<void>;
    handleProcessVariableUpdate: (processInstance: ProcessInstance, updateJson: Record<string, unknown>) => Promise<Record<string, unknown>>;
    processDetailsQuery(id: string): Promise<ProcessInstance>;
    jobsQuery(id: string): Promise<Job[]>;
    openProcessInstanceDetails(id: string): Promise<void>;
    onOpenProcessInstanceDetailsListener: (listener: OnOpenProcessInstanceDetailsListener) => ProcessDetailsUnSubscribeHandler;
    handleProcessRetry: (processInstance: ProcessInstance) => Promise<void>;
    handleNodeInstanceCancel: (processInstance: ProcessInstance, node: NodeInstance) => Promise<void>;
    handleProcessSkip: (processInstance: ProcessInstance) => Promise<void>;
    handleNodeInstanceRetrigger(processInstance: ProcessInstance, node: NodeInstance): Promise<void>;
}
export declare class ProcessDetailsGatewayApiImpl implements ProcessDetailsGatewayApi {
    private readonly queries;
    private _ProcessDetailsState;
    private readonly listeners;
    constructor(queries: ProcessDetailsQueries);
    get processDetailsState(): ProcessDetailsState;
    getProcessDiagram: (data: ProcessInstance) => Promise<SvgSuccessResponse | SvgErrorResponse>;
    handleProcessAbort: (processInstance: ProcessInstance) => Promise<void>;
    cancelJob: (job: Job) => Promise<JobOperationResult>;
    rescheduleJob: (job: Job, repeatInterval: number | string, repeatLimit: number | string, scheduleDate: Date) => Promise<{
        modalTitle: string;
        modalContent: string;
    }>;
    getTriggerableNodes(processInstance: ProcessInstance): Promise<TriggerableNode[]>;
    handleNodeTrigger(processInstance: ProcessInstance, node: TriggerableNode): Promise<void>;
    handleProcessVariableUpdate: (processInstance: ProcessInstance, updatedJson: Record<string, unknown>) => Promise<Record<string, unknown>>;
    processDetailsQuery(id: string): Promise<ProcessInstance>;
    jobsQuery(id: string): Promise<Job[]>;
    openProcessInstanceDetails(id: string): Promise<void>;
    onOpenProcessInstanceDetailsListener(listener: OnOpenProcessInstanceDetailsListener): ProcessDetailsUnSubscribeHandler;
    handleProcessRetry(processInstance: ProcessInstance): Promise<void>;
    handleNodeInstanceCancel(processInstance: ProcessInstance, node: NodeInstance): Promise<void>;
    handleProcessSkip(processInstance: ProcessInstance): Promise<void>;
    handleNodeInstanceRetrigger(processInstance: ProcessInstance, node: NodeInstance): Promise<void>;
}
//# sourceMappingURL=ProcessDetailsGatewayApi.d.ts.map