var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from "react";
import { useCallback, useEffect, useMemo, useRef, useState } from "react";
import { CheckCircleIcon } from "@patternfly/react-icons/dist/js/icons/check-circle-icon";
import { InfoCircleIcon } from "@patternfly/react-icons/dist/js/icons/info-circle-icon";
import { ExclamationCircleIcon } from "@patternfly/react-icons/dist/js/icons/exclamation-circle-icon";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { OutlinedQuestionCircleIcon } from "@patternfly/react-icons/dist/js/icons/outlined-question-circle-icon";
import { DescriptionList, DescriptionListDescription, DescriptionListGroup, DescriptionListTerm, } from "@patternfly/react-core/dist/js/components/DescriptionList";
import { Card, CardBody, CardFooter, CardTitle } from "@patternfly/react-core/dist/js/components/Card";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { EmptyState, EmptyStateBody, EmptyStateIcon } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Text, TextContent } from "@patternfly/react-core/dist/js/components/Text";
import { formDmnI18n } from "./i18n";
import { I18nWrapped } from "@kie-tools-core/i18n/dist/react-components";
import "./styles.scss";
import { ErrorBoundary } from "@kie-tools/dmn-runner/dist/ErrorBoundary";
import { ExclamationTriangleIcon } from "@patternfly/react-icons/dist/js/icons/exclamation-triangle-icon";
import { DmnEvaluationStatus } from "@kie-tools/extended-services-api";
const ISSUES_URL = "https://github.com/apache/incubator-kie-issues/issues";
const DATE_REGEX = /\d{4}-(?:0[1-9]|1[0-2])-(?:0[1-9]|[1-2]\d|3[0-1])T(?:[0-1]\d|2[0-3]):[0-5]\d:[0-5]\dZ/;
var FormDmnOutputsStatus;
(function (FormDmnOutputsStatus) {
    FormDmnOutputsStatus[FormDmnOutputsStatus["EMPTY"] = 0] = "EMPTY";
    FormDmnOutputsStatus[FormDmnOutputsStatus["ERROR"] = 1] = "ERROR";
    FormDmnOutputsStatus[FormDmnOutputsStatus["VALID"] = 2] = "VALID";
})(FormDmnOutputsStatus || (FormDmnOutputsStatus = {}));
export function FormDmnOutputs(_a) {
    var { openExecutionTab } = _a, props = __rest(_a, ["openExecutionTab"]);
    const [formResultStatus, setFormResultStatus] = useState(FormDmnOutputsStatus.EMPTY);
    const [formResultError, setFormResultError] = useState(false);
    const i18n = useMemo(() => {
        var _a;
        formDmnI18n.setLocale((_a = props.locale) !== null && _a !== void 0 ? _a : navigator.language);
        return formDmnI18n.getCurrent();
    }, [props.locale]);
    const errorBoundaryRef = useRef(null);
    useEffect(() => {
        var _a;
        (_a = props.differences) === null || _a === void 0 ? void 0 : _a.forEach((difference, index) => {
            if (Object.keys(difference).length === 0) {
                return;
            }
            const updatedResult = document.getElementById(`${index}-dmn-result`);
            updatedResult === null || updatedResult === void 0 ? void 0 : updatedResult.classList.add("kogito--editor__dmn-form-result__leaf-updated");
        });
    }, [props.differences]);
    const onAnimationEnd = useCallback((e, index) => {
        e.preventDefault();
        e.stopPropagation();
        const updatedResult = document.getElementById(`${index}-dmn-result`);
        updatedResult === null || updatedResult === void 0 ? void 0 : updatedResult.classList.remove("kogito--editor__dmn-form-result__leaf-updated");
    }, []);
    const onOpenExecutionTab = useCallback(() => {
        if (props.notificationsPanel) {
            openExecutionTab === null || openExecutionTab === void 0 ? void 0 : openExecutionTab();
        }
    }, [props.notificationsPanel, openExecutionTab]);
    const resultStatus = useCallback((evaluationStatus) => {
        switch (evaluationStatus) {
            case DmnEvaluationStatus.SUCCEEDED:
                return (React.createElement(React.Fragment, null,
                    React.createElement("div", { className: "kie-tools__dmn-form-result__evaluation" },
                        React.createElement(CheckCircleIcon, null),
                        props.notificationsPanel ? (React.createElement("a", { onClick: onOpenExecutionTab, className: "kogito--editor__dmn-form-result__evaluation-link" }, i18n.result.evaluation.success)) : (React.createElement("p", { className: "kogito--editor__dmn-form-result__evaluation-link" }, i18n.result.evaluation.success)))));
            case DmnEvaluationStatus.SKIPPED:
                return (React.createElement(React.Fragment, null,
                    React.createElement("div", { className: "kie-tools__dmn-form-result__evaluation" },
                        React.createElement(InfoCircleIcon, null),
                        props.notificationsPanel ? (React.createElement("a", { onClick: onOpenExecutionTab, className: "kogito--editor__dmn-form-result__evaluation-link" }, i18n.result.evaluation.skipped)) : (React.createElement("p", { className: "kogito--editor__dmn-form-result__evaluation-link" }, i18n.result.evaluation.skipped)))));
            case DmnEvaluationStatus.FAILED:
                return (React.createElement(React.Fragment, null,
                    React.createElement("div", { className: "kie-tools__dmn-form-result__evaluation" },
                        React.createElement(ExclamationCircleIcon, null),
                        props.notificationsPanel ? (React.createElement("a", { onClick: onOpenExecutionTab, className: "kogito--editor__dmn-form-result__evaluation-link" }, i18n.result.evaluation.failed)) : (React.createElement("p", { className: "kogito--editor__dmn-form-result__evaluation-link" }, i18n.result.evaluation.failed)))));
        }
    }, [
        i18n.result.evaluation.failed,
        i18n.result.evaluation.skipped,
        i18n.result.evaluation.success,
        onOpenExecutionTab,
        props.notificationsPanel,
    ]);
    const result = useCallback((dmnFormResult, parentKey) => {
        switch (typeof dmnFormResult) {
            case "boolean":
                return dmnFormResult ? React.createElement("i", null, "true") : React.createElement("i", null, "false");
            case "number":
                return dmnFormResult;
            case "string":
                if (dmnFormResult.match(DATE_REGEX)) {
                    const current = new Date(dmnFormResult);
                    return (React.createElement(React.Fragment, null,
                        React.createElement(Tooltip, { key: `date-tooltip-${dmnFormResult}`, content: React.createElement(I18nWrapped, { components: { date: current.toString() } }, i18n.result.dateTooltip) },
                            React.createElement("div", { className: "kogito--editor__dmn-form-result__results-date" },
                                React.createElement("p", { className: "kogito--editor__dmn-form-result__results-date" }, dmnFormResult),
                                React.createElement(OutlinedQuestionCircleIcon, null)))));
                }
                return dmnFormResult;
            case "object":
                if (!dmnFormResult) {
                    return React.createElement("i", null, "(null)");
                }
                if (Array.isArray(dmnFormResult)) {
                    if (dmnFormResult.length === 0) {
                        return (React.createElement(React.Fragment, null,
                            parentKey && React.createElement(DescriptionListTerm, null, parentKey),
                            React.createElement("i", null, "(null)")));
                    }
                    return (React.createElement(DescriptionList, null,
                        React.createElement(DescriptionListGroup, { style: {
                                boxShadow: "0 0px 3px rgba(3, 3, 3, 0.15)",
                                padding: "10px",
                            } }, dmnFormResult.map((dmnResult, index) => (React.createElement(React.Fragment, { key: `array-result-${index}` },
                            React.createElement(DescriptionListTerm, null, parentKey ? `${parentKey}-${index}` : index),
                            React.createElement(DescriptionListDescription, null, result(dmnResult))))))));
                }
                return (React.createElement(DescriptionList, null,
                    React.createElement(DescriptionListGroup, { style: {
                            boxShadow: "0 0px 3px rgba(3, 3, 3, 0.15)",
                            padding: "10px",
                        } }, Object.entries(dmnFormResult).map(([key, value]) => (React.createElement(React.Fragment, { key: `object-result-${key}-${value}` },
                        value === null && (React.createElement(DescriptionListTerm, null, parentKey ? `${parentKey}-${key}` : key)),
                        value !== null && typeof value !== "object" && (React.createElement(DescriptionListTerm, null, parentKey ? `${parentKey}-${key}` : key)),
                        React.createElement(DescriptionListDescription, null, result(value, parentKey ? `${parentKey}-${key}` : key))))))));
            default:
                return React.createElement("i", null, "(null)");
        }
    }, [i18n]);
    const resultsToRender = useMemo(() => {
        var _a;
        return (_a = props.results) === null || _a === void 0 ? void 0 : _a.map((dmnFormResult, index) => (React.createElement("div", { key: `${index}-dmn-result`, className: "kogito--editor__dmn-form-result__results" },
            React.createElement(Card, { id: `${index}-dmn-result`, isFlat: true, className: "kogito--editor__dmn-form-result__results-card", onAnimationEnd: (e) => onAnimationEnd(e, index) },
                React.createElement(CardTitle, null,
                    React.createElement(Title, { headingLevel: "h2" }, dmnFormResult.decisionName)),
                React.createElement(CardBody, { isFilled: true }, result(dmnFormResult.result)),
                React.createElement(CardFooter, null, resultStatus(dmnFormResult.evaluationStatus))))));
    }, [onAnimationEnd, props.results, result, resultStatus]);
    const formResultErrorMessage = useMemo(() => (React.createElement("div", null,
        React.createElement(EmptyState, null,
            React.createElement(EmptyStateIcon, { icon: ExclamationTriangleIcon }),
            React.createElement(TextContent, null,
                React.createElement(Text, { component: "h2" }, i18n.result.error.title)),
            React.createElement(EmptyStateBody, null,
                React.createElement(TextContent, null, i18n.result.error.explanation),
                React.createElement("br", null),
                React.createElement(TextContent, null,
                    React.createElement(I18nWrapped, { components: {
                            jira: (React.createElement("a", { href: ISSUES_URL, target: "_blank", rel: "noopener noreferrer" }, ISSUES_URL)),
                        } }, i18n.result.error.message)))))), [i18n]);
    useEffect(() => {
        if (resultsToRender && resultsToRender.length > 0) {
            setFormResultStatus(FormDmnOutputsStatus.VALID);
        }
        else if (formResultError) {
            setFormResultStatus(FormDmnOutputsStatus.ERROR);
        }
        else {
            setFormResultStatus(FormDmnOutputsStatus.EMPTY);
        }
    }, [resultsToRender, formResultError]);
    useEffect(() => {
        var _a;
        (_a = errorBoundaryRef.current) === null || _a === void 0 ? void 0 : _a.reset();
    }, [props.results]);
    return (React.createElement(React.Fragment, null,
        formResultStatus === FormDmnOutputsStatus.EMPTY && (React.createElement(EmptyState, null,
            React.createElement(EmptyStateIcon, { icon: InfoCircleIcon }),
            React.createElement(TextContent, null,
                React.createElement(Text, { component: "h2" }, i18n.result.withoutResponse.title)),
            React.createElement(EmptyStateBody, null,
                React.createElement(TextContent, null,
                    React.createElement(Text, null, i18n.result.withoutResponse.explanation))))),
        formResultStatus === FormDmnOutputsStatus.ERROR && formResultErrorMessage,
        formResultStatus === FormDmnOutputsStatus.VALID && (React.createElement(ErrorBoundary, { ref: errorBoundaryRef, setHasError: setFormResultError, error: formResultErrorMessage },
            React.createElement("div", { "data-testid": "dmn-form-result" }, resultsToRender)))));
}
//# sourceMappingURL=FormDmnOutputs.js.map