/// <reference types="react" />
import { DashbuilderWrapper } from "../dashbuilder/DashbuilderWrapper";
import { Editor, EditorInitArgs, EditorTheme, KogitoEditorEnvelopeContextType } from "@kie-tools-core/editor/dist/api";
import { Notification } from "@kie-tools-core/notifications/dist/api";
import { DashbuilderViewerChannelApi } from "./DashbuilderViewerChannelApi";
export declare class DashbuilderViewerView implements Editor {
    private readonly envelopeContext;
    private readonly initArgs;
    private readonly editorRef;
    dashbuilderWrapper: DashbuilderWrapper;
    af_isReact: boolean;
    af_componentId: "dashbuilder-editor";
    af_componentTitle: "Dashbuilder Editor";
    constructor(envelopeContext: KogitoEditorEnvelopeContextType<DashbuilderViewerChannelApi>, initArgs: EditorInitArgs);
    setContent(normalizedPosixPathRelativeToTheWorkspaceRoot: string, content: string): Promise<void>;
    getContent(): Promise<string>;
    getPreview(): Promise<string | undefined>;
    af_componentRoot(): JSX.Element;
    undo(): Promise<void>;
    redo(): Promise<void>;
    validate(): Promise<Notification[]>;
    setTheme(theme: EditorTheme): Promise<void>;
}
//# sourceMappingURL=DashbuilderViewerView.d.ts.map