import React from "react";
import Moment from "react-moment";
import TaskDescription from "../TaskDescription/TaskDescription";
import { TaskState } from "../../../../taskDetails";
export const getDefaultColumn = (columnPath, columnLabel, isSortable) => {
    return {
        path: columnPath,
        label: columnLabel,
        isSortable,
    };
};
export const getDateColumn = (columnPath, columnLabel) => {
    return {
        label: columnLabel,
        path: columnPath,
        bodyCellTransformer: (value) => React.createElement(Moment, { fromNow: true }, new Date(`${value}`)),
        isSortable: true,
    };
};
export const getTaskDescriptionColumn = (selectTask) => {
    return {
        label: "Name",
        path: "referenceName",
        bodyCellTransformer: (cellValue, rowTask) => {
            return (React.createElement(TaskDescription, { task: rowTask, onClick: () => selectTask(rowTask) }));
        },
        isSortable: true,
    };
};
export const getTaskStateColumn = () => {
    return {
        label: "Status",
        path: "state",
        bodyCellTransformer: (cellValue, rowTask) => React.createElement(TaskState, { task: rowTask }),
        isSortable: true,
    };
};
export const getDefaultTaskStates = () => {
    return ["Ready", "Reserved", "Completed", "Aborted", "Skipped"];
};
export const getDefaultActiveTaskStates = () => {
    return ["Ready", "Reserved"];
};
//# sourceMappingURL=TaskInboxUtils.js.map