export interface TaskInboxEnvelopeApi {
    taskInbox__init(association: Association, initArgs: TaskInboxInitArgs): Promise<void>;
    taskInbox__notify(userName: string): Promise<void>;
}
export interface Association {
    origin: string;
    envelopeServerId: string;
}
export interface TaskInboxInitArgs {
    initialState?: TaskInboxState;
    allTaskStates?: string[];
    activeTaskStates?: string[];
}
export interface TaskInboxState {
    filters: QueryFilter;
    sortBy: SortBy;
    currentPage: QueryPage;
}
export interface QueryFilter {
    taskStates: string[];
    taskNames: string[];
}
export interface SortBy {
    property: string;
    direction: "asc" | "desc";
}
export interface QueryPage {
    offset: number;
    limit: number;
}
//# sourceMappingURL=TaskInboxEnvelopeApi.d.ts.map