var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React, { useCallback, useEffect, useImperativeHandle, useState } from "react";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { TaskFormEnvelopeViewDriver } from "./TaskFormEnvelopeViewDriver";
import CustomTaskFormDisplayer from "./components/CustomTaskFormDisplayer/CustomTaskFormDisplayer";
import TaskForm from "./components/TaskForm/TaskForm";
import "@patternfly/patternfly/patternfly.css";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { KogitoEmptyState, KogitoEmptyStateType, } from "@kie-tools/runtime-tools-components/dist/components/KogitoEmptyState";
export const TaskFormEnvelopeView = React.forwardRef(({ channelApi, targetOrigin, ouiaId, ouiaSafe }, forwardedRef) => {
    const [isLoading, setIsLoading] = useState(true);
    const [isEnvelopeConnectedToChannel, setEnvelopeConnectedToChannel] = useState(false);
    const [userTask, setUserTask] = useState();
    const [user, setUser] = useState();
    const [taskFormSchema, setTaskFormSchema] = useState();
    const [customForm, setCustomForm] = useState();
    const [driver] = useState(new TaskFormEnvelopeViewDriver(channelApi));
    useImperativeHandle(forwardedRef, () => ({
        initialize: (initArgs) => {
            setEnvelopeConnectedToChannel(true);
            setUserTask(initArgs.userTask);
            setUser(initArgs.user);
        },
    }), []);
    useEffect(() => {
        if (isEnvelopeConnectedToChannel) {
            loadForm();
        }
    }, [isEnvelopeConnectedToChannel]);
    const loadForm = useCallback(() => __awaiter(void 0, void 0, void 0, function* () {
        if (!isEnvelopeConnectedToChannel) {
            setIsLoading(true);
        }
        const customFormPromise = new Promise((resolve) => {
            driver
                .getCustomForm()
                .then((customForm) => {
                setCustomForm(customForm);
                resolve();
            })
                .catch((error) => resolve());
        });
        const schemaPromise = new Promise((resolve) => {
            driver
                .getTaskFormSchema()
                .then((schema) => {
                setTaskFormSchema(schema);
                resolve();
            })
                .catch((error) => resolve());
        });
        Promise.all([customFormPromise, schemaPromise]).then((values) => {
            setIsLoading(false);
        });
    }), [isEnvelopeConnectedToChannel]);
    if (isLoading) {
        return (React.createElement(Bullseye, Object.assign({}, componentOuiaProps((ouiaId ? ouiaId : "task-form-envelope-view") + "-loading-spinner", "task-form", true)),
            React.createElement(KogitoSpinner, { spinnerText: `Loading task form...` })));
    }
    if (taskFormSchema) {
        if (customForm) {
            return (React.createElement(CustomTaskFormDisplayer, Object.assign({}, componentOuiaProps((ouiaId ? ouiaId : "task-form-envelope-view") + "-custom-task-form", "custom-task-form", ouiaSafe), { userTask: userTask, schema: taskFormSchema, customForm: customForm, user: user, driver: driver, targetOrigin: targetOrigin })));
        }
        return (React.createElement(TaskForm, Object.assign({}, componentOuiaProps((ouiaId ? ouiaId : "task-form-envelope-view") + "-task-form", "task-form", ouiaSafe), { userTask: userTask, schema: taskFormSchema, driver: driver })));
    }
    return (React.createElement(KogitoEmptyState, Object.assign({ type: KogitoEmptyStateType.Info, title: "No form to show", body: `Cannot find form for task  ${userTask.referenceName} (${userTask.id.substring(0, 5)})` }, componentOuiaProps((ouiaId ? ouiaId : "task-form-envelope-view") + "-no-form", "empty-task-form", ouiaSafe))));
});
export default TaskFormEnvelopeView;
//# sourceMappingURL=TaskFormEnvelopeView.js.map