import React from "react";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { BanIcon } from "@patternfly/react-icons/dist/js/icons/ban-icon";
import { CheckCircleIcon } from "@patternfly/react-icons/dist/js/icons/check-circle-icon";
import { OnRunningIcon } from "@patternfly/react-icons/dist/js/icons/on-running-icon";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
export const TaskState = ({ task, variant, ouiaId, ouiaSafe }) => {
    const icon = resolveTaskStateIcon(task);
    if (variant === "label") {
        const color = resolveTaskStateLabelColor(task);
        return (React.createElement(Label, Object.assign({ color: color, icon: icon }, componentOuiaProps(ouiaId, "task-state", ouiaSafe)), task.state));
    }
    return (React.createElement(React.Fragment, null,
        icon,
        " ",
        React.createElement("span", Object.assign({}, componentOuiaProps(ouiaId, "task-state", ouiaSafe)), task.state)));
};
function resolveTaskStateIcon(task) {
    if (task.state === "Aborted") {
        return React.createElement(BanIcon, { className: "pf-u-mr-sm" });
    }
    else if (task.completed) {
        return React.createElement(CheckCircleIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--success-color--100)" });
    }
    else {
        return React.createElement(OnRunningIcon, { className: "pf-u-mr-sm" });
    }
}
function resolveTaskStateLabelColor(task) {
    if (task.state === "Aborted") {
        return "red";
    }
    else if (task.completed) {
        return "green";
    }
    else {
        return "blue";
    }
}
export default TaskState;
//# sourceMappingURL=TaskState.js.map