var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Table, TableBody, TableHeader } from "@patternfly/react-table/dist/js/components/Table";
import React, { useEffect, useState } from "react";
import { getProcessInstanceDescription, ProcessInstanceIconCreator } from "../utils/ProcessListUtils";
import { HistoryIcon } from "@patternfly/react-icons/dist/js/icons/history-icon";
import Moment from "react-moment";
import ProcessListActionsKebab from "../ProcessListActionsKebab/ProcessListActionsKebab";
import { Checkbox } from "@patternfly/react-core/dist/js/components/Checkbox";
import DisablePopup from "../DisablePopup/DisablePopup";
import ErrorPopover from "../ErrorPopover/ErrorPopover";
import "../styles.css";
import { ProcessInstanceState } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { ItemDescriptor } from "@kie-tools/runtime-tools-components/dist/components/ItemDescriptor";
import { EndpointLink } from "@kie-tools/runtime-tools-components/dist/components/EndpointLink";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { ServerErrors } from "@kie-tools/runtime-tools-components/dist/components/ServerErrors";
import { KogitoEmptyState, KogitoEmptyStateType, } from "@kie-tools/runtime-tools-components/dist/components/KogitoEmptyState";
import _ from "lodash";
const ProcessListChildTable = ({ parentProcessId, selectedInstances, setSelectedInstances, processInstances, setProcessInstances, driver, onSkipClick, onRetryClick, onAbortClick, setSelectableInstances, singularProcessLabel, pluralProcessLabel, ouiaId, ouiaSafe, }) => {
    const [rows, setRows] = useState([]);
    const [isLoading, setIsLoading] = useState(false);
    const [showNoDataEmptyState, setShowNoDataEmptyState] = useState(false);
    const [error, setError] = useState();
    const columnNames = ["__Select", "Id", "Status", "Created", "Last update", "__Actions"];
    const columns = columnNames.map((it) => ({
        title: it.startsWith("__") ? "" : it,
    }));
    const handleClick = (childProcessInstance) => {
        driver.openProcess(childProcessInstance);
    };
    const checkBoxSelect = (processInstance) => {
        const clonedProcessInstances = [...processInstances];
        clonedProcessInstances.forEach((instance) => {
            var _a;
            if (instance.id === parentProcessId) {
                (_a = instance.childProcessInstances) === null || _a === void 0 ? void 0 : _a.forEach((childInstance) => {
                    if (childInstance.id === processInstance.id) {
                        if (childInstance.isSelected) {
                            childInstance.isSelected = false;
                            setSelectedInstances(selectedInstances.filter((selectedInstance) => selectedInstance.id !== childInstance.id));
                        }
                        else {
                            childInstance.isSelected = true;
                            setSelectedInstances([...selectedInstances, childInstance]);
                        }
                    }
                });
            }
        });
        setProcessInstances(clonedProcessInstances);
    };
    const createRows = (childProcessInstances) => {
        if (!_.isEmpty(childProcessInstances)) {
            const tempRows = [];
            childProcessInstances.forEach((child) => {
                var _a;
                const cells = [
                    {
                        title: (React.createElement(React.Fragment, null, ((_a = child.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management")) && child.serviceUrl !== null ? (React.createElement(Checkbox, { isChecked: child.isSelected, onChange: () => {
                                checkBoxSelect(child);
                            }, "aria-label": "process-list-checkbox", id: `checkbox-${child.id}`, name: `checkbox-${child.id}`, "data-testid": `checkbox-${child.id}` })) : (React.createElement(DisablePopup, { processInstanceData: child, component: React.createElement(Checkbox, { "aria-label": "process-list-checkbox-disabled", id: `checkbox-${child.id}`, isDisabled: true }) })))),
                    },
                    {
                        title: (React.createElement(React.Fragment, null,
                            React.createElement("a", Object.assign({ className: "kogito-process-list__link", onClick: () => handleClick(child) }, componentOuiaProps(ouiaId, "process-description", ouiaSafe)),
                                React.createElement("strong", null,
                                    React.createElement(ItemDescriptor, { itemDescription: getProcessInstanceDescription(child) }))),
                            React.createElement(EndpointLink, { serviceUrl: child.serviceUrl, isLinkShown: false }))),
                    },
                    {
                        title: child.state === ProcessInstanceState.Error ? (React.createElement(ErrorPopover, { processInstanceData: child, onSkipClick: onSkipClick, onRetryClick: onRetryClick })) : (ProcessInstanceIconCreator(child.state)),
                    },
                    {
                        title: child.start ? React.createElement(Moment, { fromNow: true }, new Date(`${child.start}`)) : "",
                    },
                    {
                        title: child.lastUpdate ? (React.createElement("span", null,
                            " ",
                            React.createElement(HistoryIcon, { className: "pf-u-mr-sm" }),
                            " Updated",
                            " ",
                            React.createElement(Moment, { fromNow: true }, new Date(`${child.lastUpdate}`)))) : (""),
                    },
                    {
                        title: (React.createElement(ProcessListActionsKebab, { processInstance: child, onSkipClick: onSkipClick, onRetryClick: onRetryClick, onAbortClick: onAbortClick, key: child.id })),
                    },
                ];
                cells.forEach((cellInRow, index) => {
                    cellInRow.props = componentOuiaProps(columnNames[index].toLowerCase(), "process-list-cell", true);
                });
                tempRows.push({
                    cells: cells,
                });
            });
            setRows(tempRows);
            setShowNoDataEmptyState(false);
        }
        else {
            setShowNoDataEmptyState(true);
        }
    };
    const getChildProcessInstances = () => __awaiter(void 0, void 0, void 0, function* () {
        try {
            setIsLoading(true);
            const response = yield driver.getChildProcessesQuery(parentProcessId);
            processInstances.forEach((processInstance) => {
                if (processInstance.id === parentProcessId) {
                    response.forEach((child) => {
                        var _a;
                        child.isSelected = false;
                        if (child.serviceUrl && ((_a = child.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management"))) {
                            setSelectableInstances((prev) => prev + 1);
                        }
                    });
                    processInstance.childProcessInstances = response;
                }
            });
            createRows(response);
        }
        catch (error) {
            setError(error);
        }
        finally {
            setIsLoading(false);
        }
    });
    useEffect(() => {
        if (processInstances.length > 0) {
            const processInstance = processInstances.find((instance) => instance.id === parentProcessId);
            processInstance && createRows(processInstance.childProcessInstances);
        }
    }, [processInstances]);
    useEffect(() => {
        getChildProcessInstances();
    }, []);
    if (isLoading) {
        return React.createElement(KogitoSpinner, { spinnerText: "Loading child instances..." });
    }
    if (error) {
        return React.createElement(ServerErrors, { error: error, variant: "large" });
    }
    if (!isLoading && showNoDataEmptyState) {
        return (React.createElement(KogitoEmptyState, { type: KogitoEmptyStateType.Info, title: `No child ${singularProcessLabel.toLowerCase()} instances`, body: `This ${singularProcessLabel.toLowerCase()} has no related sub ${pluralProcessLabel.toLowerCase()}` }));
    }
    return (React.createElement(Table, Object.assign({ "aria-label": "Process List Child Table", cells: columns, rows: rows, variant: "compact", className: "kogito-management-console__compact-table" }, componentOuiaProps(ouiaId, "process-list-child-table", ouiaSafe ? ouiaSafe : !isLoading)),
        React.createElement(TableHeader, null),
        React.createElement(TableBody, null)));
};
export default ProcessListChildTable;
//# sourceMappingURL=ProcessListChildTable.js.map