var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React from "react";
import { ClockIcon } from "@patternfly/react-icons/dist/js/icons/clock-icon";
import { BanIcon } from "@patternfly/react-icons/dist/js/icons/ban-icon";
import { UndoIcon } from "@patternfly/react-icons/dist/js/icons/undo-icon";
import { ErrorCircleOIcon } from "@patternfly/react-icons/dist/js/icons/error-circle-o-icon";
import { CheckCircleIcon } from "@patternfly/react-icons/dist/js/icons/check-circle-icon";
import { setTitle } from "@kie-tools/runtime-tools-components/dist/utils/Utils";
import { JobStatus } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
export const JobsIconCreator = (state) => {
    switch (state) {
        case JobStatus.Error:
            return (React.createElement(React.Fragment, null,
                React.createElement(ErrorCircleOIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--danger-color--100)" }),
                "Error"));
        case JobStatus.Canceled:
            return (React.createElement(React.Fragment, null,
                React.createElement(BanIcon, { className: "pf-u-mr-sm" }),
                "Canceled"));
        case JobStatus.Executed:
            return (React.createElement(React.Fragment, null,
                React.createElement(CheckCircleIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--success-color--100)" }),
                "Executed"));
        case JobStatus.Retry:
            return (React.createElement(React.Fragment, null,
                React.createElement(UndoIcon, { className: "pf-u-mr-sm" }),
                "Retry"));
        case JobStatus.Scheduled:
            return (React.createElement(React.Fragment, null,
                React.createElement(ClockIcon, { className: "pf-u-mr-sm" }),
                "Scheduled"));
    }
};
export const handleRetry = (processInstance, drive, onRetrySuccess, onRetryFailure) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        yield drive.handleProcessRetry(processInstance);
        onRetrySuccess();
    }
    catch (error) {
        onRetryFailure(JSON.stringify(error.message));
    }
});
export const handleSkip = (processInstance, drive, onSkipSuccess, onSkipFailure) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        yield drive.handleProcessSkip(processInstance);
        onSkipSuccess();
    }
    catch (error) {
        onSkipFailure(JSON.stringify(error.message));
    }
});
export const handleNodeInstanceRetrigger = (processInstance, driver, node, onRetriggerSuccess, onRetriggerFailure) => {
    driver
        .handleNodeInstanceRetrigger(processInstance, node)
        .then(() => {
        onRetriggerSuccess();
    })
        .catch((error) => {
        onRetriggerFailure(JSON.stringify(error.message));
    });
};
export const handleNodeInstanceCancel = (processInstance, drive, node, onCancelSuccess, onCancelFailure) => {
    drive
        .handleNodeInstanceCancel(processInstance, node)
        .then(() => {
        onCancelSuccess();
    })
        .catch((error) => {
        onCancelFailure(JSON.stringify(error.message));
    });
};
export const jobCancel = (drive, job, setModalTitle, setModalContent) => __awaiter(void 0, void 0, void 0, function* () {
    const response = yield drive.cancelJob(job);
    setModalTitle(setTitle(response.modalTitle, "Job cancel"));
    setModalContent(response.modalContent);
});
export const handleJobRescheduleUtil = (repeatInterval, repeatLimit, scheduleDate, selectedJob, handleRescheduleAction, driver, setRescheduleError) => __awaiter(void 0, void 0, void 0, function* () {
    const response = yield driver.rescheduleJob(selectedJob, repeatInterval, repeatLimit, scheduleDate);
    if (response && response.modalTitle === "success") {
        handleRescheduleAction();
    }
    else if (response && response.modalTitle === "failure") {
        setRescheduleError(response.modalContent);
    }
});
//# sourceMappingURL=Utils.js.map