var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import Moment from "react-moment";
import { Dropdown, KebabToggle, DropdownItem } from "@patternfly/react-core/dist/js/components/Dropdown";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { Stack } from "@patternfly/react-core/dist/js/layouts/Stack";
import { Text, TextContent, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Card, CardBody, CardHeader } from "@patternfly/react-core/dist/js/components/Card";
import { UserIcon } from "@patternfly/react-icons/dist/js/icons/user-icon";
import { CheckCircleIcon } from "@patternfly/react-icons/dist/js/icons/check-circle-icon";
import { ErrorCircleOIcon } from "@patternfly/react-icons/dist/js/icons/error-circle-o-icon";
import { OnRunningIcon } from "@patternfly/react-icons/dist/js/icons/on-running-icon";
import { OutlinedClockIcon } from "@patternfly/react-icons/dist/js/icons/outlined-clock-icon";
import React, { useCallback, useState } from "react";
import "../styles.css";
import { handleJobRescheduleUtil, handleNodeInstanceCancel, handleNodeInstanceRetrigger, handleRetry, handleSkip, jobCancel, } from "../../../utils/Utils";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { setTitle } from "@kie-tools/runtime-tools-components/dist/utils/Utils";
import { ProcessInfoModal } from "@kie-tools/runtime-tools-components/dist/components/ProcessInfoModal";
import { JobsDetailsModal } from "../../../../jobsManagement/envelope/components/JobsDetailsModal";
import { JobsRescheduleModal } from "../../../../jobsManagement/envelope/components/JobsRescheduleModal";
import { JobsCancelModal } from "../../../../jobsManagement/envelope/components/JobsCancelModal";
var TitleType;
(function (TitleType) {
    TitleType["SUCCESS"] = "success";
    TitleType["FAILURE"] = "failure";
})(TitleType || (TitleType = {}));
const ProcessDetailsTimelinePanel = ({ data, jobs, driver, omittedProcessTimelineEvents, ouiaId, ouiaSafe, }) => {
    const [kebabOpenArray, setKebabOpenArray] = useState([]);
    const [modalTitle, setModalTitle] = useState();
    const setCancelModalTitle = () => {
        return null;
    };
    const [modalContent, setModalContent] = useState("");
    const [isModalOpen, setIsModalOpen] = useState(false);
    const [isDetailsModalOpen, setIsDetailsModalOpen] = useState(false);
    const [isRescheduleModalOpen, setIsRescheduleModalOpen] = useState(false);
    const [isCancelModalOpen, setIsCancelModalOpen] = useState(false);
    const [selectedJob, setSelectedJob] = useState({});
    const ignoredNodeTypes = ["Join", "Split", "EndNode"];
    const editableJobStatus = ["SCHEDULED", "ERROR"];
    const [rescheduleError, setRescheduleError] = useState("");
    const onKebabToggle = (isOpen, id) => {
        if (isOpen) {
            setKebabOpenArray([...kebabOpenArray, id]);
        }
        else {
            onDropdownSelect(id);
        }
    };
    const onDropdownSelect = (id) => {
        const tempKebabArray = [...kebabOpenArray];
        const index = tempKebabArray.indexOf(id);
        tempKebabArray.splice(index, 1);
        setKebabOpenArray(tempKebabArray);
    };
    const handleModalToggle = () => {
        setIsModalOpen(!isModalOpen);
    };
    const handleJobDetailsModalToggle = () => {
        setIsDetailsModalOpen(!isDetailsModalOpen);
    };
    const onShowMessage = (title, content, type) => {
        setModalTitle(setTitle(type, title));
        setModalContent(content);
        handleModalToggle();
    };
    const handleJobDetails = (job) => {
        setSelectedJob(job);
        handleDetailsToggle();
    };
    const handleDetailsToggle = () => {
        setIsDetailsModalOpen(!isDetailsModalOpen);
    };
    const handleJobRescheduleBySelected = (job) => {
        setIsRescheduleModalOpen(!isRescheduleModalOpen);
        setSelectedJob(job);
    };
    const handleJobReschedule = (_job, repeatInterval, repeatLimit, scheduleDate) => __awaiter(void 0, void 0, void 0, function* () {
        yield handleJobRescheduleUtil(repeatInterval, repeatLimit, scheduleDate, selectedJob, handleRescheduleAction, driver, setRescheduleError);
    });
    const handleCancelAction = (job) => __awaiter(void 0, void 0, void 0, function* () {
        yield jobCancel(driver, job, setCancelModalTitle, setModalContent);
        handleCancelModalToggle();
    });
    const handleCancelModalToggle = () => {
        setIsCancelModalOpen(!isCancelModalOpen);
    };
    const renderJobActions = (id, options) => {
        if (jobs.length > 0) {
            return jobs.map((job) => {
                if (id === job.nodeInstanceId && editableJobStatus.includes(job.status)) {
                    return [
                        ...options,
                        React.createElement(DropdownItem, { key: "job-details", "data-testid": "job-details", id: "job-details", component: "button", onClick: () => handleJobDetails(job) }, "Job Details"),
                        React.createElement(DropdownItem, { key: "job-reschedule", "data-testid": "job-reschedule", id: "job-reschedule", component: "button", onClick: () => handleJobRescheduleBySelected(job) }, "Job Reschedule"),
                        React.createElement(DropdownItem, { key: "job-cancel", "data-testid": "job-cancel", id: "job-cancel", component: "button", onClick: () => handleCancelAction(job) }, "Job Cancel"),
                    ];
                }
                else if (id === job.nodeInstanceId && !editableJobStatus.includes(job.status)) {
                    return [
                        ...options,
                        React.createElement(DropdownItem, { key: "job-details", id: "job-details", component: "button", onClick: () => handleJobDetails(job) }, "Job Details"),
                    ];
                }
                else {
                    return [];
                }
            });
        }
        else {
            return options;
        }
    };
    const dropdownItems = (processInstanceData, node) => {
        if (processInstanceData.error && node.definitionId === processInstanceData.error.nodeDefinitionId) {
            const options = [
                React.createElement(DropdownItem, { "data-testid": "retry", key: "retry", component: "button", onClick: () => handleRetry(processInstanceData, driver, () => onShowMessage("Retry operation", `The node ${node.name} was successfully re-executed.`, TitleType.SUCCESS), (errorMessage) => onShowMessage("Retry operation", `The node ${node.name} failed to re-execute. Message: ${errorMessage}`, TitleType.FAILURE)) }, "Retry"),
                React.createElement(DropdownItem, { "data-testid": "skip", key: "skip", component: "button", onClick: () => handleSkip(processInstanceData, driver, () => onShowMessage("Skip operation", `The node ${node.name} was successfully skipped.`, TitleType.SUCCESS), (errorMessage) => onShowMessage("Skip operation", `The node ${node.name} failed to skip. Message: ${errorMessage}`, TitleType.FAILURE)) }, "Skip"),
            ];
            const items = renderJobActions(node.id, options);
            return items.flat();
        }
        else if (node.exit === null && !ignoredNodeTypes.includes(node.type)) {
            const options = [
                React.createElement(DropdownItem, { "data-testid": "retrigger", key: "retrigger", component: "button", onClick: () => handleNodeInstanceRetrigger(processInstanceData, driver, node, () => onShowMessage("Node retrigger operation", `The node ${node.name} was successfully retriggered.`, TitleType.SUCCESS), (errorMessage) => onShowMessage("Node retrigger operation", `The node ${node.name} failed to retrigger. Message: ${errorMessage}`, TitleType.FAILURE)) }, "Retrigger node"),
                React.createElement(DropdownItem, { "data-testid": "cancel", key: "cancel", component: "button", onClick: () => handleNodeInstanceCancel(processInstanceData, driver, node, () => onShowMessage("Node cancel operation", `The node ${node.name} was successfully canceled.`, TitleType.SUCCESS), (errorMessage) => onShowMessage("Node cancel operation", `The node ${node.name} failed to cancel. Message: ${errorMessage}`, TitleType.FAILURE)) }, "Cancel node"),
            ];
            const items = renderJobActions(node.id, options);
            return items.flat();
        }
        else {
            const items = renderJobActions(node.id, []);
            return items.flat();
        }
    };
    const processManagementKebabButtons = (node, index) => {
        var _a;
        const dropdownItemsValue = dropdownItems(data, node);
        if (((_a = data.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management")) &&
            data.serviceUrl !== null &&
            dropdownItemsValue &&
            dropdownItemsValue.length !== 0) {
            return (React.createElement(Dropdown, { onSelect: () => onDropdownSelect("timeline-kebab-toggle-" + index), toggle: React.createElement(KebabToggle, { onToggle: (isOpen) => onKebabToggle(isOpen, "timeline-kebab-toggle-" + index), id: "timeline-kebab-toggle-" + index, "data-testid": "timeline-kebab-toggle-" + index }), position: "right", isOpen: kebabOpenArray.includes("timeline-kebab-toggle-" + index), isPlain: true, dropdownItems: dropdownItemsValue }));
        }
    };
    const renderTimerIcon = (id) => {
        return jobs.length > 0 ? (jobs.map((job, idx) => {
            if (id === job.nodeInstanceId) {
                return (React.createElement(Tooltip, { content: "Node has job", key: idx },
                    React.createElement(OutlinedClockIcon, { className: "pf-u-ml-sm", color: "var(--pf-global--icon--Color--dark)", onClick: () => handleJobDetails(job) })));
            }
        })[0]) : (React.createElement(React.Fragment, null));
    };
    const detailsAction = [
        React.createElement(Button, { key: "confirm-selection", variant: "primary", onClick: handleModalToggle }, "OK"),
    ];
    const handleRescheduleAction = () => {
        setIsRescheduleModalOpen(!isRescheduleModalOpen);
    };
    const rescheduleActions = [
        React.createElement(Button, { key: "cancel-reschedule", variant: "secondary", onClick: handleRescheduleAction }, "Cancel"),
    ];
    const compareNodes = useCallback((nodeA, nodeB) => {
        if ((nodeA === null || nodeA === void 0 ? void 0 : nodeA.enter) < (nodeB === null || nodeB === void 0 ? void 0 : nodeB.enter)) {
            return -1;
        }
        else if ((nodeA === null || nodeA === void 0 ? void 0 : nodeA.enter) > (nodeB === null || nodeB === void 0 ? void 0 : nodeB.enter)) {
            return 1;
        }
        else if ((nodeA === null || nodeA === void 0 ? void 0 : nodeA.exit) < (nodeB === null || nodeB === void 0 ? void 0 : nodeB.exit)) {
            return -1;
        }
        else if ((nodeA === null || nodeA === void 0 ? void 0 : nodeA.exit) > (nodeB === null || nodeB === void 0 ? void 0 : nodeB.exit)) {
            return 1;
        }
        else if ((nodeA === null || nodeA === void 0 ? void 0 : nodeA.id) < (nodeB === null || nodeB === void 0 ? void 0 : nodeB.id)) {
            return -1;
        }
        else if ((nodeA === null || nodeA === void 0 ? void 0 : nodeA.id) > (nodeB === null || nodeB === void 0 ? void 0 : nodeB.id)) {
            return 1;
        }
        return 0;
    }, []);
    return (React.createElement(Card, Object.assign({}, componentOuiaProps(ouiaId ? ouiaId : data.id, "timeline", ouiaSafe)),
        React.createElement(ProcessInfoModal, { isModalOpen: isModalOpen, handleModalToggle: handleModalToggle, modalTitle: modalTitle, modalContent: modalContent }),
        React.createElement(CardHeader, null,
            React.createElement(Title, { headingLevel: "h3", size: "xl" }, "Timeline")),
        React.createElement(CardBody, null,
            React.createElement(Stack, { hasGutter: true, className: "kogito-process-details--timeline" }, data.nodes &&
                data.nodes
                    .filter((content) => !(omittedProcessTimelineEvents === null || omittedProcessTimelineEvents === void 0 ? void 0 : omittedProcessTimelineEvents.includes(content.name)))
                    .sort(compareNodes)
                    .map((content, idx) => {
                    return (React.createElement(Split, { hasGutter: true, className: "kogito-process-details--timeline-item", key: content.id },
                        React.createElement(SplitItem, null, React.createElement(React.Fragment, null, data.error && content.definitionId === data.error.nodeDefinitionId ? (React.createElement(Tooltip, { content: data.error.message },
                            React.createElement(ErrorCircleOIcon, { color: "var(--pf-global--danger-color--100)", className: "kogito-process-details--timeline-status" }))) : content.exit === null ? (React.createElement(Tooltip, { content: "Active" },
                            React.createElement(OnRunningIcon, { className: "kogito-process-details--timeline-status" }))) : (React.createElement(Tooltip, { content: "Completed" },
                            React.createElement(CheckCircleIcon, { color: "var(--pf-global--success-color--100)", className: "kogito-process-details--timeline-status" }))))),
                        React.createElement(SplitItem, { isFilled: true },
                            React.createElement(TextContent, null,
                                React.createElement(Text, { component: TextVariants.p },
                                    content.name,
                                    React.createElement("span", null,
                                        content.type === "HumanTaskNode" && (React.createElement(Tooltip, { content: "Human task" },
                                            React.createElement(UserIcon, { className: "pf-u-ml-sm", color: "var(--pf-global--icon--Color--light)" }))),
                                        renderTimerIcon(content.id)),
                                    React.createElement(Text, { component: TextVariants.small }, content.exit === null ? "Active" : React.createElement(Moment, { fromNow: true }, new Date(`${content.exit}`)))))),
                        React.createElement(SplitItem, null, processManagementKebabButtons(content, idx))));
                }))),
        React.createElement(JobsDetailsModal, { actionType: "Job Details", modalTitle: setTitle("success", "Job Details"), isModalOpen: isDetailsModalOpen, handleModalToggle: handleJobDetailsModalToggle, modalAction: detailsAction, job: selectedJob }),
        Object.keys(selectedJob).length > 0 && (React.createElement(JobsRescheduleModal, { actionType: "Job Reschedule", isModalOpen: isRescheduleModalOpen, handleModalToggle: handleRescheduleAction, modalAction: rescheduleActions, job: selectedJob, rescheduleError: rescheduleError, setRescheduleError: setRescheduleError, handleJobReschedule: handleJobReschedule })),
        React.createElement(JobsCancelModal, { actionType: "Job Cancel", isModalOpen: isCancelModalOpen, handleModalToggle: handleCancelModalToggle, modalTitle: modalTitle, modalContent: modalContent })));
};
export default ProcessDetailsTimelinePanel;
//# sourceMappingURL=ProcessDetailsTimelinePanel.js.map