import React from "react";
import { PlayIcon } from "@patternfly/react-icons/dist/js/icons/play-icon";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
export const getColumn = (columnPath, columnLabel) => {
    return {
        label: columnLabel,
        path: columnPath,
        bodyCellTransformer: (value) => React.createElement("span", null, value),
    };
};
export const getActionColumn = (startProcess, singularProcessLabel) => {
    return {
        label: "Actions",
        path: "actions",
        bodyCellTransformer: (value, rowData) => (React.createElement(Tooltip, { content: `Start new ${singularProcessLabel.toLowerCase()}` },
            React.createElement(Button, { onClick: () => startProcess(rowData), variant: "link" },
                React.createElement(PlayIcon, null)))),
    };
};
//# sourceMappingURL=ProcessDefinitionListUtils.js.map