var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React, { useEffect, useState } from "react";
import { getActionColumn, getColumn } from "../utils/ProcessDefinitionListUtils";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import ProcessDefinitionListToolbar from "../ProcessDefinitionListToolbar/ProcessDefinitionListToolbar";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { DataTable } from "@kie-tools/runtime-tools-components/dist/components/DataTable";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { ServerErrors } from "@kie-tools/runtime-tools-components/dist/components/ServerErrors";
const ProcessDefinitionList = ({ isEnvelopeConnectedToChannel, driver, singularProcessLabel, isTriggerCloudEventEnabled = false, ouiaId, ouiaSafe, }) => {
    const [processDefinitionList, setProcessDefinitionList] = useState([]);
    const [isLoading, setIsLoading] = useState(true);
    const [filterProcessNames, setFilterProcessNames] = useState([]);
    const [error, setError] = useState();
    useEffect(() => {
        if (!isEnvelopeConnectedToChannel) {
            setIsLoading(true);
            return;
        }
        init();
        return () => {
            setFilterProcessNames([]);
        };
    }, [isEnvelopeConnectedToChannel]);
    const init = () => __awaiter(void 0, void 0, void 0, function* () {
        try {
            const response = yield driver.getProcessDefinitionsQuery();
            const pdFilter = yield driver.getProcessDefinitionFilter();
            setFilterProcessNames(pdFilter);
            setProcessDefinitionList(response);
            setIsLoading(false);
        }
        catch (errorContent) {
            setError(errorContent);
        }
    });
    const columns = [
        getColumn("processName", `${singularProcessLabel} Name`),
        getColumn("endpoint", "Endpoint"),
        getActionColumn((processDefinition) => {
            driver.openProcessForm(processDefinition);
        }, singularProcessLabel),
    ];
    const applyFilter = () => __awaiter(void 0, void 0, void 0, function* () {
        yield driver.setProcessDefinitionFilter(filterProcessNames);
    });
    const filterProcessDefinition = () => {
        if (filterProcessNames.length === 0) {
            return processDefinitionList;
        }
        return processDefinitionList.filter((pd) => filterProcessNames.includes(pd.processName));
    };
    const processDefinitionLoadingComponent = (React.createElement(Bullseye, null,
        React.createElement(KogitoSpinner, { spinnerText: `Loading ${singularProcessLabel.toLowerCase()} definitions...`, ouiaId: "forms-list-loading-process-definitions" })));
    if (error) {
        return React.createElement(ServerErrors, { error: error, variant: "large" });
    }
    return (React.createElement("div", Object.assign({}, componentOuiaProps(ouiaId, "process-definition-list", ouiaSafe ? ouiaSafe : !isLoading)),
        React.createElement(ProcessDefinitionListToolbar, { filterProcessNames: filterProcessNames, setFilterProcessNames: setFilterProcessNames, applyFilter: applyFilter, singularProcessLabel: singularProcessLabel }),
        React.createElement(Divider, null),
        React.createElement(DataTable, { data: filterProcessDefinition(), isLoading: isLoading, columns: columns, error: false, LoadingComponent: processDefinitionLoadingComponent })));
};
export default ProcessDefinitionList;
//# sourceMappingURL=ProcessDefinitionList.js.map