var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React, { useState, useEffect } from "react";
import { DropdownItem, Dropdown, KebabToggle } from "@patternfly/react-core/dist/js/components/Dropdown";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Select, SelectOption, SelectVariant } from "@patternfly/react-core/dist/js/components/Select";
import { Toolbar, ToolbarContent, ToolbarFilter, ToolbarGroup, ToolbarItem, } from "@patternfly/react-core/dist/js/components/Toolbar";
import { OverflowMenu, OverflowMenuContent, OverflowMenuItem, OverflowMenuControl, } from "@patternfly/react-core/dist/js/components/OverflowMenu";
import { SyncIcon } from "@patternfly/react-icons/dist/js/icons/sync-icon";
import "../styles.css";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { OperationType } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
const JobsManagementToolbar = ({ chips, driver, doQueryJobs, onResetToDefault, jobOperations, onRefresh, selectedStatus, selectedJobInstances, setChips, setDisplayTable, setIsLoading, setSelectedStatus, setSelectedJobInstances, ouiaId, ouiaSafe, }) => {
    const [isExpanded, setIsExpanded] = useState(false);
    const [chipRemoved, setChipRemoved] = useState(false);
    const [isKebabOpen, setIsKebabOpen] = useState(false);
    const statusMenuItems = [
        React.createElement(SelectOption, { key: "CANCELED", value: "CANCELED" }),
        React.createElement(SelectOption, { key: "ERROR", value: "ERROR" }),
        React.createElement(SelectOption, { key: "EXECUTED", value: "EXECUTED" }),
        React.createElement(SelectOption, { key: "RETRY", value: "RETRY" }),
        React.createElement(SelectOption, { key: "SCHEDULED", value: "SCHEDULED" }),
    ];
    const onStatusToggle = () => {
        setIsExpanded(!isExpanded);
    };
    const filterData = () => __awaiter(void 0, void 0, void 0, function* () {
        yield driver.applyFilter(selectedStatus);
        doQueryJobs(0, 10);
        setChipRemoved(false);
    });
    const onApplyFilter = () => __awaiter(void 0, void 0, void 0, function* () {
        setChips(selectedStatus);
        setIsLoading(true);
        filterData();
    });
    const onDelete = (type, id) => {
        const chipsCopy = [...chips];
        const tempChips = chipsCopy.filter((item) => item !== id);
        setSelectedJobInstances([]);
        let selectedStatusCopy = [...selectedStatus];
        setChips(tempChips);
        selectedStatusCopy = selectedStatusCopy.filter((item) => item !== id);
        setSelectedStatus(selectedStatusCopy);
        if (tempChips.length > 0) {
            setIsLoading(true);
            setChipRemoved(true);
        }
        else {
            setDisplayTable(false);
        }
    };
    const onSelect = (event, selection) => {
        let selectionText = event.target.id;
        selectionText = selectionText.split("pf-random-id-")[1].split("-")[1];
        let selectedStatusCopy = [...selectedStatus];
        if (selectedStatus.includes(selectionText)) {
            selectedStatusCopy = selectedStatusCopy.filter((item) => item !== selectionText);
            setSelectedStatus(selectedStatusCopy);
        }
        else {
            selectedStatusCopy = [...selectedStatusCopy, selectionText];
            setSelectedStatus(selectedStatusCopy);
        }
    };
    const cancelJobsOptionSelect = () => {
        setIsKebabOpen(!isKebabOpen);
    };
    const cancelJobsKebabToggle = (isOpen) => {
        setIsKebabOpen(isOpen);
    };
    const dropdownItemsCancelJobsButtons = () => {
        return [
            React.createElement(DropdownItem, { key: "cancel", onClick: jobOperations[OperationType.CANCEL].functions.perform, isDisabled: selectedJobInstances.length === 0 }, "Cancel selected"),
        ];
    };
    const cancelJobsOption = (React.createElement(OverflowMenu, { breakpoint: "xl" },
        React.createElement(OverflowMenuContent, null,
            React.createElement(OverflowMenuItem, null,
                React.createElement(Button, { variant: "secondary", onClick: jobOperations[OperationType.CANCEL].functions.perform, isDisabled: selectedJobInstances.length === 0 }, "Cancel selected"))),
        React.createElement(OverflowMenuControl, null,
            React.createElement(Dropdown, { onSelect: cancelJobsOptionSelect, toggle: React.createElement(KebabToggle, { onToggle: cancelJobsKebabToggle }), isOpen: isKebabOpen, isPlain: true, dropdownItems: dropdownItemsCancelJobsButtons() }))));
    useEffect(() => {
        if (chipRemoved) {
            filterData();
        }
    }, [chipRemoved]);
    return (React.createElement(Toolbar, { id: "data-toolbar-with-chip-groups", className: "pf-m-toggle-group-container", collapseListedFiltersBreakpoint: "md", clearAllFilters: () => {
            onResetToDefault();
        }, clearFiltersButtonText: "Reset to default" },
        React.createElement(ToolbarContent, null,
            React.createElement(ToolbarGroup, Object.assign({ variant: "filter-group" }, componentOuiaProps(ouiaId, "job-filters", ouiaSafe)),
                React.createElement(ToolbarFilter, { chips: chips, deleteChip: onDelete, categoryName: "Status", className: "kogito-jobs-management__state-dropdown-list" },
                    React.createElement(Select, { variant: SelectVariant.checkbox, "aria-label": "Status", onToggle: onStatusToggle, onSelect: onSelect, selections: selectedStatus, isOpen: isExpanded, placeholderText: "Status", id: "status-select" }, statusMenuItems))),
            React.createElement(ToolbarGroup, Object.assign({}, componentOuiaProps(ouiaId, "job-filters/button", ouiaSafe)),
                React.createElement(ToolbarItem, null,
                    React.createElement(Button, { variant: "primary", onClick: onApplyFilter, id: "apply-filter", isDisabled: !(selectedStatus.length > 0) }, "Apply Filter"))),
            React.createElement(ToolbarGroup, null,
                React.createElement(ToolbarItem, null,
                    React.createElement(Button, { variant: "plain", onClick: () => {
                            onRefresh();
                            setSelectedJobInstances([]);
                        }, id: "refresh-button", ouiaId: "refresh-button", "aria-label": "Refresh list" },
                        React.createElement(SyncIcon, null)))),
            React.createElement(ToolbarItem, { variant: "separator" }),
            React.createElement(ToolbarGroup, { className: "pf-u-ml-md", id: "jobs-management-buttons" }, cancelJobsOption))));
};
export default JobsManagementToolbar;
//# sourceMappingURL=JobsManagementToolbar.js.map