import { GwtEditorWrapper } from "@kie-tools/kie-bc-editors/dist/common";
import { StunnerCanvas, StunnerNode, StunnerSession } from "../api/StunnerAPI";
export interface ServerlessWorkflowDiagramEditor extends GwtEditorWrapper, StunnerCanvas, StunnerSession {
    myServerlessWorkflowDiagramMethod(): string;
}
export declare class ServerlessWorkflowDiagramEditorImpl extends GwtEditorWrapper implements ServerlessWorkflowDiagramEditor {
    myServerlessWorkflowDiagramMethod(): string;
    getGraph(): import("../api/StunnerAPI").StunnerGraph;
    getEdgeByUUID(uuid: string): import("../api/StunnerAPI").StunnerEdge;
    getNodeByUUID(uuid: string): StunnerNode;
    getDefinitionByElementUUID(uuid: string): Object;
    getNodeByName(name: string): StunnerNode;
    getNodeName(node: StunnerNode): string;
    getDefinitionId(bean: Object): string;
    getDefinitionName(bean: Object): string;
    getSelectedElementUUID(): string;
    getSelectedNode(): StunnerNode;
    getSelectedEdge(): import("../api/StunnerAPI").StunnerEdge;
    getSelectedDefinition(): Object;
    selectByUUID(uuid: string): void;
    selectByName(name: string): void;
    clearSelection(): void;
    getShapeIds(): string[];
    getBackgroundColor(uuid: string): string;
    setBackgroundColor(uuid: string, backgroundColor: string): void;
    getBorderColor(uuid: string): string;
    setBorderColor(uuid: string, borderColor: string): void;
    getLocation(uuid: string): number[];
    getAbsoluteLocation(uuid: string): number[];
    getDimensions(uuid: string): number[];
    center(uuid: string): void;
    draw(): void;
}
//# sourceMappingURL=ServerlessWorkflowDiagramEditor.d.ts.map