"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useSwfDiagramEditorChannelApi = void 0;
var channel_1 = require("@kie-tools-core/editor/dist/channel");
var embedded_1 = require("@kie-tools-core/editor/dist/embedded");
var react_1 = require("react");
var ServerlessWorkflowDiagramEditorChannelApiImpl_1 = require("../../channel/ServerlessWorkflowDiagramEditorChannelApiImpl");
function useSwfDiagramEditorChannelApi(args) {
    var _a;
    var stateControl = (0, react_1.useMemo)(function () { return new channel_1.StateControl(); }, [(_a = args.embeddedEditorFile) === null || _a === void 0 ? void 0 : _a.getFileContents]);
    var channelApiImpl = (0, react_1.useMemo)(function () {
        return args.embeddedEditorFile &&
            new embedded_1.EmbeddedEditorChannelApiImpl(stateControl, args.embeddedEditorFile, args.locale, {
                kogitoEditor_ready: function () {
                    args.onEditorReady();
                },
            });
    }, [args, stateControl]);
    var channelApi = (0, react_1.useMemo)(function () {
        return args.channelApi &&
            channelApiImpl &&
            args.swfTextEditorEnvelopeApi &&
            new ServerlessWorkflowDiagramEditorChannelApiImpl_1.ServerlessWorkflowDiagramEditorChannelApiImpl({
                defaultApiImpl: channelApiImpl,
                textEditorEnvelopeApi: args.swfTextEditorEnvelopeApi,
            });
    }, [args.channelApi, channelApiImpl, args.swfTextEditorEnvelopeApi]);
    return {
        stateControl: stateControl,
        channelApi: channelApi,
    };
}
exports.useSwfDiagramEditorChannelApi = useSwfDiagramEditorChannelApi;
//# sourceMappingURL=useSwfDiagramEditorChannelApi.js.map