import { jsx as _jsx } from "react/jsx-runtime";
import { useCallback, useMemo } from "react";
import _, { isNumber } from "lodash";
import { v4 as uuid } from "uuid";
import { BeeTableHeaderVisibility, BeeTableOperation, InsertRowColumnsDirection, } from "@kie-tools/boxed-expression-component/dist/api/BeeTable";
import { ResizerStopBehavior } from "@kie-tools/boxed-expression-component/dist/resizing/ResizingWidthsContext";
import { StandaloneBeeTable, getColumnsAtLastLevel, } from "@kie-tools/boxed-expression-component/dist/table/BeeTable";
import { useTestScenarioEditorI18n } from "../i18n";
import { TestScenarioType } from "../TestScenarioEditor";
import "./TestScenarioTable.css";
import { retrieveFactMappingValueIndexByIdentifiers, retrieveModelDescriptor, retrieveRowsDataFromModel, } from "../common/TestScenarioCommonFunctions";
function TestScenarioTable({ assetType, tableData, scrollableParentRef, updateSelectedColumnMetaData, updateTestScenarioModel, }) {
    let TestScenarioTableColumnHeaderGroup;
    (function (TestScenarioTableColumnHeaderGroup) {
        TestScenarioTableColumnHeaderGroup["EXPECT"] = "expect-header";
        TestScenarioTableColumnHeaderGroup["GIVEN"] = "given-header";
    })(TestScenarioTableColumnHeaderGroup || (TestScenarioTableColumnHeaderGroup = {}));
    let TestScenarioTableColumnInstanceGroup;
    (function (TestScenarioTableColumnInstanceGroup) {
        TestScenarioTableColumnInstanceGroup["EXPECT"] = "expect-instance";
        TestScenarioTableColumnInstanceGroup["GIVEN"] = "given-instance";
    })(TestScenarioTableColumnInstanceGroup || (TestScenarioTableColumnInstanceGroup = {}));
    let TestScenarioTableColumnFieldGroup;
    (function (TestScenarioTableColumnFieldGroup) {
        TestScenarioTableColumnFieldGroup["EXPECT"] = "expect";
        TestScenarioTableColumnFieldGroup["GIVEN"] = "given";
        TestScenarioTableColumnFieldGroup["OTHER"] = "other";
    })(TestScenarioTableColumnFieldGroup || (TestScenarioTableColumnFieldGroup = {}));
    const { i18n } = useTestScenarioEditorI18n();
    const isBackground = useMemo(() => {
        return "BackgroundData" in tableData.scesimData;
    }, [tableData]);
    const columnIndexStart = useMemo(() => {
        return isBackground ? 0 : 1;
    }, [isBackground]);
    const retrieveRowsData = useCallback((rowData) => {
        if (isBackground) {
            return rowData.BackgroundData;
        }
        else {
            return rowData.Scenario;
        }
    }, [isBackground]);
    const determineDataTypeLabel = useCallback((dataType) => {
        var _a;
        let dataTypeLabel = dataType;
        if (assetType === TestScenarioType[TestScenarioType.RULE]) {
            dataTypeLabel = (_a = dataTypeLabel.split(".").pop()) !== null && _a !== void 0 ? _a : dataTypeLabel;
        }
        return dataTypeLabel.endsWith("Void") ? "<Undefined>" : dataTypeLabel;
    }, [assetType]);
    const setColumnWidth = useCallback((inputIndex) => (newWidthAction) => {
        updateTestScenarioModel((prevState) => {
            var _a, _b;
            const oldWidth = (_a = retrieveModelDescriptor(prevState.ScenarioSimulationModel, isBackground).factMappings
                .FactMapping[inputIndex].columnWidth) === null || _a === void 0 ? void 0 : _a.__$$text;
            const newWidth = typeof newWidthAction === "function" ? newWidthAction(oldWidth) : newWidthAction;
            let model = prevState;
            if (newWidth && oldWidth !== newWidth) {
                const deepClonedFactMappings = JSON.parse(JSON.stringify(retrieveModelDescriptor(prevState.ScenarioSimulationModel, isBackground).factMappings.FactMapping));
                const factMappingToUpdate = deepClonedFactMappings[inputIndex];
                if ((_b = factMappingToUpdate.columnWidth) === null || _b === void 0 ? void 0 : _b.__$$text) {
                    factMappingToUpdate.columnWidth.__$$text = newWidth;
                }
                else {
                    factMappingToUpdate.columnWidth = {
                        __$$text: newWidth,
                    };
                }
                model = {
                    ScenarioSimulationModel: Object.assign(Object.assign({}, prevState.ScenarioSimulationModel), { simulation: Object.assign(Object.assign({}, prevState.ScenarioSimulationModel.simulation), { scesimModelDescriptor: {
                                factMappings: {
                                    FactMapping: isBackground
                                        ? prevState.ScenarioSimulationModel.simulation.scesimModelDescriptor.factMappings.FactMapping
                                        : deepClonedFactMappings,
                                },
                            } }), background: Object.assign(Object.assign({}, prevState.ScenarioSimulationModel.background), { scesimModelDescriptor: {
                                factMappings: {
                                    FactMapping: isBackground
                                        ? deepClonedFactMappings
                                        : prevState.ScenarioSimulationModel.background.scesimModelDescriptor.factMappings.FactMapping,
                                },
                            } }) }),
                };
            }
            return model;
        });
    }, [isBackground, updateTestScenarioModel]);
    const generateColumnFromFactMapping = useCallback((factMapping, factMappingIndex, isDescriptionColumn) => {
        var _a, _b, _c, _d;
        return {
            accessor: factMapping.expressionIdentifier.name.__$$text,
            dataType: isDescriptionColumn || ((_a = factMapping.factMappingValueType) === null || _a === void 0 ? void 0 : _a.__$$text) === "EXPRESSION"
                ? undefined
                : determineDataTypeLabel(factMapping.className.__$$text),
            groupType: factMapping.expressionIdentifier.type.__$$text.toLowerCase(),
            id: factMapping.expressionIdentifier.name.__$$text,
            isRowIndexColumn: false,
            label: isDescriptionColumn ? factMapping.factAlias.__$$text : factMapping.expressionAlias.__$$text,
            minWidth: isDescriptionColumn ? 300 : 100,
            setWidth: setColumnWidth(factMappingIndex),
            width: (_c = (_b = factMapping.columnWidth) === null || _b === void 0 ? void 0 : _b.__$$text) !== null && _c !== void 0 ? _c : (isDescriptionColumn ? 300 : (_d = factMapping.columnWidth) === null || _d === void 0 ? void 0 : _d.__$$text),
        };
    }, [determineDataTypeLabel, setColumnWidth]);
    const generateInstanceSectionFromFactMapping = useCallback((factMapping, groupType) => {
        var _a;
        const instanceID = ((_a = factMapping.expressionIdentifier.type) === null || _a === void 0 ? void 0 : _a.__$$text) + "." + factMapping.factIdentifier.name.__$$text;
        return {
            accessor: instanceID,
            dataType: determineDataTypeLabel(factMapping.factIdentifier.className.__$$text),
            groupType: groupType.toLowerCase(),
            id: instanceID,
            isRowIndexColumn: false,
            label: factMapping.factAlias.__$$text,
            columns: [],
        };
    }, [determineDataTypeLabel]);
    const tableColumns = useMemo(() => {
        var _a;
        const descriptionColumns = [];
        const givenInstances = [];
        const expectInstances = [];
        ((_a = tableData.scesimModelDescriptor.factMappings.FactMapping) !== null && _a !== void 0 ? _a : []).forEach((factMapping, index) => {
            var _a, _b, _c, _d;
            const instanceID = ((_a = factMapping.expressionIdentifier.type) === null || _a === void 0 ? void 0 : _a.__$$text) + "." + factMapping.factIdentifier.name.__$$text;
            if (((_b = factMapping.expressionIdentifier.type) === null || _b === void 0 ? void 0 : _b.__$$text) === TestScenarioTableColumnFieldGroup.GIVEN.toUpperCase()) {
                const instance = givenInstances.find((instanceColumn) => instanceColumn.id === instanceID);
                if (instance) {
                    (_c = instance.columns) === null || _c === void 0 ? void 0 : _c.push(generateColumnFromFactMapping(factMapping, index));
                }
                else {
                    const newInstance = generateInstanceSectionFromFactMapping(factMapping, TestScenarioTableColumnInstanceGroup.GIVEN);
                    newInstance.columns.push(generateColumnFromFactMapping(factMapping, index));
                    givenInstances.push(newInstance);
                }
            }
            else if (factMapping.expressionIdentifier.type.__$$text === TestScenarioTableColumnFieldGroup.EXPECT.toUpperCase()) {
                const instance = expectInstances.find((instanceColumn) => instanceColumn.id === instanceID);
                if (instance) {
                    (_d = instance.columns) === null || _d === void 0 ? void 0 : _d.push(generateColumnFromFactMapping(factMapping, index));
                }
                else {
                    const newInstance = generateInstanceSectionFromFactMapping(factMapping, TestScenarioTableColumnInstanceGroup.EXPECT);
                    newInstance.columns.push(generateColumnFromFactMapping(factMapping, index));
                    expectInstances.push(newInstance);
                }
            }
            else if (factMapping.expressionIdentifier.type.__$$text === TestScenarioTableColumnFieldGroup.OTHER.toUpperCase() &&
                factMapping.expressionIdentifier.name.__$$text === "Description") {
                descriptionColumns.push(generateColumnFromFactMapping(factMapping, index, true));
            }
        });
        const givenSection = [
            {
                accessor: TestScenarioTableColumnHeaderGroup.GIVEN,
                groupType: TestScenarioTableColumnHeaderGroup.GIVEN,
                id: TestScenarioTableColumnHeaderGroup.GIVEN,
                isRowIndexColumn: false,
                label: i18n.table.given.toUpperCase(),
                columns: givenInstances,
            },
        ];
        const expectSection = expectInstances.length > 0
            ? [
                {
                    accessor: TestScenarioTableColumnHeaderGroup.EXPECT,
                    groupType: TestScenarioTableColumnHeaderGroup.EXPECT,
                    id: TestScenarioTableColumnHeaderGroup.EXPECT,
                    isRowIndexColumn: false,
                    label: i18n.table.expect.toUpperCase(),
                    columns: expectInstances,
                },
            ]
            : [];
        return {
            allColumns: [...descriptionColumns, ...givenSection, ...expectSection],
            instancesGroup: [...givenInstances, ...expectInstances],
        };
    }, [
        generateColumnFromFactMapping,
        generateInstanceSectionFromFactMapping,
        i18n,
        TestScenarioTableColumnHeaderGroup,
        TestScenarioTableColumnFieldGroup,
        TestScenarioTableColumnInstanceGroup,
        tableData.scesimModelDescriptor.factMappings.FactMapping,
    ]);
    const tableRows = useMemo(() => {
        var _a;
        return ((_a = retrieveRowsData(tableData.scesimData)) !== null && _a !== void 0 ? _a : []).map((scenario, index) => {
            var _a;
            const factMappingValues = (_a = scenario.factMappingValues.FactMappingValue) !== null && _a !== void 0 ? _a : [];
            const tableRow = getColumnsAtLastLevel(tableColumns.allColumns, 2).reduce((tableRow, column) => {
                var _a, _b, _c;
                const factMappingValue = factMappingValues.filter((fmv) => fmv.expressionIdentifier.name.__$$text === column.accessor);
                tableRow[column.accessor] = (_c = (_b = (_a = factMappingValue[0]) === null || _a === void 0 ? void 0 : _a.rawValue) === null || _b === void 0 ? void 0 : _b.__$$text) !== null && _c !== void 0 ? _c : "";
                return tableRow;
            }, { id: index });
            return tableRow;
        });
    }, [retrieveRowsData, tableColumns.allColumns, tableData.scesimData]);
    const allowedOperations = useCallback((conditions) => {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j;
        const isHeader = ((_a = conditions.column) === null || _a === void 0 ? void 0 : _a.groupType) === TestScenarioTableColumnHeaderGroup.EXPECT ||
            ((_b = conditions.column) === null || _b === void 0 ? void 0 : _b.groupType) === TestScenarioTableColumnHeaderGroup.GIVEN;
        const isInstance = ((_c = conditions.column) === null || _c === void 0 ? void 0 : _c.groupType) === TestScenarioTableColumnInstanceGroup.EXPECT ||
            ((_d = conditions.column) === null || _d === void 0 ? void 0 : _d.groupType) === TestScenarioTableColumnInstanceGroup.GIVEN;
        if (!conditions.selection.selectionStart || !conditions.selection.selectionEnd || isHeader) {
            return [];
        }
        const columnIndex = conditions.selection.selectionStart.columnIndex;
        const groupType = (_e = conditions.column) === null || _e === void 0 ? void 0 : _e.groupType;
        const atLeastTwoColumnsOfTheSameGroupType = groupType
            ? _.groupBy(conditions.columns, (column) => column === null || column === void 0 ? void 0 : column.groupType)[groupType].length > 1
            : true;
        const columnCanBeDeleted = columnIndex > 0 &&
            atLeastTwoColumnsOfTheSameGroupType &&
            ((isBackground && ((_g = (_f = conditions.columns) === null || _f === void 0 ? void 0 : _f.length) !== null && _g !== void 0 ? _g : 0) > 1) ||
                (!isBackground && columnIndex > 0 && ((_j = (_h = conditions.columns) === null || _h === void 0 ? void 0 : _h.length) !== null && _j !== void 0 ? _j : 0) > 4));
        const columnsWithNoOperations = isBackground ? [0] : [0, 1];
        const columnOperations = (isInstance ? columnIndex in [0] : columnIndex in columnsWithNoOperations)
            ? []
            : [
                BeeTableOperation.ColumnInsertLeft,
                BeeTableOperation.ColumnInsertRight,
                BeeTableOperation.ColumnInsertN,
                ...(columnCanBeDeleted ? [BeeTableOperation.ColumnDelete] : []),
            ];
        return [
            ...(columnIndex >= 0 && conditions.selection.selectionStart.rowIndex < 0 ? columnOperations : []),
            ...(conditions.selection.selectionStart.rowIndex >= 0 && columnIndex > 0
                ? [
                    BeeTableOperation.SelectionCopy,
                    BeeTableOperation.SelectionCut,
                    BeeTableOperation.SelectionPaste,
                    BeeTableOperation.SelectionReset,
                ]
                : []),
            ...(conditions.selection.selectionStart.rowIndex >= 0 && !isBackground
                ? [
                    BeeTableOperation.RowInsertAbove,
                    BeeTableOperation.RowInsertBelow,
                    BeeTableOperation.RowInsertN,
                    ...(tableRows.length > 1 ? [BeeTableOperation.RowDelete] : []),
                    BeeTableOperation.RowReset,
                    BeeTableOperation.RowDuplicate,
                ]
                : []),
        ];
    }, [isBackground, TestScenarioTableColumnHeaderGroup, TestScenarioTableColumnInstanceGroup, tableRows.length]);
    const generateOperationConfig = useCallback((groupName) => {
        const isInstance = groupName === TestScenarioTableColumnInstanceGroup.EXPECT ||
            groupName === TestScenarioTableColumnInstanceGroup.GIVEN;
        const groupLabel = (!isInstance ? i18n.table.field : i18n.table.instance).toUpperCase();
        return [
            {
                group: groupLabel,
                items: [
                    {
                        name: isInstance ? i18n.table.insertLeftInstance : i18n.table.insertLeftField,
                        type: BeeTableOperation.ColumnInsertLeft,
                    },
                    {
                        name: isInstance ? i18n.table.insertRightInstance : i18n.table.insertRightField,
                        type: BeeTableOperation.ColumnInsertRight,
                    },
                    { name: i18n.table.insert, type: BeeTableOperation.ColumnInsertN },
                    {
                        name: isInstance ? i18n.table.deleteInstance : i18n.table.deleteField,
                        type: BeeTableOperation.ColumnDelete,
                    },
                ],
            },
            {
                group: i18n.table.simulation.singleEntry.toUpperCase(),
                items: [
                    { name: i18n.table.insertAbove, type: BeeTableOperation.RowInsertAbove },
                    { name: i18n.table.insertBelow, type: BeeTableOperation.RowInsertBelow },
                    { name: i18n.table.insert, type: BeeTableOperation.RowInsertN },
                    { name: i18n.table.delete, type: BeeTableOperation.RowDelete },
                    { name: i18n.table.duplicate, type: BeeTableOperation.RowDuplicate },
                ],
            },
            {
                group: i18n.table.selection.toUpperCase(),
                items: [
                    { name: i18n.table.copy, type: BeeTableOperation.SelectionCopy },
                    { name: i18n.table.cut, type: BeeTableOperation.SelectionCut },
                    { name: i18n.table.paste, type: BeeTableOperation.SelectionPaste },
                    { name: i18n.table.reset, type: BeeTableOperation.SelectionReset },
                ],
            },
        ];
    }, [TestScenarioTableColumnInstanceGroup, i18n]);
    const simulationOperationConfig = useMemo(() => {
        const config = {};
        config[""] = generateOperationConfig("");
        config[TestScenarioTableColumnHeaderGroup.EXPECT] = generateOperationConfig("");
        config[TestScenarioTableColumnHeaderGroup.GIVEN] = generateOperationConfig("");
        config[TestScenarioTableColumnInstanceGroup.EXPECT] = generateOperationConfig(TestScenarioTableColumnInstanceGroup.EXPECT);
        config[TestScenarioTableColumnInstanceGroup.GIVEN] = generateOperationConfig(TestScenarioTableColumnInstanceGroup.GIVEN);
        config[TestScenarioTableColumnFieldGroup.EXPECT] = generateOperationConfig(TestScenarioTableColumnFieldGroup.EXPECT);
        config[TestScenarioTableColumnFieldGroup.GIVEN] = generateOperationConfig(TestScenarioTableColumnFieldGroup.GIVEN);
        config[TestScenarioTableColumnFieldGroup.OTHER] = generateOperationConfig(TestScenarioTableColumnFieldGroup.OTHER);
        return config;
    }, [
        TestScenarioTableColumnFieldGroup,
        TestScenarioTableColumnHeaderGroup,
        TestScenarioTableColumnInstanceGroup,
        generateOperationConfig,
    ]);
    const onCellUpdates = useCallback((cellUpdates) => {
        cellUpdates.forEach((update) => {
            updateTestScenarioModel((prevState) => {
                const factMapping = retrieveModelDescriptor(prevState.ScenarioSimulationModel, isBackground).factMappings
                    .FactMapping[update.columnIndex + columnIndexStart];
                const deepClonedRowsData = JSON.parse(JSON.stringify(retrieveRowsDataFromModel(prevState.ScenarioSimulationModel, isBackground)));
                const factMappingValues = deepClonedRowsData[update.rowIndex].factMappingValues.FactMappingValue;
                const newFactMappingValues = [...factMappingValues];
                const factMappingValueToUpdateIndex = retrieveFactMappingValueIndexByIdentifiers(newFactMappingValues, factMapping.factIdentifier, factMapping.expressionIdentifier);
                const factMappingValueToUpdate = factMappingValues[factMappingValueToUpdateIndex];
                if (factMappingValueToUpdate.rawValue) {
                    factMappingValueToUpdate.rawValue.__$$text = update.value;
                }
                else {
                    newFactMappingValues[factMappingValueToUpdateIndex] = Object.assign(Object.assign({}, factMappingValueToUpdate), { rawValue: {
                            __$$text: update.value,
                        } });
                }
                deepClonedRowsData[update.rowIndex].factMappingValues.FactMappingValue = newFactMappingValues;
                return {
                    ScenarioSimulationModel: Object.assign(Object.assign({}, prevState.ScenarioSimulationModel), { simulation: Object.assign(Object.assign({}, prevState.ScenarioSimulationModel.simulation), { scesimData: {
                                Scenario: isBackground
                                    ? prevState.ScenarioSimulationModel.simulation.scesimData.Scenario
                                    : deepClonedRowsData,
                            } }), background: Object.assign(Object.assign({}, prevState.ScenarioSimulationModel.background), { scesimData: {
                                BackgroundData: isBackground
                                    ? deepClonedRowsData
                                    : prevState.ScenarioSimulationModel.background.scesimData.BackgroundData,
                            } }) }),
                };
            });
        });
    }, [columnIndexStart, isBackground, updateTestScenarioModel]);
    const getNextAvailablePrefixedName = useCallback((names, namePrefix, lastIndex = names.length) => {
        const candidate = `${namePrefix}-${lastIndex + 1}`;
        const elemWithCandidateName = names.indexOf(candidate);
        return elemWithCandidateName >= 0 ? getNextAvailablePrefixedName(names, namePrefix, lastIndex + 1) : candidate;
    }, []);
    const determineNewColumnTargetIndex = useCallback((factMappings, insertDirection, selectedColumnIndex, selectedColumnGroupType, selectedFactMapping) => {
        var _a, _b, _c, _d;
        const groupType = selectedFactMapping.expressionIdentifier.type.__$$text;
        const instanceName = selectedFactMapping.factIdentifier.name.__$$text;
        const instanceType = selectedFactMapping.factIdentifier.className.__$$text;
        if (selectedColumnGroupType === TestScenarioTableColumnFieldGroup.EXPECT ||
            selectedColumnGroupType === TestScenarioTableColumnFieldGroup.GIVEN) {
            if (insertDirection === InsertRowColumnsDirection.AboveOrRight) {
                return selectedColumnIndex + 1;
            }
            else {
                return selectedColumnIndex;
            }
        }
        let newColumnTargetColumn = -1;
        if (insertDirection === InsertRowColumnsDirection.AboveOrRight) {
            for (let i = selectedColumnIndex; i < factMappings.length; i++) {
                const currentFM = factMappings[i];
                if (currentFM.expressionIdentifier.type.__$$text === groupType &&
                    ((_a = currentFM.factIdentifier.name) === null || _a === void 0 ? void 0 : _a.__$$text) === instanceName &&
                    ((_b = currentFM.factIdentifier.className) === null || _b === void 0 ? void 0 : _b.__$$text) === instanceType) {
                    if (i == factMappings.length - 1) {
                        newColumnTargetColumn = i + 1;
                    }
                }
                else {
                    newColumnTargetColumn = i;
                    break;
                }
            }
        }
        else {
            for (let i = selectedColumnIndex; i >= 0; i--) {
                const currentFM = factMappings[i];
                if (currentFM.expressionIdentifier.type.__$$text === groupType &&
                    ((_c = currentFM.factIdentifier.name) === null || _c === void 0 ? void 0 : _c.__$$text) === instanceName &&
                    ((_d = currentFM.factIdentifier.className) === null || _d === void 0 ? void 0 : _d.__$$text) === instanceType) {
                    if (i == 0) {
                        newColumnTargetColumn = 0;
                    }
                }
                else {
                    newColumnTargetColumn = i + 1;
                    break;
                }
            }
        }
        return newColumnTargetColumn;
    }, [TestScenarioTableColumnFieldGroup]);
    const determineSelectedColumnIndex = useCallback((factMappings, originalSelectedColumnIndex, isInstance) => {
        var _a;
        if (isInstance) {
            const instanceSectionID = tableColumns.instancesGroup[originalSelectedColumnIndex - 1].id;
            return ((_a = factMappings.findIndex((factMapping) => {
                var _a;
                return ((_a = factMapping.expressionIdentifier.type) === null || _a === void 0 ? void 0 : _a.__$$text) + "." + factMapping.factIdentifier.name.__$$text ===
                    instanceSectionID;
            })) !== null && _a !== void 0 ? _a : -1);
        }
        return originalSelectedColumnIndex - (isBackground ? 1 : 0);
    }, [isBackground, tableColumns.instancesGroup]);
    const onColumnAdded = useCallback((args) => {
        if (TestScenarioTableColumnFieldGroup.OTHER === args.groupType) {
            return;
        }
        const isInstance = args.groupType === TestScenarioTableColumnInstanceGroup.EXPECT ||
            args.groupType === TestScenarioTableColumnInstanceGroup.GIVEN;
        updateTestScenarioModel((prevState) => {
            var _a;
            const factMappingList = retrieveModelDescriptor(prevState.ScenarioSimulationModel, isBackground).factMappings
                .FactMapping;
            const selectedColumnIndex = determineSelectedColumnIndex(factMappingList, args.currentIndex, isInstance);
            const selectedColumnFactMapping = factMappingList[selectedColumnIndex];
            const targetColumnIndex = determineNewColumnTargetIndex(factMappingList, args.insertDirection, selectedColumnIndex, args.groupType, selectedColumnFactMapping);
            const instanceDefaultNames = factMappingList
                .filter((factMapping) => factMapping.factAlias.__$$text.startsWith("INSTANCE-"))
                .map((factMapping) => factMapping.factAlias.__$$text);
            const isNewInstance = isInstance || ((_a = selectedColumnFactMapping.factIdentifier.className) === null || _a === void 0 ? void 0 : _a.__$$text) === "java.lang.Void";
            const newFactMapping = {
                className: { __$$text: "java.lang.Void" },
                columnWidth: { __$$text: 150 },
                expressionAlias: { __$$text: "PROPERTY" },
                expressionElements: isNewInstance
                    ? undefined
                    : {
                        ExpressionElement: [
                            {
                                step: {
                                    __$$text: selectedColumnFactMapping.expressionElements.ExpressionElement[0].step.__$$text,
                                },
                            },
                        ],
                    },
                expressionIdentifier: {
                    name: { __$$text: `_${uuid()}`.toLocaleUpperCase() },
                    type: { __$$text: selectedColumnFactMapping.expressionIdentifier.type.__$$text },
                },
                factAlias: {
                    __$$text: isNewInstance
                        ? getNextAvailablePrefixedName(instanceDefaultNames, "INSTANCE")
                        : selectedColumnFactMapping.factAlias.__$$text,
                },
                factIdentifier: {
                    name: {
                        __$$text: isNewInstance
                            ? getNextAvailablePrefixedName(instanceDefaultNames, "INSTANCE")
                            : selectedColumnFactMapping.factIdentifier.name.__$$text,
                    },
                    className: {
                        __$$text: isNewInstance ? "java.lang.Void" : selectedColumnFactMapping.factIdentifier.className.__$$text,
                    },
                },
                factMappingValueType: { __$$text: "NOT_EXPRESSION" },
            };
            const deepClonedFactMappings = JSON.parse(JSON.stringify(retrieveModelDescriptor(prevState.ScenarioSimulationModel, isBackground).factMappings.FactMapping));
            deepClonedFactMappings.splice(targetColumnIndex, 0, newFactMapping);
            const deepClonedRowsData = JSON.parse(JSON.stringify(retrieveRowsDataFromModel(prevState.ScenarioSimulationModel, isBackground)));
            deepClonedRowsData.forEach((scenario) => {
                scenario.factMappingValues.FactMappingValue.splice(args.beforeIndex + 1, 0, {
                    expressionIdentifier: {
                        name: { __$$text: newFactMapping.expressionIdentifier.name.__$$text },
                        type: { __$$text: newFactMapping.expressionIdentifier.type.__$$text },
                    },
                    factIdentifier: {
                        name: { __$$text: newFactMapping.factIdentifier.name.__$$text },
                        className: { __$$text: newFactMapping.factIdentifier.className.__$$text },
                    },
                    rawValue: { __$$text: "", "@_class": "string" },
                });
            });
            return {
                ScenarioSimulationModel: Object.assign(Object.assign({}, prevState.ScenarioSimulationModel), { simulation: {
                        scesimModelDescriptor: {
                            factMappings: {
                                FactMapping: isBackground
                                    ? prevState.ScenarioSimulationModel.simulation.scesimModelDescriptor.factMappings.FactMapping
                                    : deepClonedFactMappings,
                            },
                        },
                        scesimData: {
                            Scenario: isBackground
                                ? prevState.ScenarioSimulationModel.simulation.scesimData.Scenario
                                : deepClonedRowsData,
                        },
                    }, background: {
                        scesimModelDescriptor: {
                            factMappings: {
                                FactMapping: isBackground
                                    ? deepClonedFactMappings
                                    : prevState.ScenarioSimulationModel.background.scesimModelDescriptor.factMappings.FactMapping,
                            },
                        },
                        scesimData: {
                            BackgroundData: isBackground
                                ? deepClonedRowsData
                                : prevState.ScenarioSimulationModel.background.scesimData.BackgroundData,
                        },
                    } }),
            };
        });
    }, [
        determineNewColumnTargetIndex,
        determineSelectedColumnIndex,
        getNextAvailablePrefixedName,
        isBackground,
        updateTestScenarioModel,
        TestScenarioTableColumnFieldGroup,
        TestScenarioTableColumnInstanceGroup,
    ]);
    const onColumnDeleted = useCallback((args) => {
        updateTestScenarioModel((prevState) => {
            var _a;
            const isInstance = args.groupType === TestScenarioTableColumnInstanceGroup.EXPECT ||
                args.groupType === TestScenarioTableColumnInstanceGroup.GIVEN;
            const factMappings = retrieveModelDescriptor(prevState.ScenarioSimulationModel, isBackground).factMappings
                .FactMapping;
            const columnIndexToRemove = determineSelectedColumnIndex(factMappings, args.columnIndex + 1, isInstance);
            const factMappingToRemove = factMappings[columnIndexToRemove];
            const groupType = factMappingToRemove.expressionIdentifier.type.__$$text;
            const instanceName = factMappingToRemove.factIdentifier.name.__$$text;
            const instanceType = factMappingToRemove.factIdentifier.className.__$$text;
            const allFactMappingWithIndexesToRemove = isInstance
                ? factMappings
                    .map((factMapping, index) => {
                    var _a, _b;
                    if (factMapping.expressionIdentifier.type.__$$text === groupType &&
                        ((_a = factMapping.factIdentifier.name) === null || _a === void 0 ? void 0 : _a.__$$text) === instanceName &&
                        ((_b = factMapping.factIdentifier.className) === null || _b === void 0 ? void 0 : _b.__$$text) === instanceType) {
                        return { factMappingIndex: index, factMapping: factMapping };
                    }
                    else {
                        return {};
                    }
                })
                    .filter((item) => isNumber(item.factMappingIndex))
                : [{ factMappingIndex: args.columnIndex + columnIndexStart, factMapping: factMappingToRemove }];
            const deepClonedFactMappings = JSON.parse(JSON.stringify(retrieveModelDescriptor(prevState.ScenarioSimulationModel, isBackground).factMappings.FactMapping));
            deepClonedFactMappings.splice(allFactMappingWithIndexesToRemove[0].factMappingIndex, allFactMappingWithIndexesToRemove.length);
            const deepClonedRowsData = JSON.parse(JSON.stringify((_a = retrieveRowsDataFromModel(prevState.ScenarioSimulationModel, isBackground)) !== null && _a !== void 0 ? _a : []));
            deepClonedRowsData.forEach((rowData) => {
                allFactMappingWithIndexesToRemove.forEach((itemToRemove) => {
                    const factMappingValueColumnIndexToRemove = retrieveFactMappingValueIndexByIdentifiers(rowData.factMappingValues.FactMappingValue, itemToRemove.factMapping.factIdentifier, itemToRemove.factMapping.expressionIdentifier);
                    return {
                        factMappingValues: {
                            FactMappingValue: rowData.factMappingValues.FactMappingValue.splice(factMappingValueColumnIndexToRemove, 1),
                        },
                    };
                });
            });
            const firstIndexOnTheLeft = Math.min(...allFactMappingWithIndexesToRemove.map((item) => item.factMappingIndex));
            const selectedColumnIndex = firstIndexOnTheLeft > 0 ? firstIndexOnTheLeft - 1 : 0;
            updateSelectedColumnMetaData({
                factMapping: JSON.parse(JSON.stringify(deepClonedFactMappings[selectedColumnIndex])),
                index: firstIndexOnTheLeft,
                isBackground,
            });
            return {
                ScenarioSimulationModel: Object.assign(Object.assign({}, prevState.ScenarioSimulationModel), { simulation: {
                        scesimModelDescriptor: {
                            factMappings: {
                                FactMapping: isBackground
                                    ? prevState.ScenarioSimulationModel.simulation.scesimModelDescriptor.factMappings.FactMapping
                                    : deepClonedFactMappings,
                            },
                        },
                        scesimData: {
                            Scenario: isBackground
                                ? prevState.ScenarioSimulationModel.simulation.scesimData.Scenario
                                : deepClonedRowsData,
                        },
                    }, background: {
                        scesimModelDescriptor: {
                            factMappings: {
                                FactMapping: isBackground
                                    ? deepClonedFactMappings
                                    : prevState.ScenarioSimulationModel.background.scesimModelDescriptor.factMappings.FactMapping,
                            },
                        },
                        scesimData: {
                            BackgroundData: isBackground
                                ? deepClonedRowsData
                                : prevState.ScenarioSimulationModel.background.scesimData.BackgroundData,
                        },
                    } }),
            };
        });
    }, [
        updateTestScenarioModel,
        TestScenarioTableColumnInstanceGroup,
        isBackground,
        determineSelectedColumnIndex,
        columnIndexStart,
        updateSelectedColumnMetaData,
    ]);
    const onRowAdded = useCallback((args) => {
        if (isBackground) {
            throw new Error("Impossible state. Background table can have a single row only");
        }
        updateTestScenarioModel((prevState) => {
            var _a;
            const factMappings = (_a = prevState.ScenarioSimulationModel.simulation.scesimModelDescriptor.factMappings.FactMapping) !== null && _a !== void 0 ? _a : [];
            const factMappingValuesItems = factMappings.map((factMapping) => {
                return {
                    expressionIdentifier: {
                        name: { __$$text: factMapping.expressionIdentifier.name.__$$text },
                        type: { __$$text: factMapping.expressionIdentifier.type.__$$text },
                    },
                    factIdentifier: {
                        name: { __$$text: factMapping.factIdentifier.name.__$$text },
                        className: { __$$text: factMapping.factIdentifier.className.__$$text },
                    },
                    rawValue: { __$$text: "", "@_class": "string" },
                };
            });
            const newScenario = {
                factMappingValues: {
                    FactMappingValue: factMappingValuesItems,
                },
            };
            const deepClonedScenarios = JSON.parse(JSON.stringify(prevState.ScenarioSimulationModel.simulation.scesimData.Scenario));
            deepClonedScenarios.splice(args.beforeIndex, 0, newScenario);
            return {
                ScenarioSimulationModel: Object.assign(Object.assign({}, prevState.ScenarioSimulationModel), { simulation: Object.assign(Object.assign({}, prevState.ScenarioSimulationModel.simulation), { scesimData: {
                            Scenario: deepClonedScenarios,
                        } }) }),
            };
        });
    }, [isBackground, updateTestScenarioModel]);
    const onRowDeleted = useCallback((args) => {
        if (isBackground) {
            throw new Error("Impossible state. Background table can have a single row only");
        }
        updateTestScenarioModel((prevState) => {
            var _a;
            const deepClonedScenarios = JSON.parse(JSON.stringify((_a = prevState.ScenarioSimulationModel.simulation.scesimData.Scenario) !== null && _a !== void 0 ? _a : []));
            deepClonedScenarios.splice(args.rowIndex, 1);
            return {
                ScenarioSimulationModel: Object.assign(Object.assign({}, prevState.ScenarioSimulationModel), { simulation: Object.assign(Object.assign({}, prevState.ScenarioSimulationModel.simulation), { scesimData: Object.assign(Object.assign({}, prevState.ScenarioSimulationModel.simulation.scesimData), { Scenario: deepClonedScenarios }) }) }),
            };
        });
    }, [isBackground, updateTestScenarioModel]);
    const onRowDuplicated = useCallback((args) => {
        if (isBackground) {
            throw new Error("Impossible state. Background table can have a single row only");
        }
        updateTestScenarioModel((prevState) => {
            var _a;
            const clonedFactMappingValues = JSON.parse(JSON.stringify(prevState.ScenarioSimulationModel.simulation.scesimData.Scenario[args.rowIndex].factMappingValues
                .FactMappingValue));
            const factMappingValues = {
                factMappingValues: {
                    FactMappingValue: clonedFactMappingValues,
                },
            };
            const deepClonedScenarios = JSON.parse(JSON.stringify((_a = prevState.ScenarioSimulationModel.simulation.scesimData.Scenario) !== null && _a !== void 0 ? _a : []));
            deepClonedScenarios.splice(args.rowIndex, 0, factMappingValues);
            return {
                ScenarioSimulationModel: Object.assign(Object.assign({}, prevState.ScenarioSimulationModel), { simulation: Object.assign(Object.assign({}, prevState.ScenarioSimulationModel.simulation), { scesimData: Object.assign(Object.assign({}, prevState.ScenarioSimulationModel.simulation.scesimData), { Scenario: deepClonedScenarios }) }) }),
            };
        });
    }, [isBackground, updateTestScenarioModel]);
    const onDataCellClick = useCallback((_columnID) => {
        updateSelectedColumnMetaData(null);
    }, [updateSelectedColumnMetaData]);
    const onHeaderClick = useCallback((columnKey) => {
        var _a;
        console.log(columnKey);
        if (columnKey == TestScenarioTableColumnHeaderGroup.EXPECT ||
            columnKey == TestScenarioTableColumnHeaderGroup.GIVEN) {
            updateSelectedColumnMetaData(null);
            return;
        }
        const modelDescriptor = isBackground
            ? tableData.scesimModelDescriptor
            : tableData.scesimModelDescriptor;
        if (columnKey.startsWith(TestScenarioTableColumnFieldGroup.GIVEN.toUpperCase()) ||
            columnKey.toUpperCase().startsWith(TestScenarioTableColumnFieldGroup.EXPECT.toUpperCase())) {
            const selectedInstanceGroup = tableColumns.instancesGroup.find((instance) => instance.id === columnKey);
            if (((_a = selectedInstanceGroup === null || selectedInstanceGroup === void 0 ? void 0 : selectedInstanceGroup.columns) === null || _a === void 0 ? void 0 : _a.length) === 1 &&
                (selectedInstanceGroup === null || selectedInstanceGroup === void 0 ? void 0 : selectedInstanceGroup.columns[0].dataType) === "<Undefined>") {
                const propertyID = selectedInstanceGroup === null || selectedInstanceGroup === void 0 ? void 0 : selectedInstanceGroup.columns[0].id;
                let selectedFactMapping;
                let selectedFactIndex;
                if (propertyID) {
                    selectedFactMapping = modelDescriptor.factMappings.FactMapping.find((factMapping) => { var _a; return ((_a = factMapping.expressionIdentifier.name) === null || _a === void 0 ? void 0 : _a.__$$text) === propertyID; });
                    selectedFactIndex = selectedFactMapping
                        ? modelDescriptor.factMappings.FactMapping.indexOf(selectedFactMapping)
                        : -1;
                }
                const selectedColumnMetaData = {
                    factMapping: JSON.parse(JSON.stringify(selectedFactMapping)),
                    index: selectedFactIndex !== null && selectedFactIndex !== void 0 ? selectedFactIndex : -1,
                    isBackground: isBackground,
                };
                updateSelectedColumnMetaData(selectedColumnMetaData);
            }
            else {
                updateSelectedColumnMetaData(null);
            }
            return;
        }
        const selectedFactMapping = modelDescriptor.factMappings.FactMapping.find((factMapping) => { var _a; return ((_a = factMapping.expressionIdentifier.name) === null || _a === void 0 ? void 0 : _a.__$$text) == columnKey; });
        const selectedFactIndex = selectedFactMapping
            ? modelDescriptor.factMappings.FactMapping.indexOf(selectedFactMapping)
            : -1;
        const selectedColumnMetaData = {
            factMapping: JSON.parse(JSON.stringify(selectedFactMapping)),
            index: selectedFactIndex !== null && selectedFactIndex !== void 0 ? selectedFactIndex : -1,
            isBackground: isBackground,
        };
        updateSelectedColumnMetaData(selectedColumnMetaData !== null && selectedColumnMetaData !== void 0 ? selectedColumnMetaData : null);
    }, [
        TestScenarioTableColumnFieldGroup,
        TestScenarioTableColumnHeaderGroup,
        isBackground,
        tableColumns.instancesGroup,
        tableData,
        updateSelectedColumnMetaData,
    ]);
    return (_jsx("div", Object.assign({ className: "test-scenario-table" }, { children: _jsx(StandaloneBeeTable, { allowedOperations: allowedOperations, columns: tableColumns.allColumns, enableKeyboardNavigation: true, headerLevelCountForAppendingRowIndexColumn: 2, headerVisibility: BeeTableHeaderVisibility.AllLevels, isEditableHeader: false, isReadOnly: false, onCellUpdates: onCellUpdates, onColumnAdded: onColumnAdded, onColumnDeleted: onColumnDeleted, onDataCellClick: onDataCellClick, onDataCellKeyUp: onDataCellClick, onHeaderClick: onHeaderClick, onHeaderKeyUp: onHeaderClick, onRowAdded: onRowAdded, onRowDeleted: onRowDeleted, onRowDuplicated: onRowDuplicated, operationConfig: simulationOperationConfig, resizerStopBehavior: ResizerStopBehavior.SET_WIDTH_WHEN_SMALLER, rows: tableRows, scrollableParentRef: scrollableParentRef, shouldRenderRowIndexColumn: !isBackground, shouldShowColumnsInlineControls: true, shouldShowRowsInlineControls: !isBackground }) })));
}
export default TestScenarioTable;
//# sourceMappingURL=TestScenarioTable.js.map